/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.roominfo;

import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.yy.liveplatform.proto.nano.LpfLiveinfo;
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect;
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplate;
import com.yy.liveplatform.proto.nano.LpfUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.Sly;
import tv.athena.live.api.IDataCallback;
import tv.athena.live.api.roominfo.MicInfo;
import tv.athena.live.api.roominfo.RoomInfoApi;
import tv.athena.live.api.roominfo.RoomInfoWrapper;
import tv.athena.live.base.arch.IComponentViewModel;
import tv.athena.live.base.manager.CommonViewModel;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.basesdk.liveroom.ApplicationStatus;
import tv.athena.live.basesdk.thunderblotwrapper.AbscThunderEventListener;
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandleManager;
import tv.athena.live.component.business.roominfo.RoomInfoComponent;
import tv.athena.live.component.business.roominfo.RoomInfoViewModel$WhenMappings;
import tv.athena.live.component.business.roominfo.repository.RoomInfoRepository;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.ThreadSafeMutableLiveData;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.MessageResponse;
import tv.athena.service.api.ServiceFailResult;
import tv.athena.service.api.event.ServiceBroadcastEvent;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 c2\u00020\u00012\u00020\u0002:\u0001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0007J\u0006\u0010.\u001a\u00020)J\u0019\u0010/\u001a\u0004\u0018\u00010\u000f2\b\u00100\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u00101J\u0015\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00104J$\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\u00052\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001209J\u000e\u0010:\u001a\u00020;2\u0006\u00106\u001a\u00020\bJ\u0012\u0010<\u001a\u0004\u0018\u00010\u000f2\u0006\u0010=\u001a\u00020\u0005H\u0007J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0005H\u0002J\u0010\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u001a\u0010G\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u001a\u0010H\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u001a\u0010I\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u001a\u0010J\u001a\u00020)2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u0012\u0010K\u001a\u00020)2\b\u0010B\u001a\u0004\u0018\u00010CH\u0002J\b\u0010L\u001a\u00020)H\u0002J\u001a\u0010M\u001a\u00020;2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020OH\u0002J\u0018\u0010Q\u001a\u00020)2\u000e\u0010R\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010SH\u0002J\u0010\u0010T\u001a\u00020)2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020)2\u0006\u0010B\u001a\u00020CH\u0002J\u0012\u0010X\u001a\u00020)2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0007J\u000e\u0010[\u001a\u00020)2\u0006\u0010\\\u001a\u00020]J\u0010\u0010^\u001a\u00020)2\u0006\u0010_\u001a\u00020\u0005H\u0016J\u0010\u0010`\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010a\u001a\u00020)2\u0006\u0010F\u001a\u00020\u000fH\u0002J\u0010\u0010b\u001a\u00020)2\u0006\u00103\u001a\u00020\bH\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006d"}, d2={"Ltv/athena/live/component/business/roominfo/RoomInfoViewModel;", "Ltv/athena/live/basesdk/thunderblotwrapper/AbscThunderEventListener;", "Ltv/athena/live/base/arch/IComponentViewModel;", "()V", "lastNetworkType", "", "Ljava/lang/Integer;", "lastTimeStamp", "", "mCommonViewModel", "Ltv/athena/live/base/manager/CommonViewModel;", "mJsonParser", "Lcom/google/gson/Gson;", "mLastLinkMicInfos", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/yy/liveplatform/proto/nano/LpfLiveinterconnect$LiveInterconnectInfo;", "mLiveInfo", "Ltv/athena/live/utils/ThreadSafeMutableLiveData;", "Lcom/yy/liveplatform/proto/nano/LpfLiveinfo$LiveInfo;", "getMLiveInfo", "()Ltv/athena/live/utils/ThreadSafeMutableLiveData;", "setMLiveInfo", "(Ltv/athena/live/utils/ThreadSafeMutableLiveData;)V", "mRepository", "Ltv/athena/live/component/business/roominfo/repository/RoomInfoRepository;", "mRoomInfoListeners", "Ljava/util/ArrayList;", "Ltv/athena/live/api/roominfo/RoomInfoApi$RoomInfoListener;", "Lkotlin/collections/ArrayList;", "mRoomInfoWrapper", "Ltv/athena/live/api/roominfo/RoomInfoWrapper;", "mSidObserver", "Landroid/arch/lifecycle/Observer;", "micInfos", "", "getMicInfos", "()Ljava/util/Map;", "roomInfoWrapper", "getRoomInfoWrapper", "()Ltv/athena/live/api/roominfo/RoomInfoWrapper;", "addRoomInfoListener", "", "listener", "appStatus", "applicationStatus", "Ltv/athena/live/basesdk/liveroom/ApplicationStatus;", "destroy", "findLastMicInfoWithUid", "targetUid", "(Ljava/lang/Long;)Lcom/yy/liveplatform/proto/nano/LpfLiveinterconnect$LiveInterconnectInfo;", "getLiveRoomInfo", "sid", "(Ljava/lang/Long;)V", "getLiveRoomInfoByUid", "uid", "liveBzType", "callback", "Ltv/athena/live/api/IDataCallback;", "getLiveStatusByUid", "", "getMicInfo", "position", "getNetTypeString", "", "status", "handleLiveViewModule", "roomInfo", "Lcom/yy/liveplatform/proto/nano/LpfLiveroomtemplate$LiveRoomInfo;", "handlePositionMediaType", "lastItem", "item", "handlePositionMicUserInfoExtend", "handlePositionStatus", "handlePositionStreamStatus", "handlePositionVideoStatus", "handleRoomInfoUpdate", "initRoomInfo", "isSameAnchorInfo", "lastAnchorInfo", "Lcom/yy/liveplatform/proto/nano/LpfUser$UserInfo;", "newAnchorInfo", "notifyLinkMicChange", "newLiveInterConnectInfo", "", "notifyOutSide", "micInfo", "Ltv/athena/live/api/roominfo/MicInfo;", "notifyRoomInfoStatusChange", "onBroadcastGroupEvent", "event", "Ltv/athena/service/api/event/ServiceBroadcastEvent;", "onCreate", "component", "Ltv/athena/live/component/business/roominfo/RoomInfoComponent;", "onNetworkTypeChanged", "type", "removeRoomInfoListener", "updateLinkMicInfo", "updateRoomInfoWrapperSid", "Companion", "media_release"})
public final class RoomInfoViewModel
extends AbscThunderEventListener
implements IComponentViewModel {
    private final ArrayList<RoomInfoApi.RoomInfoListener> mRoomInfoListeners = new ArrayList();
    private final RoomInfoRepository mRepository = new RoomInfoRepository();
    @NotNull
    private ThreadSafeMutableLiveData<LpfLiveinfo.LiveInfo> mLiveInfo = new ThreadSafeMutableLiveData();
    private final ConcurrentHashMap<Integer, LpfLiveinterconnect.LiveInterconnectInfo> mLastLinkMicInfos = new ConcurrentHashMap();
    private final Gson mJsonParser = new Gson();
    private CommonViewModel mCommonViewModel;
    private final RoomInfoWrapper mRoomInfoWrapper = new RoomInfoWrapper(0, 0, false, null, 0L, null, null, 127, null);
    private long lastTimeStamp = -1L;
    private Integer lastNetworkType;
    private Observer<Long> mSidObserver = (Observer)new Observer<Long>(this){
        final /* synthetic */ RoomInfoViewModel this$0;

        public final void onChanged(@org.jetbrains.annotations.Nullable Long sid) {
            if (sid != null) {
                this.this$0.getLiveRoomInfo(sid);
                RoomInfoViewModel.access$updateRoomInfoWrapperSid(this.this$0, sid);
            }
        }
        {
            this.this$0 = roomInfoViewModel;
        }
    };
    private static final String TAG;
    private static final String FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST = "updateLiveRoomInfoBroadcast";
    public static final Companion Companion;

    @NotNull
    public final ThreadSafeMutableLiveData<LpfLiveinfo.LiveInfo> getMLiveInfo() {
        return this.mLiveInfo;
    }

    public final void setMLiveInfo(@NotNull ThreadSafeMutableLiveData<LpfLiveinfo.LiveInfo> threadSafeMutableLiveData) {
        Intrinsics.checkParameterIsNotNull(threadSafeMutableLiveData, (String)"<set-?>");
        this.mLiveInfo = threadSafeMutableLiveData;
    }

    @NotNull
    public final RoomInfoWrapper getRoomInfoWrapper() {
        ALog.i((String)TAG, (String)("getRoomInfoWrapper " + this.mRoomInfoWrapper));
        return this.mRoomInfoWrapper;
    }

    @NotNull
    public final Map<Integer, LpfLiveinterconnect.LiveInterconnectInfo> getMicInfos() {
        ALog.i((String)TAG, (String)("getRoomInfoWrapper " + this.mRoomInfoWrapper));
        return this.mLastLinkMicInfos;
    }

    public final void onCreate(@NotNull RoomInfoComponent component) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)component), (String)"component");
        ALog.i((String)TAG, (String)("onCreate(" + (Object)((Object)component) + ')'));
        Sly.Companion.subscribe((Object)this);
        ComponentContext componentContext = component.getComponentContext();
        this.mCommonViewModel = componentContext != null ? componentContext.getCommonViewModel() : null;
        ThunderHandleManager.INSTANCE.getMAthLiveThunderEventCallback().registerThunderEventListener((AbscThunderEventListener)this);
        this.initRoomInfo();
    }

    public final void destroy() {
        ALog.i((String)TAG, (String)"destroy");
        Sly.Companion.unSubscribe((Object)this);
        ThunderHandleManager.INSTANCE.getMAthLiveThunderEventCallback().unRegisterRtcEventListener((AbscThunderEventListener)this);
    }

    private final void initRoomInfo() {
        block0: {
            CommonViewModel commonViewModel = this.mCommonViewModel;
            if (commonViewModel == null) break block0;
            commonViewModel.observeSidForever(this.mSidObserver);
        }
    }

    private final void updateRoomInfoWrapperSid(long sid) {
        ALog.i((String)TAG, (String)("updateRoomInfoWrapperSid [commonSid :" + sid + "] -- [roomInfoWrapper.sid : " + this.mRoomInfoWrapper.getSid() + ']'));
        if (sid != this.mRoomInfoWrapper.getSid()) {
            this.mRoomInfoWrapper.setSid(sid);
            for (RoomInfoApi.RoomInfoListener listener : this.mRoomInfoListeners) {
                listener.onRoomInfoStatusChange(this.mRoomInfoWrapper);
            }
        }
    }

    public final void addRoomInfoListener(@org.jetbrains.annotations.Nullable RoomInfoApi.RoomInfoListener listener) {
        block1: {
            RoomInfoApi.RoomInfoListener roomInfoListener = listener;
            if (roomInfoListener == null) break block1;
            RoomInfoApi.RoomInfoListener roomInfoListener2 = roomInfoListener;
            boolean bl = false;
            boolean bl2 = false;
            RoomInfoApi.RoomInfoListener it = roomInfoListener2;
            boolean bl3 = false;
            if (!this.mRoomInfoListeners.contains(listener)) {
                ALog.i((String)TAG, (String)("addRoomInfoListener " + listener));
                this.mRoomInfoListeners.add(listener);
            }
        }
    }

    public final void removeRoomInfoListener(@org.jetbrains.annotations.Nullable RoomInfoApi.RoomInfoListener listener) {
        block1: {
            RoomInfoApi.RoomInfoListener roomInfoListener = listener;
            if (roomInfoListener == null) break block1;
            RoomInfoApi.RoomInfoListener roomInfoListener2 = roomInfoListener;
            boolean bl = false;
            boolean bl2 = false;
            RoomInfoApi.RoomInfoListener it = roomInfoListener2;
            boolean bl3 = false;
            if (this.mRoomInfoListeners.contains(listener)) {
                ALog.i((String)TAG, (String)("removeRoomInfoListener " + listener));
                this.mRoomInfoListeners.remove(listener);
            }
        }
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public final LpfLiveinterconnect.LiveInterconnectInfo getMicInfo(int position) {
        return this.mLastLinkMicInfos.get(position);
    }

    private final void handleRoomInfoUpdate(LpfLiveroomtemplate.LiveRoomInfo roomInfo) {
        try {
            if (roomInfo == null) {
                ALog.i((String)TAG, (String)"handleRoomInfoUpdate roomInfo == null");
                return;
            }
            if (this.mRoomInfoListeners.isEmpty()) {
                ALog.i((String)TAG, (String)"handleRoomInfoUpdate mRoomInfoListeners isEmpty");
                return;
            }
            CommonViewModel commonViewModel = this.mCommonViewModel;
            Long l = commonViewModel != null ? commonViewModel.getSid() : null;
            if (l == null || roomInfo.sid != l) {
                CommonViewModel commonViewModel2 = this.mCommonViewModel;
                ALog.i((String)TAG, (String)("handleRoomInfoUpdate is not the same sid " + "[roomInfo.sid : " + roomInfo.sid + "] " + "[mCommonViewModel.sid : " + (commonViewModel2 != null ? commonViewModel2.getSid() : null) + ']'));
                return;
            }
            ALog.i((String)TAG, (String)("handleRoomInfoUpdate \u5f53\u524d\u623f\u95f4\u623f\u4e3b\u7684 uid [anchorUid : " + roomInfo.anchorUid + ']'));
            CommonViewModel commonViewModel3 = this.mCommonViewModel;
            if (commonViewModel3 != null) {
                commonViewModel3.setRoomOwnerUid(Long.valueOf(roomInfo.anchorUid));
            }
            this.handleLiveViewModule(roomInfo);
            this.notifyRoomInfoStatusChange(roomInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            ALog.e((String)TAG, (String)"handleRoomInfoUpdate error", (Throwable)e);
        }
    }

    private final void handleLiveViewModule(LpfLiveroomtemplate.LiveRoomInfo roomInfo) {
        if (roomInfo.liveViewModule == null) {
            ALog.i((String)TAG, (String)"handleLiveViewModule \u5904\u7406\u89c2\u770b\u6a21\u5757 roomInfo.liveViewModule == null");
            return;
        }
        ALog.i((String)TAG, (String)("handleLiveViewModule  \u89c2\u770b\u6a21\u5757 [ type : " + roomInfo.liveViewModule.type));
        switch (roomInfo.liveViewModule.type) {
            case 1: {
                LpfLiveinterconnect.LiveInterconnectingInfo info = (LpfLiveinterconnect.LiveInterconnectingInfo)this.mJsonParser.fromJson(roomInfo.liveViewModule.info, LpfLiveinterconnect.LiveInterconnectingInfo.class);
                if (info == null) break;
                Intrinsics.checkExpressionValueIsNotNull((Object)info.connectInfos, (String)"info.connectInfos");
                this.notifyLinkMicChange(ArraysKt.toList((Object[])info.connectInfos));
                break;
            }
            case 2: {
                LpfLiveroomtemplate.LiveInterConnectingViewInfo info;
                LpfLiveroomtemplate.LiveInterConnectingViewInfo liveInterConnectingViewInfo = info = (LpfLiveroomtemplate.LiveInterConnectingViewInfo)this.mJsonParser.fromJson(roomInfo.liveViewModule.info, LpfLiveroomtemplate.LiveInterConnectingViewInfo.class);
                if ((liveInterConnectingViewInfo != null ? liveInterConnectingViewInfo.connectingInfo : null) == null) break;
                Intrinsics.checkExpressionValueIsNotNull((Object)info.connectingInfo.connectInfos, (String)"info.connectingInfo.connectInfos");
                this.notifyLinkMicChange(ArraysKt.toList((Object[])info.connectingInfo.connectInfos));
                break;
            }
            case 0: {
                this.notifyLinkMicChange(new ArrayList());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyLinkMicChange(List<LpfLiveinterconnect.LiveInterconnectInfo> newLiveInterConnectInfo) {
        if (newLiveInterConnectInfo == null) {
            ALog.i((String)TAG, (String)"notifyLinkMicChange \u901a\u77e5\u9ea6\u4f4d\u5217\u8868\u6570\u636e\u66f4\u65b0 newLiveInterConnectInfo == null");
            return;
        }
        if (newLiveInterConnectInfo.isEmpty()) {
            ALog.i((String)TAG, (String)"notifyLinkMicChange, \u9ea6\u4f4d\u5217\u8868\u6570\u636e\u4e3a\u7a7a streamer is over");
            for (LpfLiveinterconnect.LiveInterconnectInfo item : this.mLastLinkMicInfos.values()) {
                if (item.liveStatus != 1 || item.user == null) continue;
                LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)liveInterconnectInfo, (String)"item");
                this.notifyOutSide(new MicInfo(liveInterconnectInfo, MicInfo.MicStatus.VIDEO_CLOSE));
            }
            this.mLastLinkMicInfos.clear();
            return;
        }
        if (this.mLastLinkMicInfos.size() > newLiveInterConnectInfo.size()) {
            int lastMaxPosition = this.mLastLinkMicInfos.size();
            ALog.i((String)TAG, (String)("Crop mLastLinkMicInfoList because callBack size changed" + '[' + this.mLastLinkMicInfos.size() + " to " + newLiveInterConnectInfo.size() + ']'));
            ALog.i((String)TAG, (String)"**********************");
            int n = lastMaxPosition;
            int n2 = 1;
            while (n >= n2 && this.mLastLinkMicInfos.size() > newLiveInterConnectInfo.size()) {
                void position;
                this.mLastLinkMicInfos.remove((int)position);
                ALog.i((String)TAG, (String)("Del invalid position=" + (int)position));
                --position;
            }
            ALog.i((String)TAG, (String)"**********************");
        }
        for (LpfLiveinterconnect.LiveInterconnectInfo item : newLiveInterConnectInfo) {
            this.updateLinkMicInfo(item);
        }
    }

    private final void updateLinkMicInfo(LpfLiveinterconnect.LiveInterconnectInfo item) {
        int position = item.positionInfo.position;
        LpfLiveinterconnect.LiveInterconnectInfo lastItem = this.mLastLinkMicInfos.get(position);
        ALog.i((String)TAG, (String)"\n\n*********************************************************************************");
        LpfUser.UserInfo userInfo = item.user;
        ALog.i((String)TAG, (String)("updateLinkMicInfo,\u66f4\u65b0\u9ea6\u4f4d\u5404\u79cd\u72b6\u6001 \u4f4d\u7f6e [position: " + position + "] [uid: " + (userInfo != null ? Long.valueOf(userInfo.uid) : null) + ']'));
        ALog.i((String)TAG, (String)("updateLinkMicInfo \u9ea6\u4f4d\u4e0a\u4e00\u6b21\u5b58\u50a8\u7684\u4fe1\u606f \uff1a[lastItem:\n " + lastItem + ']'));
        ALog.i((String)TAG, (String)("updateLinkMicInfo \u9ea6\u4f4d\u6700\u65b0\u5b58\u50a8\u7684\u4fe1\u606f \uff1a [newItem:\n " + item + ']'));
        ALog.i((String)TAG, (String)"*********************************************************************************");
        this.handlePositionMediaType(lastItem, item);
        this.handlePositionVideoStatus(lastItem, item);
        this.handlePositionStatus(lastItem, item);
        this.handlePositionStreamStatus(lastItem, item);
        this.handlePositionMicUserInfoExtend(lastItem, item);
        ((Map)this.mLastLinkMicInfos).put(position, item);
    }

    private final void handlePositionMediaType(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo;
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo2 = item;
        ALog.i((String)TAG, (String)("handlePositionMediaType uid=" + ((liveInterconnectInfo = item) != null && (liveInterconnectInfo = liveInterconnectInfo.user) != null ? Long.valueOf(liveInterconnectInfo.uid) : null) + " mediaType=" + (liveInterconnectInfo2 != null ? Integer.valueOf(liveInterconnectInfo2.mediaType) : null)));
        if (lastItem != null && lastItem.mediaType != item.mediaType) {
            this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MEDIA_TYPE_CHANGE));
        }
    }

    private final void handlePositionVideoStatus(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo;
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo2;
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo3 = lastItem;
        ALog.i((String)TAG, (String)("************ handlePositionVideoStatus \u89c6\u9891\u6a21\u5757 pos=" + item.positionInfo.position + ' ' + "lastItem=" + ((liveInterconnectInfo2 = lastItem) != null && (liveInterconnectInfo2 = liveInterconnectInfo2.user) != null ? Long.valueOf(liveInterconnectInfo2.uid) : null) + " lastStatus=" + (liveInterconnectInfo3 != null ? Integer.valueOf(liveInterconnectInfo3.liveStatus) : null) + " ;" + " curItem=" + ((liveInterconnectInfo = item) != null && (liveInterconnectInfo = liveInterconnectInfo.user) != null ? Long.valueOf(liveInterconnectInfo.uid) : null) + ' ' + " curStatus=" + item.liveStatus));
        if (lastItem == null) {
            switch (item.liveStatus) {
                case 0: {
                    LpfLiveinterconnect.LivePositionInfo livePositionInfo = item.positionInfo;
                    ALog.i((String)TAG, (String)("handlePositionVideoStatus \u4f4d\u7f6e " + (livePositionInfo != null ? Integer.valueOf(livePositionInfo.position) : null) + " not in live"));
                    break;
                }
                case 1: {
                    if (item.user == null) break;
                    this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.VIDEO_OPEN));
                }
            }
            return;
        }
        if (RoomInfoViewModel.Companion.isSamePerson(lastItem, item)) {
            if (item.liveStatus == lastItem.liveStatus) {
                ALog.i((String)TAG, (String)"handlePositionVideoStatus \u89c6\u9891\u6a21\u5757 same person but status not change");
                return;
            }
            if (item.liveStatus != lastItem.liveStatus) {
                switch (item.liveStatus) {
                    case 0: {
                        if (lastItem.user == null) break;
                        this.notifyOutSide(new MicInfo(lastItem, MicInfo.MicStatus.VIDEO_CLOSE));
                        break;
                    }
                    case 1: {
                        if (item.user == null) break;
                        this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.VIDEO_OPEN));
                    }
                }
            }
            return;
        }
        if (lastItem.user != null) {
            ALog.i((String)TAG, (String)("handlePositionVideoStatus \u89c6\u9891\u6a21\u5757 \u901a\u77e5\u5173\u95ed\u4e0a\u4e00\u4e2a\u8fde\u9ea6\u8005\u89c6\u9891\u6a21\u5757 name=" + lastItem.user.uid));
            this.notifyOutSide(new MicInfo(lastItem, MicInfo.MicStatus.VIDEO_CLOSE));
        }
        if (item.liveStatus == 1 && item.user != null) {
            ALog.i((String)TAG, (String)"handlePositionVideoStatus \u89c6\u9891\u6a21\u5757 \u901a\u77e5\u6253\u5f00\u65b0\u7684\u8fde\u9ea6\u8005\u89c6\u9891\u6a21\u5757");
            this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.VIDEO_OPEN));
        }
    }

    private final void handlePositionStatus(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
        int currentPositionStatus = item.positionInfo.positionStatus;
        LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo = lastItem;
        Integer lastPositionStatus = liveInterconnectInfo != null && (liveInterconnectInfo = liveInterconnectInfo.positionInfo) != null ? Integer.valueOf(liveInterconnectInfo.positionStatus) : null;
        ALog.i((String)TAG, (String)("handlePositionStatus \u5904\u7406\u9ea6\u4f4d\u60c5\u51b5 [ lastPositionStatus: " + lastPositionStatus + " ]" + " [ currentPositionStatus : " + currentPositionStatus + ']'));
        Integer n = lastPositionStatus;
        if (n != null && n == currentPositionStatus) {
            return;
        }
        switch (currentPositionStatus) {
            case 0: {
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_EMPTY));
                break;
            }
            case 3: {
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.AUDIO_CLOSE));
                break;
            }
            case 2: {
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_LOCKED));
                break;
            }
            case 1: {
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.AUDIO_OPEN));
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_UNLOCK));
            }
        }
    }

    private final void handlePositionStreamStatus(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
        if (item.liveStatus != 1) {
            ALog.i((String)TAG, (String)("handlePositionStreamStatus \u5904\u7406\u9ea6\u4f4d\u5904\u4e8e\u524d\u540e\u53f0\u60c5\u51b5 position " + item.positionInfo.position + " the liveStatus is not living"));
            return;
        }
        if (lastItem != null && item.clientStreamStatus == lastItem.clientStreamStatus) {
            ALog.i((String)TAG, (String)("handlePositionStreamStatus \u5904\u7406\u9ea6\u4f4d\u5904\u4e8e\u524d\u540e\u53f0\u60c5\u51b5 position " + item.positionInfo.position + " the same clientStream"));
            return;
        }
        ALog.i((String)TAG, (String)("handlePositionStreamStatus \u5904\u7406\u9ea6\u4f4d\u5904\u4e8e\u524d\u540e\u53f0\u60c5\u51b5 position " + item.positionInfo.position + " clientStream " + item.clientStreamStatus));
        if (item.clientStreamStatus == 0) {
            this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_FOREGROUND));
        }
        if (item.clientStreamStatus == 2) {
            this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_BACKGROUND));
        }
    }

    private final void handlePositionMicUserInfoExtend(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
        block2: {
            LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo = lastItem;
            if ((liveInterconnectInfo != null ? liveInterconnectInfo.user : null) == null && item.user != null) {
                LpfLiveinterconnect.LivePositionInfo livePositionInfo = item.positionInfo;
                ALog.i((String)TAG, (String)("handlePositionMicInfoExtend \u5904\u7406\u9ea6\u4f4d\u62d3\u5c55\u5b57\u6bb5 [position: " + (livePositionInfo != null ? Integer.valueOf(livePositionInfo.position) : null) + ']'));
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_USER_INFO_CHANGE));
                return;
            }
            LpfUser.UserInfo userInfo = item.user;
            if (userInfo == null) break block2;
            LpfUser.UserInfo userInfo2 = userInfo;
            boolean bl = false;
            boolean bl2 = false;
            LpfUser.UserInfo it = userInfo2;
            boolean bl3 = false;
            LpfLiveinterconnect.LiveInterconnectInfo liveInterconnectInfo2 = lastItem;
            if (!StringsKt.equals$default((String)(liveInterconnectInfo2 != null && (liveInterconnectInfo2 = liveInterconnectInfo2.user) != null ? liveInterconnectInfo2.toString() : null), (String)it.toString(), (boolean)false, (int)2, null)) {
                ALog.i((String)TAG, (String)"handlePositionMicInfoExtend \u901a\u77e5\u9ea6\u4f4d\u7528\u6237 \u62d3\u5c55\u5b57\u6bb5\u53d8\u5316 ");
                this.notifyOutSide(new MicInfo(item, MicInfo.MicStatus.MIC_USER_INFO_CHANGE));
            }
        }
    }

    private final LpfLiveinterconnect.LiveInterconnectInfo findLastMicInfoWithUid(Long targetUid) {
        Map $this$forEach$iv = this.mLastLinkMicInfos;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            if (((LpfLiveinterconnect.LiveInterconnectInfo)it.getValue()).user == null) continue;
            Long l = targetUid;
            if (l == null || ((LpfLiveinterconnect.LiveInterconnectInfo)it.getValue()).user.uid != l) continue;
            return (LpfLiveinterconnect.LiveInterconnectInfo)it.getValue();
        }
        return null;
    }

    private final void notifyRoomInfoStatusChange(LpfLiveroomtemplate.LiveRoomInfo roomInfo) {
        LpfLiveinfo.ChannelLiveInfo it;
        boolean bl;
        boolean bl2;
        LpfLiveinfo.ChannelLiveInfo channelLiveInfo;
        boolean hasNotify = false;
        if (this.mRoomInfoWrapper.getSid() != roomInfo.sid) {
            ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange " + "[lastSid : " + this.mRoomInfoWrapper.getSid() + ']' + " [ newSid : " + roomInfo.sid));
            this.mRoomInfoWrapper.setSid(roomInfo.sid);
            hasNotify = true;
        }
        LpfLiveinfo.ChannelLiveInfo channelLiveInfo2 = roomInfo.channelInfo;
        this.mRoomInfoWrapper.setCoverUrl(channelLiveInfo2 != null ? channelLiveInfo2.uploadCoverUrl : null);
        if (this.mRoomInfoWrapper.getAnchorLiveStatus() != roomInfo.anchorLiveStatus) {
            ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange " + "[lastAnchorLiveStatus : " + this.mRoomInfoWrapper.getAnchorLiveStatus() + ']' + " [ newAnchorLiveStatus : " + roomInfo.anchorLiveStatus));
            this.mRoomInfoWrapper.setAnchorLiveStatus(roomInfo.anchorLiveStatus);
            hasNotify = true;
        }
        if (this.mRoomInfoWrapper.getBusinessType() != roomInfo.businessType) {
            ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange " + "[lastBusinessType : " + this.mRoomInfoWrapper.getBusinessType() + ']' + " [ newBusinessType : " + roomInfo.businessType + ']'));
            this.mRoomInfoWrapper.setBusinessType(roomInfo.businessType);
            hasNotify = true;
        }
        LpfLiveinfo.ChannelLiveInfo channelLiveInfo3 = roomInfo.channelInfo;
        if (channelLiveInfo3 != null) {
            channelLiveInfo = channelLiveInfo3;
            bl2 = false;
            bl = false;
            it = channelLiveInfo;
            boolean bl3 = false;
            if (this.mRoomInfoWrapper.getChannelClose() != it.channelClose) {
                ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange " + "[lastChannelClose : " + this.mRoomInfoWrapper.getChannelClose() + ']' + " [ newChannelClose : " + it.channelClose + ']'));
                this.mRoomInfoWrapper.setChannelClose(roomInfo.channelInfo.channelClose);
            }
            if (!this.mRoomInfoWrapper.getTitle().equals(it.title)) {
                ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange channelTitle : " + roomInfo.channelInfo.title));
                String string = roomInfo.channelInfo.title;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"roomInfo.channelInfo.title");
                this.mRoomInfoWrapper.setTitle(string);
                hasNotify = true;
            }
        }
        LpfUser.UserInfo userInfo = roomInfo.anchorUserInfo;
        if (userInfo != null) {
            channelLiveInfo = userInfo;
            bl2 = false;
            bl = false;
            it = channelLiveInfo;
            boolean bl4 = false;
            if (!this.isSameAnchorInfo(this.mRoomInfoWrapper.getAnchorInfo(), (LpfUser.UserInfo)it)) {
                ALog.i((String)TAG, (String)("notifyRoomInfoBroadcastChange " + "[lastAnchorInfo : " + this.mRoomInfoWrapper.getAnchorInfo() + " ]" + " [ newAnchorInfo : " + it + ']'));
                hasNotify = true;
            }
            this.mRoomInfoWrapper.setAnchorInfo(roomInfo.anchorUserInfo);
        }
        if (hasNotify) {
            for (RoomInfoApi.RoomInfoListener listener : this.mRoomInfoListeners) {
                listener.onRoomInfoStatusChange(this.mRoomInfoWrapper);
            }
        }
    }

    private final boolean isSameAnchorInfo(LpfUser.UserInfo lastAnchorInfo, LpfUser.UserInfo newAnchorInfo) {
        return lastAnchorInfo != null && lastAnchorInfo.uid == newAnchorInfo.uid;
    }

    private final void notifyOutSide(MicInfo micInfo) {
        LpfUser.UserInfo userInfo = micInfo.getInfo().user;
        ALog.i((String)TAG, (String)("notifyOutSide micInfo pos: " + micInfo.getInfo().positionInfo.position + " ; " + "uid: " + (userInfo != null ? Long.valueOf(userInfo.uid) : null) + " ; status: " + micInfo.getStatus() + " ; sid: " + micInfo.getInfo().sid));
        for (RoomInfoApi.RoomInfoListener listener : this.mRoomInfoListeners) {
            listener.onRoomInfoChange(micInfo);
        }
    }

    public final void getLiveRoomInfo(@org.jetbrains.annotations.Nullable Long sid) {
        if (sid == null) {
            ALog.i((String)TAG, (String)"getLiveRoomInfo sid == null");
            return;
        }
        if (sid <= 0L) {
            ALog.i((String)TAG, (String)("getLiveRoomInfo [sid : " + sid + "] is invalied"));
            return;
        }
        ALog.i((String)TAG, (String)("getLiveRoomInfo [sid : " + sid + ']'));
        this.mRepository.getLiveRoomInfo(sid, (IMessageCallback<LpfLiveroomtemplate.GetLiveRoomInfoResp>)((IMessageCallback)new IMessageCallback<LpfLiveroomtemplate.GetLiveRoomInfoResp>(this){
            final /* synthetic */ RoomInfoViewModel this$0;

            public void onMessageSuccess(@NotNull MessageResponse<LpfLiveroomtemplate.GetLiveRoomInfoResp> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                LpfLiveroomtemplate.GetLiveRoomInfoResp resp = (LpfLiveroomtemplate.GetLiveRoomInfoResp)response.getMessage();
                ALog.i((String)RoomInfoViewModel.access$getTAG$cp(), (String)("getLiveRoomInfo onMessageSuccess : [code : " + resp.code + "  " + " [ timeStamp : " + resp.timestamp + "  [ lastTimeStamp : " + RoomInfoViewModel.access$getLastTimeStamp$p(this.this$0) + "] "));
                if (RoomInfoViewModel.access$getLastTimeStamp$p(this.this$0) > resp.timestamp) {
                    return;
                }
                RoomInfoViewModel.access$handleRoomInfoUpdate(this.this$0, resp.liveRoomInfo);
                RoomInfoViewModel.access$setLastTimeStamp$p(this.this$0, resp.timestamp);
            }

            public void onMessageFail(@NotNull ServiceFailResult errorCode, @org.jetbrains.annotations.Nullable Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)errorCode, (String)"errorCode");
                ALog.i((String)RoomInfoViewModel.access$getTAG$cp(), (String)("getLiveRoomInfo error reason = " + errorCode));
            }

            @NotNull
            public LpfLiveroomtemplate.GetLiveRoomInfoResp get() {
                return new LpfLiveroomtemplate.GetLiveRoomInfoResp();
            }
            {
                this.this$0 = $outer;
            }
        }));
    }

    public final void getLiveRoomInfoByUid(long uid, int liveBzType, @NotNull IDataCallback<LpfLiveinfo.LiveInfo> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.mRepository.getLiveInfoByUidReq(uid, liveBzType, (IMessageCallback<LpfLiveinfo.GetLiveInfoByUidResp>)((IMessageCallback)new IMessageCallback<LpfLiveinfo.GetLiveInfoByUidResp>(callback){
            final /* synthetic */ IDataCallback $callback;

            public void onMessageSuccess(@NotNull MessageResponse<LpfLiveinfo.GetLiveInfoByUidResp> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                LpfLiveinfo.GetLiveInfoByUidResp rsp = (LpfLiveinfo.GetLiveInfoByUidResp)response.getMessage();
                if (rsp.code == 0 && rsp.liveInfo != null) {
                    LpfLiveinfo.LiveInfo info = rsp.liveInfo;
                    ALog.i((String)RoomInfoViewModel.access$getTAG$cp(), (String)("getLiveRoomInfoByUid success,liveInfo:" + info));
                    LpfLiveinfo.LiveInfo liveInfo = info;
                    Intrinsics.checkExpressionValueIsNotNull((Object)liveInfo, (String)"info");
                    this.$callback.onDataLoaded((Object)liveInfo);
                } else {
                    ALog.i((String)RoomInfoViewModel.access$getTAG$cp(), (String)("getLiveRoomInfoByUid fail [ code : " + rsp.code + " [message: " + rsp.message + ']'));
                    int n = rsp.code;
                    String string = rsp.message;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rsp.message");
                    this.$callback.onDataNotAvailable(n, string);
                }
            }

            public void onMessageFail(@NotNull ServiceFailResult errorCode, @org.jetbrains.annotations.Nullable Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)errorCode, (String)"errorCode");
                ALog.e((String)RoomInfoViewModel.access$getTAG$cp(), (String)"getLiveRoomInfoByUid fail", (Throwable)ex);
            }

            @NotNull
            public LpfLiveinfo.GetLiveInfoByUidResp get() {
                return new LpfLiveinfo.GetLiveInfoByUidResp();
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        }));
    }

    public final boolean getLiveStatusByUid(long uid) {
        for (LpfLiveinterconnect.LiveInterconnectInfo item : this.mLastLinkMicInfos.values()) {
            LpfUser.UserInfo userInfo = item.user;
            if (userInfo == null) continue;
            if (userInfo.uid != uid) continue;
            ALog.i((String)TAG, (String)("getLiveStatusByUid " + item.liveStatus));
            switch (item.liveStatus) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ALog.i((String)TAG, (String)"getLiveStatusByUid does not have");
        return false;
    }

    @MessageBinding
    public final void onBroadcastGroupEvent(@org.jetbrains.annotations.Nullable ServiceBroadcastEvent event) {
        if (event == null) {
            return;
        }
        try {
            LpfLiveroomtemplate.UpdateLiveRoomInfoBroadcast broadcast;
            if (Intrinsics.areEqual((Object)FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST, (Object)event.getFuncName()) && (broadcast = LpfLiveroomtemplate.UpdateLiveRoomInfoBroadcast.parseFrom((byte[])event.getMessage())) != null) {
                ALog.i((String)TAG, (String)("onBroadcastGroupEvent [ timeStamp : " + broadcast.timestamp + "]  " + "[lastTimeStamp : " + this.lastTimeStamp + "] "));
                if (this.lastTimeStamp > broadcast.timestamp) {
                    return;
                }
                this.handleRoomInfoUpdate(broadcast.liveRoomInfo);
                this.lastTimeStamp = broadcast.timestamp;
            }
        }
        catch (InvalidProtocolBufferNanoException e) {
            e.printStackTrace();
        }
    }

    @MessageBinding
    public final void appStatus(@NotNull ApplicationStatus applicationStatus) {
        Intrinsics.checkParameterIsNotNull((Object)applicationStatus, (String)"applicationStatus");
        ALog.i((String)TAG, (String)("appStatus [status : " + applicationStatus.getStatus() + ']'));
        switch (RoomInfoViewModel$WhenMappings.$EnumSwitchMapping$0[applicationStatus.getStatus().ordinal()]) {
            case 1: {
                ALog.i((String)TAG, (String)"appOnBackground");
                break;
            }
            case 2: {
                ALog.i((String)TAG, (String)"appOnForeground");
                CommonViewModel commonViewModel = this.mCommonViewModel;
                boolean bl = false;
                boolean bl2 = false;
                CommonViewModel it = commonViewModel;
                boolean bl3 = false;
                CommonViewModel commonViewModel2 = it;
                this.getLiveRoomInfo(commonViewModel2 != null ? commonViewModel2.getSid() : null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onNetworkTypeChanged(int type) {
        ALog.i((String)RoomInfoViewModel.TAG, (String)("onNetType: " + this.getNetTypeString(type)));
        v0 = this.lastNetworkType;
        var3_2 = 1;
        if (v0 != null && v0 == var3_2) ** GOTO lbl-1000
        v1 = this.lastNetworkType;
        var3_2 = 5;
        if (v1 != null && v1 == var3_2) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        lastInvalid = v2;
        v3 = curValid = type == 3 || type == 2 || type == 6 || type == 7;
        if (lastInvalid && curValid) {
            ALog.i((String)RoomInfoViewModel.TAG, (String)"Update roomInfo with network valid");
            this.getLiveRoomInfo(this.mRoomInfoWrapper.getSid());
        }
        this.lastNetworkType = type;
    }

    private final String getNetTypeString(int status) {
        String string;
        switch (status) {
            case 1: {
                string = "DISCONNECTED";
                break;
            }
            case 2: {
                string = "CABLE(\u6709\u7ebf\u7f51\u7edc)";
                break;
            }
            case 3: {
                string = "WIFI";
                break;
            }
            case 4: {
                string = "MOBILE(\u672a\u8bc6\u522b\u7684\u79fb\u52a8\u7f51\u7edc)";
                break;
            }
            case 5: {
                string = "2G";
                break;
            }
            case 6: {
                string = "3G";
                break;
            }
            case 7: {
                string = "4G";
                break;
            }
            default: {
                string = "UNKNOWN(" + status + ')';
            }
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        TAG = RoomInfoViewModel.class.getSimpleName();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ long access$getLastTimeStamp$p(RoomInfoViewModel $this) {
        return $this.lastTimeStamp;
    }

    public static final /* synthetic */ void access$setLastTimeStamp$p(RoomInfoViewModel $this, long l) {
        $this.lastTimeStamp = l;
    }

    public static final /* synthetic */ void access$handleRoomInfoUpdate(RoomInfoViewModel $this, LpfLiveroomtemplate.LiveRoomInfo roomInfo) {
        $this.handleRoomInfoUpdate(roomInfo);
    }

    public static final /* synthetic */ void access$updateRoomInfoWrapperSid(RoomInfoViewModel $this, long sid) {
        $this.updateRoomInfoWrapperSid(sid);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltv/athena/live/component/business/roominfo/RoomInfoViewModel$Companion;", "", "()V", "FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST", "", "TAG", "kotlin.jvm.PlatformType", "isSamePerson", "", "lastItem", "Lcom/yy/liveplatform/proto/nano/LpfLiveinterconnect$LiveInterconnectInfo;", "item", "media_release"})
    public static final class Companion {
        private final boolean isSamePerson(LpfLiveinterconnect.LiveInterconnectInfo lastItem, LpfLiveinterconnect.LiveInterconnectInfo item) {
            return lastItem != null && item != null && lastItem.sid != 0L && item.sid != 0L && lastItem.sid == item.sid && lastItem.user != null && item.user != null && item.user.uid != 0L && lastItem.user.uid != 0L && lastItem.user.uid == item.user.uid;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

