/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import tv.athena.live.utils.ALog;
import tv.athena.util.FP;
import tv.athena.util.encode.Base64Utils;

public class WebViewUtils {
    public static String handleImageToBase64JsonStr(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.length; ++i) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPaths[i], 1280, 720);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i((String)"handleImageToBase64JsonStr", (String)("[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length()));
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static String handleImageToBase64JsonStr(List<String> clipPaths) {
        return WebViewUtils.handleImageToBase64JsonStrWithCompress(clipPaths, 1280, 720);
    }

    public static String handleImageToBase64JsonStrWithCompress(List<String> clipPaths, int reqWidth, int reqHeight) {
        if (clipPaths != null && clipPaths.size() > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.size(); ++i) {
                JSONObject jsonObject = WebViewUtils.handleImageToBase64(clipPaths.get(i), reqWidth, reqHeight);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i((String)"handleImageToBase64JsonStr", (String)("[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length()));
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static JSONObject handleImageToBase64(String imgPath, int reqWidth, int reqHeight) {
        if (FP.empty((CharSequence)imgPath)) {
            ALog.w((String)"handleImageToBase64", (String)"[handleImageToBase64].imgPath is null");
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            ALog.i((String)"handleImageToBase64", (String)("[handleImageToBase64].Img origin  w=" + options.outWidth + ",h=" + options.outHeight + ",reqw=" + reqWidth + ",reqh=" + reqHeight + ",simple=" + options.inSampleSize));
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            int pos = imgPath.lastIndexOf(".");
            String suffix = null;
            if (pos + 1 < imgPath.length()) {
                suffix = imgPath.substring(pos + 1, imgPath.length());
            }
            if (!FP.empty(suffix) && (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg"))) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 80, baos);
            }
            String base64Img = Base64Utils.encodeToString((byte[])((ByteArrayOutputStream)baos).toByteArray(), (int)2);
            ALog.i((String)"handleImageToBase64", (String)("[handleImageToBase64].Img now w=" + options.outWidth + ",h=" + options.outHeight + ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() + ",base64Img=" + base64Img.substring(0, 50)));
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    ALog.e((String)"handleImageToBase64", (String)"[handleImageToBase64].IOException=", (Throwable)e);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            ALog.e((String)"handleImageToBase64", (String)("[handleImageToBase64].e=" + t + ",imgs=" + imgPath), (Throwable)t);
        }
        return bitmapJsonObject;
    }

    public static JSONObject handleImgThumbnailToBase64(String imgPath) {
        if (FP.empty((CharSequence)imgPath)) {
            ALog.w((String)"handleImgThumbnailToBase64", (String)"[ReturnBase64ImgToWeb].imgPath is null");
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        try {
            int be;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            ALog.i((String)"handleImgThumbnailToBase64", (String)("[ReturnBase64ImgToWeb].Img origin  w=" + options.outWidth + ",h=" + options.outHeight));
            int beWidth = options.outWidth / 512;
            int beHeight = options.outHeight / 512;
            int n = be = beWidth < beHeight ? beWidth : beHeight;
            if (be <= 0) {
                be = 1;
            }
            options.inSampleSize = be;
            baos = new ByteArrayOutputStream();
            bitmap = BitmapFactory.decodeFile((String)imgPath, (BitmapFactory.Options)options);
            if (imgPath.endsWith("jpg") || imgPath.endsWith("jpeg")) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
            }
            String base64Img = Base64Utils.encodeToString((byte[])((ByteArrayOutputStream)baos).toByteArray(), (int)2);
            ALog.i((String)"handleImgThumbnailToBase64", (String)("[ReturnBase64ImgToWeb].Img now w=" + options.outWidth + ",h=" + options.outHeight + ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() + ",base64Img=" + base64Img.substring(0, 50)));
            bitmapJsonObject = new JSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    ALog.e((String)"handleThumbnailRetToWeb", (String)"[handleThumbnailRetToWeb].IOException=", (Throwable)e);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            ALog.e((String)"handleThumbnailRetToWeb", (String)("[handleThumbnailRetToWeb].e=" + t + ",imgs=" + imgPath), (Throwable)t);
        }
        return bitmapJsonObject;
    }
}

