package tv.athena.live.component.business.videoarea;

import tv.athena.live.api.videoarea.VideoAreaComponentApi;
import tv.athena.live.base.mvvmImpl.MvvmComponent;

/**
 * Created by qiushunming on 2019-08-07.
 */

public class VideoAreaComponent extends MvvmComponent<VideoAreaComponentApi, VideoAreaView, VideoAreaViewModel> {
    private VideoAreaViewModel vm = null;

    @Override
    public void onAllComponentsReady() {
        mViewModel.onAllComponentsReady();
    }

    @Override
    protected VideoAreaComponentApi onCreateApi() {
        return new VideoApiImpl(this);
    }

    @Override
    protected VideoAreaView onCreateView() {
        return new VideoAreaView(mComponentContext);
    }

    @Override
    protected VideoAreaViewModel onCreateViewModel() {
        vm = new VideoAreaViewModel();
        vm.setComponent(this);
        return vm;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (vm != null) {
            vm.onCreate(this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mViewModel.destroy();
    }

    @Override
    public void onLeave() {
    }
}
