package tv.athena.live.component.business.roomInfov2

import com.yy.liveplatform.proto.nano.LpfLiveroomtemplateV2
import tv.athena.live.api.roominfov2.RoomInfoV2Api
import tv.athena.live.base.arch.IComponentApi
import tv.athena.live.utils.RoomInfoV2Repository
import tv.athena.live.utils.ServiceUtils

/**
 * @desc :
 */
class RoomInfoV2ApiImpl(private val mComponent: RoomInfoV2Component) : RoomInfoV2Api {

    override fun getApiKey(): Class<out IComponentApi> {
        return RoomInfoV2Api::class.java
    }

    override fun getLiveRoomInfoRespV2(streamRoomId: String) {
        mComponent.viewModel.getLiveRoomInfoRespV2(streamRoomId)
    }

    override fun addRoomInfoV2Listener(
        roomInfoV2Listener:
        RoomInfoV2Api.RoomInfoV2Listener
    ) {
        mComponent.viewModel.addRoomInfoV2Listener(roomInfoV2Listener)
    }

    override fun removeRoomInfoV2Listener(
        roomInfoV2Listener:
        RoomInfoV2Api.RoomInfoV2Listener
    ) {
        mComponent.viewModel.removeRoomInfoV2Listener(roomInfoV2Listener)
    }

    override fun batchGetLiveRoomInfoReqV2(
        streamRoomIds: Array<String>,
        callback: ServiceUtils
        .SvcResultCusRetryCallBack
        <LpfLiveroomtemplateV2.BatchGetLiveRoomInfoRespV2>
    ) {
        RoomInfoV2Repository.batchGetLiveRoomInfoReqV2(streamRoomIds, callback)
    }

    override fun handleRoomInfoV2(roomInfoV2: LpfLiveroomtemplateV2.LiveRoomInfoV2) {
        mComponent.viewModel.handleRoomInfoV2(roomInfoV2)
    }
}
