package tv.athena.live.component.business.link_mic

import android.arch.lifecycle.LifecycleOwner
import android.arch.lifecycle.Observer
import android.view.ViewGroup
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect
import com.yy.liveplatform.proto.nano.LpfMedia
import tv.athena.live.api.IDataCallback
import tv.athena.live.api.link_mic.ILinkMicApi
import tv.athena.live.base.arch.IComponentApi

/**
 *  create by chenhaofeng 2019/8/27
 */
class LinkMicApiImpl : ILinkMicApi {

    private var mLinkMicViewModel: LinkMicViewModel? = null
    private var mLinkMicView: LinkMicView? = null
    private var mLinkMicComponent: LinkMicComponent? = null

    fun setComponent(component: LinkMicComponent) {
        this.mLinkMicComponent = component
        this.mLinkMicView = component.view
        this.mLinkMicViewModel = component.viewModel
    }

    override fun getApiKey(): Class<out IComponentApi> {
        return ILinkMicApi::class.java
    }

    override fun getInterConnectUserList(
        callBack: IDataCallback<LpfLiveinterconnect.GetInterconnectUserListResp>?
    ) {
        mLinkMicViewModel?.getInterConnectUserList(callBack)
    }

    override fun sendInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        position: Int,
        businessType: Int,
        extend: String?,
        callback: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.sendInviteReq(inviteUid, inviteSid, position, businessType, LpfMedia.MT_NONE,
            extend, callback)
    }

    override fun sendInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        position: Int,
        businessType: Int,
        mediaType: Int,
        extend: String?,
        callback: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.sendInviteReq(inviteUid, inviteSid, position, businessType, mediaType, extend, callback)
    }

    /**
     * 发送批量邀请
     */
    override fun sendBatchInviteReq(
        inviteUidArray: LongArray,
        inviteSid: Long,
        startPosition: Int,
        extend: String?,
        businessType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.BatchInviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.sendBatchInviteReq(inviteUidArray, inviteSid, startPosition, extend, businessType, callBack)
    }

    override fun cancelInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        businessType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.cancelSendInviteReq(inviteUid, inviteSid, businessType, callBack)
    }

    override fun acceptInviteLiveInterconnectReq(
        replyInviteUserInfo: LpfLiveinterconnect.LiveInterconnectInfo,
        businessType: Int,
        position: Int,
        extend: String?,
        callBack: IDataCallback<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.acceptInviteLiveInterconnectReq(
            replyInviteUserInfo, businessType, position, LpfMedia.MT_AV, extend, callBack)
    }

    override fun acceptInviteLiveInterconnectReq(
        replyInviteUserInfo: LpfLiveinterconnect.LiveInterconnectInfo,
        businessType: Int,
        position: Int,
        mediaType: Int,
        extend: String?,
        callBack:
        IDataCallback<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.acceptInviteLiveInterconnectReq(
            replyInviteUserInfo, businessType, position, mediaType, extend, callBack)
    }

    override fun refuseInviteLiveInterconnectReq(
        replyInviteUserInfo: LpfLiveinterconnect.LiveInterconnectInfo,
        businessType: Int,
        position: Int,
        isAutoReject: Boolean,
        callBack: IDataCallback<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.refuseInviteLiveInterconnectReq(replyInviteUserInfo, businessType,
            position, isAutoReject, callBack)
    }

    override fun closeLiveInterconnectReq(
        closeUid: Long,
        businessType: Int,
        callback: IDataCallback<LpfLiveinterconnect.CloseLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.closeLiveInterconnectReq(closeUid, businessType, callBack = callback)
    }

    override fun closeLiveInterconnectReq(
        closeUid: Long,
        businessType: Int,
        extend: String?,
        callback: IDataCallback<LpfLiveinterconnect.CloseLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.closeLiveInterconnectReq(closeUid, businessType, extend, callback)
    }

    override fun switchVideoContainer(sid: String, remoteUid: String, viewContainer: ViewGroup, businessType: Int) {
        mLinkMicViewModel?.switchVideoContainer(sid, remoteUid, viewContainer, businessType)
    }

    override fun applyConnectReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callback: IDataCallback<LpfLiveinterconnect.ApplyConnectResp>?
    ) {
        mLinkMicViewModel?.applyConnectReq(anchorUid, businessType, sid, callback)
    }

    override fun cancelApplyConnectReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callback: IDataCallback<LpfLiveinterconnect.ApplyConnectResp>?
    ) {
        mLinkMicViewModel?.cancelApplyConnectReq(anchorUid, businessType, sid, callback)
    }

    /**
     * 获取观众申请连麦列表
     */
    override fun getApplyConnectListReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callBack: IDataCallback<LpfLiveinterconnect.GetApplyConnectListResp>?
    ) {
        mLinkMicViewModel?.getApplyConnectListReq(anchorUid, businessType, sid, callBack)
    }

    /**
     * 监听连麦申请列表变化
     */
    override fun observeApplyListUpdateEvent(
        owner: LifecycleOwner,
        observer: Observer<LpfLiveinterconnect.ApplyConnectUpdateUnicast>
    ) {
        mLinkMicViewModel?.observeApplyListUpdateEvent(owner, observer)
    }

    /**
     * 上麦方法，观众使用该方法进行上麦操作
     */
    override fun takeMic(
        uid: String,
        isEnable: Boolean,
        businessType: Int,
        callBack: IDataCallback<Int>?
    ) {
        mLinkMicViewModel?.takeMic(uid, isEnable, businessType, callBack)
    }

    override fun opLivePositionReq(
        opUid: Long,
        opPosition: Int,
        opObject: Int,
        opType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.OpLivePositionResp>?
    ) {
        mLinkMicViewModel?.opLivePositionReq(opUid, opPosition, opObject, opType, callBack)
    }

    override fun directLiveInterconnectReq(
        businessType: Int,
        mediaType: Int,
        connectTuple: Array<LpfLiveinterconnect.ConnectTuple>,
        callBack: IDataCallback<LpfLiveinterconnect.DirectLiveInterconnectResp>?
    ) {
        mLinkMicViewModel?.directLiveInterconnectReq(businessType, mediaType, connectTuple, callBack)
    }
}