package tv.athena.live.component.business.link_mic

import android.os.CountDownTimer
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect
import tv.athena.live.utils.ServiceUtils
import tv.athena.live.component.business.link_mic.repository.LinkMicRepository
import tv.athena.live.utils.ALog
import tv.athena.service.api.MessageResponse
import tv.athena.service.api.ServiceFailResult

/**
 *     create by chenhaofeng 2019/9/26
 *
 *
 **/
class LinkHeartCountDownUtil(
    private val millisInFuture: Long,
    private val countDownInterval: Long,
    private val linkMicRepository: LinkMicRepository
) :
    CountDownTimer(millisInFuture, countDownInterval) {
    var mBusinessType = -1
    var mSid = -1L
    var mConnectStatus: StatusListener? = null
    var hasStart = false

    fun start(sid: Long, businessType: Int, listener: StatusListener) {
        this.mBusinessType = businessType
        this.mSid = sid
        this.mConnectStatus = listener
        if (hasStart) {
            ALog.i("LinkMicViewModel", "linkHeartCountDown already start")
            return
        }
        this.start()
        hasStart = true
    }

    override fun onFinish() {
        mBusinessType = -1
        mSid = -1
        mConnectStatus = null
        hasStart = false
        ALog.i("LinkMicViewModel", "linkHeartCountDown finish")
    }

    override fun onTick(p0: Long) {
        pingLinkHeart()
    }

    private fun pingLinkHeart() {
        if (mSid == -1L) {
            ALog.i("LinkMicViewModel", "pingLinkHeart mSid = -1")
            return
        }
        val req = LpfLiveinterconnect.LiveInterconnectHeartbeatReq()
        req.sid = mSid!!
        req.businessType = mBusinessType
        linkMicRepository.liveInterConnectHeartBeatReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .LiveInterconnectHeartbeatResp>() {
                override fun get(): LpfLiveinterconnect.LiveInterconnectHeartbeatResp {
                    return LpfLiveinterconnect.LiveInterconnectHeartbeatResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    // todo 心跳失败处理
                    ALog.d("LinkMicViewModel", "pingLiveInterconnectHeartbeat " +
                        "onMessageFail [code : ${errorCode.getResultCode()}]")
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.LiveInterconnectHeartbeatResp>
                ) {
                    val connectStatus = response.message.connectStatus
                    ALog.i("LinkMicViewModel",
                        "pingLiveInterconnectHeartbeat onMessageSuccess " +
                            "[code : ${response.message.code}]" +
                            "[connectStatus : $connectStatus]")
                    mConnectStatus?.connectStatus(connectStatus)
                }
            })
    }

    interface StatusListener {
        fun connectStatus(status: Int)
    }
}