package tv.athena.live.component.business.broadcasting.accessibility.audioFilePlayer

import android.os.Handler
import android.os.Looper
import com.thunder.livesdk.ThunderAudioFilePlayer
import tv.athena.live.api.broadcast.IAudioFilePlayer
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle
import tv.athena.live.utils.ALog

/**
 *     create by chenhaofeng 2019/9/28
 *
 *
 **/
class AudioFilePlayerImpl(private val thunderHandle: ThunderHandle?) : IAudioFilePlayer {

    val players = HashMap<String, ThunderAudioFilePlayer?>()
    private val mHandler = Handler(Looper.getMainLooper())

    companion object {
        const val INVALID = -1
        const val SUCCESS = 0
        const val TAG = "AudioFilePlayerImpl"
    }

    override fun play(audioPath: String): Int {
        return play(audioPath, null, true)
    }

    override fun play(
        audioPath: String,
        callback: ThunderAudioFilePlayer.IThunderAudioFilePlayerCallback?,
        enablePublish: Boolean?
    ): Int {
        ALog.i(TAG, "play $audioPath, $callback")
        var player: ThunderAudioFilePlayer?
        if (players.containsKey(audioPath)) {
            player = players[audioPath]
        } else {
            player = thunderHandle?.createAudioFilePlayer()
            //这里面结果 通过 IThunderAudioFilePlayerCallback 返回
            player?.open(audioPath)
            players[audioPath] = player
            ALog.i(TAG, "play ($audioPath)")
        }
        callback?.let {
            ALog.i(TAG, "play setPlayerNotify($it)")
            player?.setPlayerNotify(it)
        }
        player?.play()
        enablePublish?.let {
            ALog.i(TAG, "play enablePublish($it)")
            player?.enablePublish(true)
        }
        return SUCCESS
    }

    override fun enablePublish(
        audioPath: String,
        enablePublish: Boolean
    ): Int {
        ALog.i(TAG, "enablePublish ($audioPath)")
        return players[audioPath]?.let {
            it.enablePublish(enablePublish)
            ALog.i(TAG, "enablePublish success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "enablePublish failed players don't container")
            INVALID
        }
    }

    override fun pause(audioPath: String): Int {
        return players[audioPath]?.let {
            it.pause()
            ALog.i(TAG, "pause ($audioPath) success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "pause failed players don't container")
            INVALID
        }
    }

    override fun resume(audioPath: String): Int {
        return players[audioPath]?.let {
            it.resume()
            ALog.i(TAG, "resume ($audioPath) success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "resume failed players don't container")
            INVALID
        }
    }

    override fun stop(audioPath: String): Int {
        return players[audioPath]?.let {
            it.stop()
            ALog.i(TAG, "stop ($audioPath) success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "stop failed players don't container")
            INVALID
        }
    }

    override fun close(audioPath: String): Int {
        return players[audioPath]?.let {
            it.close()
            ALog.i(TAG, "close ($audioPath) success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "close failed players don't container")
            INVALID
        }
    }

    override fun setPlayerNotify(
        audioPath: String,
        callback: ThunderAudioFilePlayer.IThunderAudioFilePlayerCallback
    ): Int {
        return players[audioPath]?.let {
            it.setPlayerNotify(callback)
            ALog.i(TAG, "setPlayerNotify ($audioPath, $callback) success")
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "setPlayerNotify failed players don't container")
            INVALID
        }
    }

    override fun getCurrentPlayTimeMS(audioPath: String): Long? {
        return players[audioPath]?.currentPlayTimeMS
    }

    override fun getTotalPlayTimeMS(audioPath: String): Long? {
        return players[audioPath]?.totalPlayTimeMS
    }

    override fun destroyAudioFilePlayer() {
        ALog.i(TAG, "destroyAudioFilePlayer ")
        players.forEach {
            thunderHandle?.destroyAudioFilePlayer(players[it.key]!!)
        }
        players.clear()
    }

    override fun destroyAudioFilePlayer(audioPath: String): Int {
        return players[audioPath]?.let {
            ALog.i(TAG, "destroyAudioFilePlayer ($audioPath) ; player = $it")
            thunderHandle?.destroyAudioFilePlayer(it)
            SUCCESS
        } ?: kotlin.run {
            ALog.i(TAG, "destroyAudioFilePlayer failed players don't container")
            INVALID
        }
    }

    override fun setPlayVolume(audioPath: String, volume: Int) {
        ALog.i(TAG, "setPlayVolume $audioPath, $volume ")
        players[audioPath]?.setPlayVolume(volume)
    }

    @Deprecated(message = "该方法统一通过 play(..., callback ) 方法设置")
    override fun addAudioPlayerCallback(
        audioPath: String,
        callback: IAudioFilePlayer.AudioPlayerCallback
    ) {
        players[audioPath]?.setPlayerNotify(object :
            ThunderAudioFilePlayer.IThunderAudioFilePlayerCallback {
            override fun onAudioFileSeekComplete(millisecond: Int) {
            }

            override fun onAudioFilePlayError(errorCode: Int) {
            }

            override fun onAudioFilePause() {
            }

            override fun onAudioFilePlaying() {
            }

            override fun onAudioFileResume() {
            }

            override fun onAudioFileStop() {
            }

            override fun onAudioFilePlayEnd() {
                callback.onAudioFilePlayEnd()
                mHandler.post {
                    ALog.i(TAG, "AudioFilePlayerImpl  onAudioFilePlay Stop ${Thread.currentThread()}")
                    players[audioPath]?.stop()
                }
            }

            override fun onAudioFileVolume(volume: Long, currentMs: Long, totalMs: Long) {
                callback.onAudioFileVolume(volume, currentMs, totalMs)
            }
        })
    }
}