package tv.athena.live.component.business.audience.repository.service.impl;

import android.arch.lifecycle.MutableLiveData;

import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.yy.liveplatform.proto.nano.LpfChannel;
import com.yy.liveplatform.proto.nano.LpfUser;

import java.util.Arrays;
import java.util.List;

import tv.athena.live.component.business.audience.repository.service.IAudienceService;
import tv.athena.live.utils.ServiceUtils;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.event.ServiceBroadcastEvent;

/**
 * liaojidong
 *
 * @Data 2019/8/21
 */
public class AudienceService implements IAudienceService {
    private static final String FUNC_GET_CHANNEL_USERS = "getChannelUsers";
    //此处广播会回调所有，包括频道的用户信息，具体可以咨询 后端 杨雨建
    private static final String FUNC_CHANNEL_USER_NOTICE_BROADCAST = "channelUserNoticeBroadcast";
    //此处广播只是回调，频道内的总人数
    private static final String FUNC_CHANNEL_USER_COUNT_BROADCAST = "channelUserCountBroadcast";
    private static final String SERVICE_NAME = "lpfChannel";

    @Override
    public void getChannelUsers(LpfChannel.GetChannelUsersReq req,
                                IMessageCallback<LpfChannel.GetChannelUsersResp> callback) {
        ServiceUtils.ServiceReq serviceReq = new ServiceUtils.ServiceReq();
        serviceReq.mReqParam = req;
        serviceReq.mFunctionName = FUNC_GET_CHANNEL_USERS;
        serviceReq.mServerName = SERVICE_NAME;
        ServiceUtils.send(serviceReq, callback);
    }

    public boolean handleUserNoticeBroadcast(
        MutableLiveData<List<LpfUser.UserInfo>> users,
        MutableLiveData<String> userCount,
        ServiceBroadcastEvent event
    ) {
        if (event == null) {
            return false;
        }
        try {
            if (FUNC_CHANNEL_USER_NOTICE_BROADCAST.equals(event.getFuncName())) {
                LpfChannel.ChannelUserNoticeBroadcast broadcast = LpfChannel.ChannelUserNoticeBroadcast
                    .parseFrom(event.getMessage());
                users.setValue(Arrays.asList(broadcast.users));
                //userCount.setValue(broadcast.userCount);
                return true;
            }

            if (FUNC_CHANNEL_USER_COUNT_BROADCAST.equals(event.getFuncName())) {
                LpfChannel.ChannelUserCountBroadcast broadcast = LpfChannel.ChannelUserCountBroadcast
                    .parseFrom(event.getMessage());
                userCount.setValue(String.valueOf(broadcast.userCount));
            }
        } catch (InvalidProtocolBufferNanoException e) {
            e.printStackTrace();
        }
        return false;
    }
}
