package tv.athena.live.component.business.activitybar.webview.util;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * Created by jianyanfu on 2017/3/8.
 */

public class HttpsParser {
    private static ConcurrentMap<String, Integer> hostMap;
    private static final String FORCE = "force";
    private static final String HTTP = "http:";
    private static final String HTTPS = "https:";

    /**
     * 获取手Y中标准url的域名
     *
     * @param url
     * @return
     */
    public static String getHost(String url) {
        if (url == null || !url.startsWith("http")) {
            return null;
        }
        try {
            URI uri = new URI(url);
            return uri.getHost() == null ? url : uri.getHost();
        } catch (Throwable e) {
//            KLog.e("HttpsParser", "getHost error", e);
        }
        return url;
    }

    /**
     * 是否需要转为https
     *
     * @param host
     * @return
     */
    public static boolean needsConvert(String host) {
        if (hostMap == null || hostMap.size() <= 0) {
            return false;
        }
        if (hostMap.containsKey(host)) {
            return hostMap.get(host) == 1;
        }
        if (hostMap.containsKey(FORCE) && hostMap.get(FORCE) == 1) {
            return true;
        }
        return false;
    }

    /**
     * http强制替换为https
     *
     * @param url
     * @return
     */
    public static String convertToHttps(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTP)) {
            return url;
        }

        String host = getHost(url);
        //获取host失败
        if (host == null || host.isEmpty() || host.startsWith(HTTPS)) {
            return url;
        }
        if (needsConvert(host)) {
            return url.replaceFirst(HTTP, HTTPS);
        }
        return url;
    }

    /**
     * https强制替换为http
     *
     * @param url
     * @return
     */
    public static String convertToHttp(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTPS)) {
            return url;
        }

        String host = getHost(url);
        //获取host失败
        if (host == null || host.isEmpty() || host.startsWith(HTTP)) {
            return url;
        }
        if (needsConvert(host)) {
            return url.replaceFirst(HTTPS, HTTP);
        }
        return url;
    }

    public static Map<String, Integer> getHostMap() {
        if (hostMap == null) {
            hostMap = new ConcurrentHashMap<>();
        }
        return hostMap;
    }
}