/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.filetransfer.impl.util;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.filetransfer.impl.service.FileTransferProcess;
import tv.athena.filetransfer.impl.service.ForegroundAssistService;
import tv.athena.klog.api.KLog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fJ\u0006\u0010\u0011\u001a\u00020\rR\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper;", "", "targetService", "Landroid/app/Service;", "(Landroid/app/Service;)V", "mConnection", "Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper$AssistServiceConnection;", "mTargetService", "generateNotification", "Landroid/app/Notification;", "iconId", "", "startForeground", "", "assistServiceCls", "Ljava/lang/Class;", "Ltv/athena/filetransfer/impl/service/ForegroundAssistService;", "stopForeground", "AssistServiceConnection", "Companion", "filetransfer_release"})
public final class ServiceForegroundHelper {
    private Service mTargetService;
    private AssistServiceConnection mConnection;
    private static final String TAG = "ServiceForegroundHelper";
    private static final int PID;
    public static final Companion Companion;

    public final void startForeground(@Nullable Class<? extends ForegroundAssistService> assistServiceCls) {
        block1: {
            Notification notification = this.generateNotification(0);
            if (Build.VERSION.SDK_INT >= 18 || notification == null) break block1;
            Service service = this.mTargetService;
            if (service != null) {
                service.startForeground(PID, this.generateNotification(0));
            }
        }
    }

    public final void stopForeground() {
        block0: {
            Service service = this.mTargetService;
            if (service == null) break block0;
            service.stopForeground(true);
        }
    }

    private final Notification generateNotification(int iconId) {
        PendingIntent pendingIntent;
        try {
            Notification notification;
            Notification.Builder builder;
            PendingIntent $receiver = pendingIntent = PendingIntent.getActivity((Context)((Context)this.mTargetService), (int)0, (Intent)new Intent((Context)this.mTargetService, FileTransferProcess.class), (int)0x8000000);
            Notification.Builder it = builder = new Notification.Builder((Context)this.mTargetService);
            if (Build.VERSION.SDK_INT >= 16) {
                notification = it.setSmallIcon(iconId).setContentIntent($receiver).build();
            } else {
                Notification.Builder builder2 = it.setSmallIcon(iconId).setContentIntent($receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"it.setSmallIcon(iconId)\n\u2026  .setContentIntent(this)");
                notification = builder2.getNotification();
            }
            Notification notification2 = notification;
            pendingIntent = notification2;
        }
        catch (Exception e) {
            pendingIntent = null;
        }
        return pendingIntent;
    }

    public ServiceForegroundHelper(@NotNull Service targetService) {
        Intrinsics.checkParameterIsNotNull((Object)targetService, (String)"targetService");
        this.mTargetService = targetService;
    }

    static {
        Companion = new Companion(null);
        PID = Process.myPid();
    }

    public static final /* synthetic */ void access$setMTargetService$p(ServiceForegroundHelper $this, @Nullable Service service) {
        $this.mTargetService = service;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper$AssistServiceConnection;", "Landroid/content/ServiceConnection;", "(Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper;)V", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "binder", "Landroid/os/IBinder;", "onServiceDisconnected", "filetransfer_release"})
    private final class AssistServiceConnection
    implements ServiceConnection {
        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            KLog.d((String)ServiceForegroundHelper.TAG, (String)"onServiceDisconnected", (Object[])new Object[0]);
        }

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder binder) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)binder, (String)"binder");
            KLog.i((String)ServiceForegroundHelper.TAG, (String)"onServiceConnected", (Object[])new Object[0]);
            int iconId = 10211211;
            ForegroundAssistService assistService = ((ForegroundAssistService.LocalBinder)binder).getService();
            Notification notification = ServiceForegroundHelper.this.generateNotification(iconId);
            if (notification != null) {
                assistService.startForeground(PID, notification);
                Service service = ServiceForegroundHelper.this.mTargetService;
                if (service != null) {
                    service.startForeground(PID, notification);
                }
            }
            assistService.stopForeground(true);
            Service service = ServiceForegroundHelper.this.mTargetService;
            if (service != null) {
                service.unbindService((ServiceConnection)ServiceForegroundHelper.this.mConnection);
            }
            ServiceForegroundHelper.this.mConnection = null;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper$Companion;", "", "()V", "PID", "", "TAG", "", "filetransfer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

