/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.filetransfer.impl.service;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.core.axis.Axis;
import tv.athena.filetransfer.impl.iface.IFileTransferProcessCallback;
import tv.athena.filetransfer.impl.service.ForegroundAssistService;
import tv.athena.filetransfer.impl.util.ServiceForegroundHelper;
import tv.athena.filetransfer.impl.util.ServiceMessageManager;
import tv.athena.http.api.IHttpService;
import tv.athena.klog.api.KLog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltv/athena/filetransfer/impl/service/FileTransferProcess;", "Landroid/app/Service;", "Ltv/athena/filetransfer/impl/iface/IFileTransferProcessCallback;", "()V", "mCpuWakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "mForegroundHelper", "Ltv/athena/filetransfer/impl/util/ServiceForegroundHelper;", "mMessenger", "Landroid/os/Messenger;", "mNeedSetServiceForeground", "", "mWakeLockCount", "", "serviceMessageManager", "Ltv/athena/filetransfer/impl/util/ServiceMessageManager;", "acquireCpuWakeLock", "", "initManager", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "releaseCpuWakeLock", "setServiceForeground", "foreground", "Companion", "IncomingHandler", "filetransfer_release"})
public final class FileTransferProcess
extends Service
implements IFileTransferProcessCallback {
    private ServiceForegroundHelper mForegroundHelper;
    private boolean mNeedSetServiceForeground = true;
    private final Messenger mMessenger = new Messenger((Handler)new IncomingHandler());
    private ServiceMessageManager serviceMessageManager;
    private PowerManager.WakeLock mCpuWakeLock;
    private int mWakeLockCount;
    private static final String TAG = "FileTransmissionService";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        KLog.i((String)TAG, (String)("service bind:" + String.valueOf(intent)), (Object[])new Object[0]);
        IBinder iBinder = this.mMessenger.getBinder();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBinder, (String)"mMessenger.binder");
        return iBinder;
    }

    public void onCreate() {
        IHttpService iHttpService;
        KLog.i((String)TAG, (String)"FileTransmissionService onCreate", (Object[])new Object[0]);
        this.initManager();
        if (this.mNeedSetServiceForeground) {
            this.setServiceForeground(true);
            this.mNeedSetServiceForeground = false;
        }
        if ((iHttpService = (IHttpService)Axis.Companion.getService(IHttpService.class)) != null && (iHttpService = iHttpService.config()) != null) {
            iHttpService.apply();
        }
        this.stopForeground(true);
    }

    private final void initManager() {
        this.serviceMessageManager = new ServiceMessageManager(this);
        Object object = this.getSystemService("power");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.os.PowerManager");
        }
        this.mCpuWakeLock = ((PowerManager)object).newWakeLock(1, this.getClass().getCanonicalName());
    }

    private final void setServiceForeground(boolean foreground) {
        block2: {
            block1: {
                if (!foreground) break block1;
                if (this.mForegroundHelper == null) {
                    this.mForegroundHelper = new ServiceForegroundHelper(this);
                }
                ServiceForegroundHelper serviceForegroundHelper = this.mForegroundHelper;
                if (serviceForegroundHelper == null) break block2;
                serviceForegroundHelper.startForeground(ForegroundAssistService.class);
                break block2;
            }
            ServiceForegroundHelper serviceForegroundHelper = this.mForegroundHelper;
            if (serviceForegroundHelper == null) break block2;
            serviceForegroundHelper.stopForeground();
        }
    }

    @Override
    public void releaseCpuWakeLock() {
        int n = this.mWakeLockCount;
        this.mWakeLockCount = n + -1;
        try {
            if (this.mWakeLockCount == 0) {
                PowerManager.WakeLock wakeLock = this.mCpuWakeLock;
                if (wakeLock != null) {
                    wakeLock.release();
                }
                this.setServiceForeground(false);
            }
        }
        catch (Throwable e) {
            KLog.e$default((String)TAG, (String)("error ignore " + e.getMessage()), null, (Object[])new Object[0], (int)4, null);
        }
    }

    @Override
    public void acquireCpuWakeLock() {
        int n = this.mWakeLockCount;
        this.mWakeLockCount = n + 1;
        try {
            if (this.mWakeLockCount == 1) {
                PowerManager.WakeLock wakeLock = this.mCpuWakeLock;
                if (wakeLock != null) {
                    wakeLock.acquire(1800000L);
                }
                this.setServiceForeground(true);
            }
        }
        catch (Throwable e) {
            KLog.e$default((String)TAG, (String)("error ignore " + e.getMessage()), null, (Object[])new Object[0], (int)4, null);
        }
    }

    public static final /* synthetic */ void access$setServiceMessageManager$p(FileTransferProcess $this, @Nullable ServiceMessageManager serviceMessageManager) {
        $this.serviceMessageManager = serviceMessageManager;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ltv/athena/filetransfer/impl/service/FileTransferProcess$IncomingHandler;", "Landroid/os/Handler;", "(Ltv/athena/filetransfer/impl/service/FileTransferProcess;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "filetransfer_release"})
    @SuppressLint(value={"HandlerLeak"})
    private final class IncomingHandler
    extends Handler {
        public void handleMessage(@Nullable Message msg) {
            block0: {
                super.handleMessage(msg);
                KLog.i((String)FileTransferProcess.TAG, (String)"\u6536\u5230\u6587\u4ef6\u4f20\u8f93\u547d\u4ee4", (Object[])new Object[0]);
                ServiceMessageManager serviceMessageManager = FileTransferProcess.this.serviceMessageManager;
                if (serviceMessageManager == null) break block0;
                serviceMessageManager.handleMessage(msg);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltv/athena/filetransfer/impl/service/FileTransferProcess$Companion;", "", "()V", "TAG", "", "filetransfer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

