/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.filetransfer.impl.download;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.filetransfer.api.DownloadInfo;
import tv.athena.filetransfer.impl.download.DownloadRequestManager;
import tv.athena.filetransfer.impl.download.FileTransferCenter;
import tv.athena.filetransfer.impl.iface.IDownloadRequestCallback;
import tv.athena.filetransfer.impl.iface.IFileTransferCenter;
import tv.athena.filetransfer.impl.iface.IFileTransferProcessCallback;
import tv.athena.filetransfer.impl.iface.SendMessageClient;
import tv.athena.filetransfer.impl.model.FileTransferTask;
import tv.athena.filetransfer.impl.uplaod.UploadRequestManager;
import tv.athena.klog.api.KLog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000*\u0001\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ltv/athena/filetransfer/impl/download/FileTransferCenter;", "Ltv/athena/filetransfer/impl/iface/IFileTransferCenter;", "callBack", "Ltv/athena/filetransfer/impl/iface/IFileTransferProcessCallback;", "listener", "Ltv/athena/filetransfer/impl/iface/SendMessageClient;", "(Ltv/athena/filetransfer/impl/iface/IFileTransferProcessCallback;Ltv/athena/filetransfer/impl/iface/SendMessageClient;)V", "downloadRequestManager", "Ltv/athena/filetransfer/impl/download/DownloadRequestManager;", "iDownloadRequestCallback", "tv/athena/filetransfer/impl/download/FileTransferCenter$iDownloadRequestCallback$1", "Ltv/athena/filetransfer/impl/download/FileTransferCenter$iDownloadRequestCallback$1;", "getListener", "()Ltv/athena/filetransfer/impl/iface/SendMessageClient;", "setListener", "(Ltv/athena/filetransfer/impl/iface/SendMessageClient;)V", "tasks", "", "", "Ltv/athena/filetransfer/impl/model/FileTransferTask;", "uploadRequestManager", "Ltv/athena/filetransfer/impl/uplaod/UploadRequestManager;", "cancelTask", "", "url", "continuing", "createTask", "task", "deleteTask", "isDeleteFile", "", "pauseTask", "send", "status", "", "response", "", "filetransfer_release"})
public final class FileTransferCenter
implements IFileTransferCenter {
    private Map<String, FileTransferTask> tasks;
    private DownloadRequestManager downloadRequestManager;
    private UploadRequestManager uploadRequestManager;
    private iDownloadRequestCallback.1 iDownloadRequestCallback;
    private IFileTransferProcessCallback callBack;
    @NotNull
    private SendMessageClient listener;

    @Override
    public void createTask(@NotNull FileTransferTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        KLog.i((String)"FileTransferCenter", (String)"createTask ....", (Object[])new Object[0]);
        if (this.tasks.get(task.getUrl()) == null) {
            this.callBack.acquireCpuWakeLock();
            Map<String, FileTransferTask> map = this.tasks;
            String string = task.getUrl();
            FileTransferTask fileTransferTask = task;
            map.put(string, fileTransferTask);
        }
        boolean isSuccessful = false;
        if (task.getType() == 2001) {
            KLog.i((String)"FileTransferCenter", (String)"download  start ....", (Object[])new Object[0]);
            DownloadRequestManager downloadRequestManager = this.downloadRequestManager;
            isSuccessful = downloadRequestManager != null ? downloadRequestManager.startDownLoad(task) : false;
        } else if (task.getType() == 2002) {
            UploadRequestManager uploadRequestManager = this.uploadRequestManager;
            isSuccessful = uploadRequestManager != null ? uploadRequestManager.uploadStart(task) : false;
        }
        this.send(task.getUrl(), 1001, isSuccessful);
    }

    @Override
    public void deleteTask(@NotNull String url, boolean isDeleteFile) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (this.tasks.get(url) != null) {
            this.callBack.releaseCpuWakeLock();
            if (isDeleteFile) {
                DownloadRequestManager downloadRequestManager = this.downloadRequestManager;
                if (downloadRequestManager != null) {
                    FileTransferTask fileTransferTask;
                    FileTransferTask fileTransferTask2 = this.tasks.get(url);
                    downloadRequestManager.deleteTempFile(fileTransferTask2 != null && (fileTransferTask2 = fileTransferTask2.getDownloadInfo()) != null ? fileTransferTask2.getFilePath() : null, (fileTransferTask = this.tasks.get(url)) != null && (fileTransferTask = fileTransferTask.getDownloadInfo()) != null ? fileTransferTask.getFileName() : null);
                }
            }
            this.tasks.remove(url);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void cancelTask(@NotNull String url) {
        FileTransferTask task;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        boolean isSuccessful = false;
        FileTransferTask fileTransferTask = task = this.tasks.get(url);
        if (fileTransferTask != null && fileTransferTask.getType() == 2001) {
            DownloadRequestManager downloadRequestManager = this.downloadRequestManager;
            isSuccessful = downloadRequestManager != null ? downloadRequestManager.cancelTask(task) : false;
            this.deleteTask(task.getUrl(), true);
        } else {
            FileTransferTask fileTransferTask2 = task;
            if (fileTransferTask2 != null && fileTransferTask2.getType() == 2002) {
                UploadRequestManager uploadRequestManager = this.uploadRequestManager;
                if (uploadRequestManager != null) {
                    uploadRequestManager.uploadCancel(url);
                }
            }
        }
        this.send(url, 1004, isSuccessful);
    }

    @Override
    public void pauseTask(@NotNull String url) {
        FileTransferTask task;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        FileTransferTask fileTransferTask = task = this.tasks.get(url);
        if (fileTransferTask != null) {
            if (fileTransferTask.getType() == 2001) {
                DownloadInfo downloadInfo = task.getDownloadInfo();
                if (Intrinsics.areEqual((Object)(downloadInfo != null ? downloadInfo.isContinuing() : null), (Object)true)) {
                    DownloadRequestManager downloadRequestManager = this.downloadRequestManager;
                    boolean isSuccessful = downloadRequestManager != null ? downloadRequestManager.cancelTask(task) : false;
                    task.setStatus(1003);
                    this.send(url, 1003, isSuccessful);
                }
            }
        }
        this.cancelTask(url);
    }

    @Override
    public void continuing(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        FileTransferTask task = this.tasks.get(url);
        if (task == null) {
            this.send(url, 1007, "\u4efb\u52a1\u4e0d\u5b58\u5728,\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u4efb\u52a1\uff0c\u8bf7\u5c1d\u8bd5\u5f00\u59cb\u4efb\u52a1\u3002");
        } else {
            this.createTask(task);
        }
    }

    private final void send(String url, int status, Object response) {
        this.listener.sendMessage(url, status, response);
    }

    @NotNull
    public final SendMessageClient getListener() {
        return this.listener;
    }

    public final void setListener(@NotNull SendMessageClient sendMessageClient) {
        Intrinsics.checkParameterIsNotNull((Object)sendMessageClient, (String)"<set-?>");
        this.listener = sendMessageClient;
    }

    public FileTransferCenter(@NotNull IFileTransferProcessCallback callBack, @NotNull SendMessageClient listener) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.callBack = callBack;
        this.listener = listener;
        FileTransferCenter fileTransferCenter = this;
        fileTransferCenter.tasks = map = (Map)new LinkedHashMap();
        this.iDownloadRequestCallback = new IDownloadRequestCallback(this){
            final /* synthetic */ FileTransferCenter this$0;

            public void onProgress(@NotNull String url, int progress) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                FileTransferCenter.access$send(this.this$0, url, 1005, progress);
            }

            public void onError(@NotNull String url, @NotNull String error) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                FileTransferCenter.access$send(this.this$0, url, 1007, error);
            }

            public void onSuccess(@NotNull String url, @NotNull String response) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                FileTransferCenter.access$send(this.this$0, url, 1006, response);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.downloadRequestManager = new DownloadRequestManager(this.iDownloadRequestCallback);
        this.uploadRequestManager = new UploadRequestManager(this.iDownloadRequestCallback);
    }

    public static final /* synthetic */ void access$send(FileTransferCenter $this, @NotNull String url, int status, @NotNull Object response) {
        $this.send(url, status, response);
    }
}

