/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.filetransfer.impl.download;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.core.axis.Axis;
import tv.athena.filetransfer.api.DownloadInfo;
import tv.athena.filetransfer.impl.iface.FileTransferApi;
import tv.athena.filetransfer.impl.iface.IDownloadRequestCallback;
import tv.athena.filetransfer.impl.model.FileTransferTask;
import tv.athena.filetransfer.impl.util.HttpUtil;
import tv.athena.http.api.IHttpService;
import tv.athena.http.api.IRequest;
import tv.athena.http.api.IResponse;
import tv.athena.http.api.callback.ICallback;
import tv.athena.klog.api.KLog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltv/athena/filetransfer/impl/download/DownloadRequestManager;", "", "callback", "Ltv/athena/filetransfer/impl/iface/IDownloadRequestCallback;", "(Ltv/athena/filetransfer/impl/iface/IDownloadRequestCallback;)V", "getCallback", "()Ltv/athena/filetransfer/impl/iface/IDownloadRequestCallback;", "setCallback", "requestQueue", "", "", "Ltv/athena/http/api/IRequest;", "Ljava/io/InputStream;", "waitingQueue", "", "Ltv/athena/filetransfer/impl/model/FileTransferTask;", "cancelTask", "", "task", "deleteTempFile", "", "filePath", "filename", "downloadContinueRequest", "Ltv/athena/filetransfer/api/DownloadInfo;", "downloadRequest", "startDownLoad", "startNextTask", "url", "Companion", "filetransfer_release"})
public final class DownloadRequestManager {
    private List<FileTransferTask> waitingQueue;
    private Map<String, IRequest<InputStream>> requestQueue;
    @NotNull
    private IDownloadRequestCallback callback;
    private static String TAG;
    private static final int BUFFER = 2048;
    private static final String TMP = ".tmp";
    private static final int SAME_TIME_LOAD = 3;
    public static final Companion Companion;

    public final boolean startDownLoad(@NotNull FileTransferTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DownloadInfo downloadInfo = task.getDownloadInfo();
        if (downloadInfo == null) {
            return false;
        }
        DownloadInfo downloadInfo2 = downloadInfo;
        if (this.requestQueue.size() >= 3) {
            this.waitingQueue.add(task);
            return false;
        }
        KLog.d((String)TAG, (String)"start task ====== ", (Object[])new Object[0]);
        DownloadInfo downloadInfo3 = downloadInfo2;
        Boolean bl = downloadInfo3 != null ? downloadInfo3.isContinuing() : null;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        if (!bl.booleanValue()) {
            DownloadInfo downloadInfo4 = task.getDownloadInfo();
            KLog.d((String)TAG, (String)("start download--------" + (downloadInfo4 != null ? downloadInfo4.isContinuing() : null)), (Object[])new Object[0]);
            this.downloadRequest(downloadInfo2);
        } else {
            this.downloadContinueRequest(downloadInfo2);
        }
        return true;
    }

    private final void startNextTask(String url) {
        this.requestQueue.remove(url);
        if (this.waitingQueue.size() > 0) {
            this.startDownLoad(this.waitingQueue.remove(0));
        }
    }

    public final boolean cancelTask(@Nullable FileTransferTask task) {
        FileTransferTask fileTransferTask = task;
        if (fileTransferTask != null) {
            FileTransferTask fileTransferTask2;
            FileTransferTask $receiver = fileTransferTask2 = fileTransferTask;
            IRequest<InputStream> iRequest = this.requestQueue.get($receiver.getUrl());
            if (iRequest != null) {
                iRequest.cancel();
            }
            this.requestQueue.remove($receiver.getUrl());
            return true;
        }
        return false;
    }

    public final void deleteTempFile(@Nullable String filePath, @Nullable String filename) {
        String file = filePath + File.separator + filename;
        File file2 = new File(file + TMP);
        File $receiver = file2;
        if ($receiver.exists() && $receiver.isFile()) {
            $receiver.delete();
        }
    }

    private final void downloadRequest(DownloadInfo task) {
        block1: {
            Object object;
            File file;
            KLog.i((String)TAG, (String)"start download", (Object[])new Object[0]);
            String url = task.getUrl();
            String dir = task.getFilePath();
            File $receiver = file = new File(dir);
            if (!$receiver.exists()) {
                $receiver.mkdirs();
            }
            String filePath = dir + File.separator + task.getFileName();
            File tmpFile = new File(filePath + TMP);
            Object object2 = (IHttpService)Axis.Companion.getService(IHttpService.class);
            if (object2 == null || (object2 = (FileTransferApi)object2.create(FileTransferApi.class)) == null || (object2 = object2.downloadFile(url)) == null) break block1;
            Object $receiver2 = object = object2;
            KLog.d((String)TAG, (String)("-------> HeaderUrl:" + $receiver2.getUrl()), (Object[])new Object[0]);
            $receiver2.enqueue((ICallback)new ICallback<InputStream>((IRequest)$receiver2, this, url, tmpFile, filePath){
                final /* synthetic */ IRequest receiver$0;
                final /* synthetic */ DownloadRequestManager this$0;
                final /* synthetic */ String $url$inlined;
                final /* synthetic */ File $tmpFile$inlined;
                final /* synthetic */ String $filePath$inlined;
                {
                    this.receiver$0 = $receiver;
                    this.this$0 = downloadRequestManager;
                    this.$url$inlined = string;
                    this.$tmpFile$inlined = file;
                    this.$filePath$inlined = string2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onResponse(@NotNull IResponse<? extends InputStream> response) {
                    InputStream inputStream;
                    BufferedOutputStream outputStream;
                    block17: {
                        Long totalSize;
                        Long l;
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        KLog.e$default((String)"Download:", (String)("code:" + response.getStatusCode()), null, (Object[])new Object[0], (int)4, null);
                        if (!HttpUtil.INSTANCE.checkStatusCode(response.getStatusCode())) {
                            this.this$0.getCallback().onError(this.$url$inlined, "\u7f51\u7edc\u60c5\u51b5\u5f02\u5e38\uff0chttp Status Code:" + response.getStatusCode());
                            return;
                        }
                        byte[] buffer = new byte[2048];
                        String string = response.getHeader("content-length");
                        if (string != null) {
                            String string2 = string;
                            l = Long.parseLong(string2);
                        } else {
                            l = null;
                        }
                        Long l2 = totalSize = l;
                        if (l2 != null && l2 == 0L) {
                            this.this$0.getCallback().onError(this.$url$inlined, "\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38");
                            DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                            return;
                        }
                        InputStream inputStream2 = (InputStream)response.getResult();
                        outputStream = new BufferedOutputStream(new FileOutputStream(this.$tmpFile$inlined));
                        long progress = 0L;
                        try {
                            int count = 0;
                            while (true) {
                                InputStream inputStream3 = inputStream2;
                                if (inputStream3 != null) {
                                    int n;
                                    int $receiver;
                                    count = $receiver = (n = inputStream3.read(buffer, 0, 2048));
                                    if (n == -1) break;
                                }
                                if (this.receiver$0.isCanceled()) {
                                    DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                                    inputStream = inputStream2;
                                    break block17;
                                }
                                outputStream.write(buffer, 0, count);
                                IDownloadRequestCallback iDownloadRequestCallback2 = this.this$0.getCallback();
                                long l3 = (progress += (long)count) * (long)100;
                                Long l4 = totalSize;
                                if (l4 == null) {
                                    Intrinsics.throwNpe();
                                }
                                iDownloadRequestCallback2.onProgress(this.$url$inlined, (int)(l3 / l4));
                                if (progress != totalSize) continue;
                                this.$tmpFile$inlined.renameTo(new File(this.$filePath$inlined));
                                this.this$0.getCallback().onSuccess(this.$url$inlined, this.$filePath$inlined);
                                DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                            }
                        }
                        catch (Throwable e) {
                            try {
                                IDownloadRequestCallback iDownloadRequestCallback3 = this.this$0.getCallback();
                                String string3 = e.getMessage();
                                if (string3 == null) {
                                    string3 = "";
                                }
                                iDownloadRequestCallback3.onError(this.$url$inlined, string3);
                                DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                InputStream inputStream4 = inputStream2;
                                if (inputStream4 != null) {
                                    inputStream4.close();
                                }
                                outputStream.close();
                            }
                        }
                        inputStream2.close();
                        outputStream.close();
                        DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                        return;
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    outputStream.close();
                }

                public void onFailure(@NotNull IRequest<InputStream> request, @Nullable Throwable t) {
                    Intrinsics.checkParameterIsNotNull(request, (String)"request");
                    IDownloadRequestCallback iDownloadRequestCallback2 = this.this$0.getCallback();
                    Object object = t;
                    if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                        object = "\u7f51\u7edc\u8054\u63a5\u5931\u8d25\uff01";
                    }
                    iDownloadRequestCallback2.onError(this.$url$inlined, (String)object);
                    DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                }
            });
            Map<String, IRequest<InputStream>> map = this.requestQueue;
            String string = url;
            Object object3 = $receiver2;
            map.put(string, (IRequest<InputStream>)object3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadContinueRequest(DownloadInfo task) {
        block2: {
            void rad;
            Object object;
            void downloadLength;
            void tmpFile;
            File file;
            KLog.i((String)TAG, (String)"start continue  download", (Object[])new Object[0]);
            String url = task.getUrl();
            String dir = task.getFilePath();
            File $receiver = file = new File(dir);
            if (!$receiver.exists()) {
                $receiver.mkdirs();
            }
            file = new Ref.LongRef();
            ((Ref.LongRef)file).element = 0L;
            String filePath = dir + File.separator + task.getFileName();
            Ref.ObjectRef $i$a$1$apply = new Ref.ObjectRef();
            $i$a$1$apply.element = new File(filePath + TMP);
            if (((File)tmpFile.element).exists()) {
                downloadLength.element = ((File)tmpFile.element).length();
                KLog.i((String)TAG, (String)("downloadLength:" + downloadLength.element), (Object[])new Object[0]);
            }
            KLog.d((String)TAG, (String)("downlaod:" + url), (Object[])new Object[0]);
            Object object2 = (IHttpService)Axis.Companion.getService(IHttpService.class);
            if (object2 == null || (object2 = (FileTransferApi)object2.create(FileTransferApi.class)) == null || (object2 = object2.downloadContinueFile(url, "bytes=" + downloadLength.element + '-')) == null) break block2;
            Object $receiver2 = object = object2;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            $receiver2.enqueue((ICallback)new ICallback<InputStream>((IRequest)$receiver2, (Ref.ObjectRef)rad, this, url, (Ref.LongRef)downloadLength, (Ref.ObjectRef)tmpFile, filePath){
                final /* synthetic */ IRequest receiver$0;
                final /* synthetic */ Ref.ObjectRef $rad;
                final /* synthetic */ DownloadRequestManager this$0;
                final /* synthetic */ String $url$inlined;
                final /* synthetic */ Ref.LongRef $downloadLength$inlined;
                final /* synthetic */ Ref.ObjectRef $tmpFile$inlined;
                final /* synthetic */ String $filePath$inlined;
                {
                    this.receiver$0 = $receiver;
                    this.$rad = $captured_local_variable$2;
                    this.this$0 = downloadRequestManager;
                    this.$url$inlined = string;
                    this.$downloadLength$inlined = longRef;
                    this.$tmpFile$inlined = objectRef;
                    this.$filePath$inlined = string2;
                }

                public void onFailure(@NotNull IRequest<InputStream> request, @Nullable Throwable t) {
                    Intrinsics.checkParameterIsNotNull(request, (String)"request");
                    IDownloadRequestCallback iDownloadRequestCallback2 = this.this$0.getCallback();
                    Object object = t;
                    if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                        object = "\u7f51\u7edc\u94fe\u63a5\u5931\u8d25\uff01";
                    }
                    iDownloadRequestCallback2.onError(this.$url$inlined, (String)object);
                    DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onResponse(@NotNull IResponse<? extends InputStream> response) {
                    InputStream inputStream;
                    block23: {
                        long l;
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        KLog.i((String)DownloadRequestManager.access$getTAG$cp(), (String)("\u7f51\u7edc\u60c5\u51b5\u5f02\u5e38\uff0chttp Status Code:" + response.getStatusCode()), (Object[])new Object[0]);
                        if (!HttpUtil.INSTANCE.checkStatusCode(response.getStatusCode())) {
                            this.this$0.getCallback().onError(this.$url$inlined, "\u7f51\u7edc\u60c5\u51b5\u5f02\u5e38\uff0chttp Status Code:" + response.getStatusCode());
                            return;
                        }
                        String string = response.getHeader("content-length");
                        if (string != null) {
                            String string2 = string;
                            l = Long.parseLong(string2);
                        } else {
                            l = 0L;
                        }
                        long totalSize = l;
                        KLog.i((String)DownloadRequestManager.access$getTAG$cp(), (String)("totalSize:" + (totalSize += this.$downloadLength$inlined.element)), (Object[])new Object[0]);
                        if (totalSize == 0L) {
                            this.this$0.getCallback().onError(this.$url$inlined, "\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38");
                            DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                            return;
                        }
                        if (totalSize == this.$downloadLength$inlined.element) {
                            ((File)this.$tmpFile$inlined.element).renameTo(new File(this.$filePath$inlined));
                            this.this$0.getCallback().onSuccess(this.$url$inlined, this.$filePath$inlined);
                            DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                            return;
                        }
                        if (totalSize < this.$downloadLength$inlined.element) {
                            ((File)this.$tmpFile$inlined.element).delete();
                            this.$tmpFile$inlined.element = new File(this.$filePath$inlined + ".tmp");
                        } else {
                            this.$rad.element = new RandomAccessFile((File)this.$tmpFile$inlined.element, "rwd");
                            RandomAccessFile randomAccessFile = (RandomAccessFile)this.$rad.element;
                            if (randomAccessFile != null) {
                                randomAccessFile.seek(this.$downloadLength$inlined.element);
                            }
                        }
                        InputStream inputStream2 = (InputStream)response.getResult();
                        long progress = 0L;
                        byte[] buffer = new byte[2048];
                        progress += this.$downloadLength$inlined.element;
                        try {
                            int count = 0;
                            while (true) {
                                InputStream inputStream3 = inputStream2;
                                if (inputStream3 != null) {
                                    int n;
                                    int $receiver;
                                    count = $receiver = (n = inputStream3.read(buffer, 0, 2048));
                                    if (n == -1) break;
                                }
                                if (this.receiver$0.isCanceled()) {
                                    DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                                    inputStream = inputStream2;
                                    break block23;
                                }
                                RandomAccessFile randomAccessFile = (RandomAccessFile)this.$rad.element;
                                if (randomAccessFile != null) {
                                    randomAccessFile.write(buffer, 0, count);
                                }
                                KLog.i((String)DownloadRequestManager.access$getTAG$cp(), (String)("progress:" + (progress += (long)count) + "   totalSize:" + totalSize), (Object[])new Object[0]);
                                this.this$0.getCallback().onProgress(this.$url$inlined, (int)(progress * (long)100 / totalSize));
                                if (progress != totalSize) continue;
                                ((File)this.$tmpFile$inlined.element).renameTo(new File(this.$filePath$inlined));
                                this.this$0.getCallback().onSuccess(this.$url$inlined, this.$filePath$inlined);
                            }
                        }
                        catch (Throwable t) {
                            try {
                                IDownloadRequestCallback iDownloadRequestCallback2 = this.this$0.getCallback();
                                String string3 = t.getMessage();
                                if (string3 == null) {
                                    string3 = "\u6587\u4ef6\u8bfb\u5199\u6d41\u5f02\u5e38\uff01";
                                }
                                iDownloadRequestCallback2.onError(this.$url$inlined, string3);
                                KLog.e$default((String)DownloadRequestManager.access$getTAG$cp(), (Function0)((Function0)new Function0<Throwable>(t){
                                    final /* synthetic */ Throwable $t;
                                    {
                                        this.$t = throwable;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Throwable invoke() {
                                        return this.$t;
                                    }
                                }), null, (int)4, null);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                InputStream inputStream4 = inputStream2;
                                if (inputStream4 != null) {
                                    inputStream4.close();
                                }
                                RandomAccessFile randomAccessFile = (RandomAccessFile)this.$rad.element;
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                            }
                        }
                        inputStream2.close();
                        RandomAccessFile randomAccessFile = (RandomAccessFile)this.$rad.element;
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        DownloadRequestManager.access$startNextTask(this.this$0, this.$url$inlined);
                        return;
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    RandomAccessFile randomAccessFile = (RandomAccessFile)this.$rad.element;
                    if (randomAccessFile == null) return;
                    randomAccessFile.close();
                }
            });
            Map<String, IRequest<InputStream>> map = this.requestQueue;
            String string = url;
            Object object3 = $receiver2;
            map.put(string, (IRequest<InputStream>)object3);
        }
    }

    @NotNull
    public final IDownloadRequestCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@NotNull IDownloadRequestCallback iDownloadRequestCallback2) {
        Intrinsics.checkParameterIsNotNull((Object)iDownloadRequestCallback2, (String)"<set-?>");
        this.callback = iDownloadRequestCallback2;
    }

    public DownloadRequestManager(@NotNull IDownloadRequestCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callback = callback;
        DownloadRequestManager downloadRequestManager = this;
        Object object = new ArrayList();
        downloadRequestManager.waitingQueue = object;
        downloadRequestManager = this;
        downloadRequestManager.requestQueue = object = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        TAG = "DownloadRequestManager";
    }

    public static final /* synthetic */ void access$startNextTask(DownloadRequestManager $this, @NotNull String url) {
        $this.startNextTask(url);
    }

    @NotNull
    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ void access$setTAG$cp(@NotNull String string) {
        TAG = string;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltv/athena/filetransfer/impl/download/DownloadRequestManager$Companion;", "", "()V", "BUFFER", "", "SAME_TIME_LOAD", "TAG", "", "TMP", "filetransfer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

