/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.filetransfer.impl;

import android.os.Bundle;
import android.os.Parcelable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.ServiceRegister;
import tv.athena.core.axis.AxisLifecycle;
import tv.athena.filetransfer.api.DownloadInfo;
import tv.athena.filetransfer.api.IFileTransferCallback;
import tv.athena.filetransfer.api.IFileTransferService;
import tv.athena.filetransfer.api.UploadInfo;
import tv.athena.filetransfer.impl.util.ClientMessageManager;
import tv.athena.klog.api.KLog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0015"}, d2={"Ltv/athena/filetransfer/impl/FileTransferService;", "Ltv/athena/filetransfer/api/IFileTransferService;", "Ltv/athena/core/axis/AxisLifecycle;", "()V", "cancel", "", "url", "", "continuing", "callback", "Ltv/athena/filetransfer/api/IFileTransferCallback;", "downloadFile", "downloadInfo", "Ltv/athena/filetransfer/api/DownloadInfo;", "init", "pause", "unInit", "uploadFile", "uploadInfo", "Ltv/athena/filetransfer/api/UploadInfo;", "Companion", "filetransfer_release"})
@ServiceRegister(serviceInterface=IFileTransferService.class)
public final class FileTransferService
implements IFileTransferService,
AxisLifecycle {
    private static final String TAG = "DownloadService";
    public static final Companion Companion = new Companion(null);

    public void init() {
        KLog.i((String)TAG, (String)"--------------------FileTransferService init --------------", (Object[])new Object[0]);
        ClientMessageManager.INSTANCE.bindService();
    }

    public void unInit() {
        ClientMessageManager.INSTANCE.unbindService();
    }

    public void continuing(@NotNull String url, @Nullable IFileTransferCallback callback) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (callback != null) {
            ClientMessageManager.INSTANCE.addContinueCallback(url, callback);
        }
        Bundle $receiver = bundle = new Bundle();
        $receiver.putInt("status", 1008);
        $receiver.putString("url", url);
        ClientMessageManager.INSTANCE.sendMessageToService($receiver, 1008);
    }

    public void cancel(@NotNull String url) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Bundle $receiver = bundle = new Bundle();
        $receiver.putInt("status", 1004);
        $receiver.putString("url", url);
        ClientMessageManager.INSTANCE.sendMessageToService($receiver, 1004);
    }

    public void pause(@NotNull String url) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Bundle $receiver = bundle = new Bundle();
        $receiver.putInt("status", 1003);
        $receiver.putString("url", url);
        ClientMessageManager.INSTANCE.sendMessageToService($receiver, 1003);
    }

    public void downloadFile(@NotNull DownloadInfo downloadInfo, @NotNull IFileTransferCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (ClientMessageManager.INSTANCE.addIFileTransferCallback(downloadInfo.getUrl(), callback)) {
            Bundle bundle;
            Bundle $receiver = bundle = new Bundle();
            $receiver.putParcelable("download_info", (Parcelable)downloadInfo);
            ClientMessageManager.INSTANCE.sendMessageToService($receiver, 2001);
        } else {
            KLog.e$default((String)TAG, (String)"\u4efb\u52a1\u4ee5\u5b58\u5728\u961f\u5217\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", null, (Object[])new Object[0], (int)4, null);
        }
    }

    public void uploadFile(@NotNull UploadInfo uploadInfo, @NotNull IFileTransferCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)uploadInfo, (String)"uploadInfo");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        KLog.d((String)TAG, (String)"\u63a5\u6536\u4e0a\u4f20\u4efb\u52a1", (Object[])new Object[0]);
        if (ClientMessageManager.INSTANCE.addIFileTransferCallback(uploadInfo.getUrl(), callback)) {
            Bundle bundle;
            Bundle $receiver = bundle = new Bundle();
            $receiver.putParcelable("upload_info", (Parcelable)uploadInfo);
            ClientMessageManager.INSTANCE.sendMessageToService($receiver, 2002);
        } else {
            KLog.e$default((String)TAG, (String)"\u4efb\u52a1\u4ee5\u5b58\u5728\u961f\u5217\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", null, (Object[])new Object[0], (int)4, null);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltv/athena/filetransfer/impl/FileTransferService$Companion;", "", "()V", "TAG", "", "filetransfer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

