package tv.athena.platform.components;

import android.content.Intent;
import android.os.Bundle;

import android.support.v4.app.FragmentActivity;
import tv.athena.core.interceptor.ActivityResultCallback;
import tv.athena.core.interceptor.ActivityResultInterceptor;
import tv.athena.core.sly.Sly;

/**
 * An Activity that can Interceptor onActivityResult
 *
 * @author liangyong1
 */

public abstract class AeFragmentActivity extends FragmentActivity {

    private ActivityResultInterceptor mActivityResultInterceptor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivityResultInterceptor = ActivityResultInterceptor.Factory.create();
        Sly.Companion.subscribe(this);
    }

    /**
     * 注册onActivityResult的拦截器，当回调onActivityResult的时候会根据requestCode，分发到对应的ActivityResultCallback
     * @param callback 处理请求requestCode的回调
     */
    public void registerActivityResultInterceptor(ActivityResultCallback callback) {
        mActivityResultInterceptor.registerActivityResultInterceptor(callback);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (mActivityResultInterceptor.onActivityResult(requestCode, resultCode, data)) {
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mActivityResultInterceptor.onDestroy();
        Sly.Companion.unSubscribe(this);
    }
}
