package tv.athena.http.api

import java.lang.reflect.Type

/**
 *  请求转换器  如：把Call 转换为Rxjava 的Observable进行请求
 * Created by MoHuaQing on 2018/5/16.
 */
interface RequestAdapter<R , out T> {
    /**
     * 直正数据的类型 如Call<T> 中的 T
     * 这个 T 会作为Converter.Factory.responseBodyConverter 的第一个参数
     */
    fun responseType(): Type

    /**
     * 请求转换  如：把Call 转换为Rxjava 的Observable进行请求
     */
    fun adapt(request: IRequest<R>): T

    /**
     * 提供CallAdapter的工厂类
     */
    abstract class Factory {
        /**
         * 在这个方法中判断是否是我们支持的类型，returnType 即Call<Requestbody>和`Observable<Requestbody>`
         * RxJavaCallAdapterFactory 就是判断returnType是不是Observable<?> 类型
         */
        abstract operator fun get(returnType: Type, annotations: Array<Annotation>,
                                  httpService: IHttpService): RequestAdapter<*, *>?

    }
}