package tv.athena.http.api

import tv.athena.http.api.callback.ICallback


/**
 * http request接口
 * Created by MoHuaQing on 2018/5/16.
 */
interface IRequest<T> {
    /**
     * 同步执行
     */
    fun execute(): IResponse<T>?

    /**
     * 异步执行
     */
    fun enqueue(callback: ICallback<T>)

    /**
     * 取消当前请求
     */
    fun cancel(): Boolean

    /**
     * 是否被取消
     */
    fun isCanceled(): Boolean
    /**
     * 获取请求 url
     */
    fun getUrl(): String?

    /**
     * 设置请求 url
     */
    fun setUrl(url: String): IRequest<T>

    /**
     * 获取请求方法
     */
    fun getMethod(): String


    /**
     * 设置请求方法
     */
    fun setMethod(method: String): IRequest<T>

    /**
     * 获取请求头
     */
    fun getHeaders(): Map<String, String>?

    /**
     * 添加多个请求头
     */
    fun addHeaders(headers: Map<String, String>?): IRequest<T>

    /**
     * 获取 key=name 的请求头
     */
    fun getHeader(name: String): String?

    /**
     * 添加请求头
     */
    fun addHeader(name: String, value: String?): IRequest<T>

    /**
     * 获取请求参数
     */
    fun getHttpParams(): Map<String, String>?


    /**
     * 添加多个请求参数
     */
    fun addHttpParams(params: Map<String, String>?): IRequest<T>

    /**
     * 获取 key=name 请求参数
     */
    fun getHttpParam(name: String): String?

    /**
     * 添加请求参数
     */
    fun addHttpParam(name: String, value: String?): IRequest<T>


}