package tv.athena.http.api


/**
 * Network服务，提供初始化网络库功能,
 * Created by MoHuaQing on 2018/5/16.
 */
interface IHttpService {

    /**
     *    IHttpService networkService = Axis.getService(IHttpService::class.java)
     *              .config()
     *              .setConnectTimeout(1000*10)
     *              .useCache(true)
     *              .apply()
     *  通过Build构建，INetworkService不提供构造方法
     */
    fun config(): IHttpConfig

    /**
     *  网络请求构建入口  eg：
     *
     * interface TextLogin {
     * @Get("Login")
     * fun login():IRequest<TextLogin>
     *     }
     *
     *     networkService
     *              .create(TextLogin::class.java)
     *              .login()
     *              .enqueue(object : ICallBack{})
     */
    fun <T> create(service: Class<T>): T

    interface IHttpConfig {
        /**
         * 构建
         */
        fun apply(): IHttpService

        /**
         * 添加request拦截器
         */
        fun addRequestInterceptor(vararg requestInterceptor: IRequestInterceptor): IHttpConfig

        /**
         * 添加response拦截器
         */
        fun addResponseInterceptor(vararg interceptor: IResponseInterceptor): IHttpConfig

        /**
         * 添加request转换器
         */
        fun addRequestAdapterFactory(requestAdapterFactory: RequestAdapter.Factory): IHttpConfig

        /**
         * 连接超时时间,单位：秒
         */
        fun setConnectTimeout(connTimeOut: Long): IHttpConfig

        /**
         * 设置dns解析
         */
        fun dns(dns: IDns): IHttpConfig

        /**
         * http https转换，默认不转换
         */
        fun convertToHttps(convertToHttps: Boolean): IHttpConfig

        /**
         * 设置是否使用缓存 ps:只缓存Get请求
         * 默认不缓存
         */
        fun useCache(useCache: Boolean): IHttpConfig

        /**
         * 设置是否log日志是否开启 TAG = "HttpLog"
         * 默认不开启
         */
        fun useLog(useLog: Boolean): IHttpConfig

        /**
         * 设置缓存的有效期，和useCache配合使用 单位：秒
         * 有效期 ： currentTime - ResponseTime < maxAge() ? readCache : newRequest
         */
        fun setCacheMaxAge(maxAge: Long): IHttpConfig

        /**
         * 设置请求失败后，重试次数，
         * 默认不重试
         */
        fun setCurrentRetryCount(retryCount: Int): IHttpConfig

        fun putBaseUrlMapping(key: String, url: String): IHttpConfig

        /**
         * 添加Matrix ReturnCode上报
         * @param sCode Int
         * @return IHttpConfig
         */
        fun reportMatrixReturnCode(sCode: Int): IHttpConfig
    }
}