/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.AccountCurrencyInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.AccountPeriodInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.UserProps;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ToInfoResponse
implements IBaseJsonResponse {
    private String seq;
    private long uid;
    private int result;
    private String message;
    private long minAmountLimit;
    private List<AccountCurrencyInfo> accountList;
    private List<UserProps> userPropsList;
    private List<AccountPeriodInfo> accountPeriodList;

    public ToInfoResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            this.seq = response.optString("seq", "");
            this.uid = response.optLong("uid", 0L);
            this.result = response.optInt("result", 0);
            this.message = response.optString("message", "");
            this.minAmountLimit = response.optLong("minAmountLimit", 0L);
            this.accountList = new ArrayList<AccountCurrencyInfo>();
            JSONArray accountArray = response.optJSONArray("accountList");
            if (accountArray != null && accountArray.length() > 0) {
                for (int i = 0; i < accountArray.length(); ++i) {
                    JSONObject accountItem = accountArray.optJSONObject(i);
                    if (accountItem == null) continue;
                    AccountCurrencyInfo currencyInfo = new AccountCurrencyInfo();
                    currencyInfo.currencyType = accountItem.optInt("currencyType", 0);
                    currencyInfo.amount = accountItem.optLong("amount", 0L);
                    currencyInfo.freezed = accountItem.optLong("freezed", 0L);
                    currencyInfo.accountFrozen = accountItem.optInt("accountFrozen", 0);
                    currencyInfo.expireAmount = accountItem.optInt("expireAmount", 0);
                    currencyInfo.expireDate = accountItem.optString("expireDate", "");
                    this.accountList.add(currencyInfo);
                }
            }
            this.userPropsList = new ArrayList<UserProps>();
            JSONArray userPropsArray = response.optJSONArray("userPropsList");
            if (userPropsArray != null && userPropsArray.length() > 0) {
                for (int i = 0; i < userPropsArray.length(); ++i) {
                    JSONObject userPropsObj = userPropsArray.optJSONObject(i);
                    if (userPropsObj == null) continue;
                    UserProps userProps = new UserProps();
                    userProps.appId = userPropsObj.optInt("appId", 0);
                    ArrayList<UserProps.PropsItem> propsItemList = new ArrayList<UserProps.PropsItem>();
                    JSONArray propsItemArray = userPropsObj.optJSONArray("userPropsList");
                    if (propsItemArray != null && propsItemArray.length() > 0) {
                        for (int j = 0; j < propsItemArray.length(); ++j) {
                            JSONObject propsItemObj = propsItemArray.optJSONObject(j);
                            if (propsItemObj == null) continue;
                            UserProps.PropsItem propsItem = new UserProps.PropsItem();
                            propsItem.propsId = propsItemObj.optInt("propsId", 0);
                            propsItem.count = propsItemObj.optInt("count", 0);
                            propsItem.expireCount = propsItemObj.optInt("expireCount", 0);
                            propsItem.expireDate = propsItemObj.optString("expireDate");
                            propsItemList.add(propsItem);
                        }
                    }
                    userProps.propsItemList = propsItemList;
                    this.userPropsList.add(userProps);
                }
            }
            this.accountPeriodList = new ArrayList<AccountPeriodInfo>();
            JSONArray accountPeriodArray = response.optJSONArray("accountPeriodList");
            if (accountPeriodArray != null && accountPeriodArray.length() > 0) {
                for (int i = 0; i < accountPeriodArray.length(); ++i) {
                    JSONObject json = accountPeriodArray.optJSONObject(i);
                    if (json == null) continue;
                    int currencyType = json.optInt("currencyType", 0);
                    int amount = json.optInt("amount", 0);
                    long startTime = json.optLong("startTime", 0L);
                    long endTime = json.optLong("endTime", 0L);
                    this.accountPeriodList.add(new AccountPeriodInfo(currencyType, amount, startTime, endTime));
                }
            }
        }
        catch (Exception e) {
            RLog.error((Object)"ToInfoResponse", (String)"parserResponse error.", (Throwable)e);
        }
    }

    public String getSeq() {
        return this.seq;
    }

    public long getUid() {
        return this.uid;
    }

    public int getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public long getMinAmountLimit() {
        return this.minAmountLimit;
    }

    public List<AccountCurrencyInfo> getAccountList() {
        return this.accountList;
    }

    public List<UserProps> getUserPropsList() {
        return this.userPropsList;
    }

    public List<AccountPeriodInfo> getAccountPeriodList() {
        return this.accountPeriodList;
    }
}

