//
// Created by HuTao on 2019/2/22.
//

#ifndef YYSERVICESDK_PARENT_ICHANNEL_H
#define YYSERVICESDK_PARENT_ICHANNEL_H

#include "ServiceCodeDef.h"
namespace Service {
    
    struct CStringKeyValue
    {
        CString key;
        CString value;
    };
    
    struct IServiceLog
    {
        virtual ~IServiceLog(){}
        /**
        * 回调SDK日志，目前SDK日志比较精简，都是必要的，所以未区分Level
        */
        virtual void OnLog(const char* msg) = 0;
    };
    
    struct IServiceStatusNotify {
        /**
        * 回调通道链接的状态，取值{CodeDef.h}中{Status}
        */
        virtual int OnStatus(int status) = 0;
        /**
         * 回调SDK从服务器同步下来的时间戳，单位ms
         */
        virtual void OnSyncServiceTime(uint64_t ts) = 0;
    };
    
    struct CallOptions {
        /**
         * 设置该上行请求任何情况下(无论是否有用UID Bind/UnBind Service)都不需要在Service通道层鉴权：
         * 1）在调用Bind Service之前的RPC请求，SDK默认都会填入UID=0传到ServiceAP服务器不会进行鉴权
         * 2）调用Bind Service接口之后所有RPC请求SDK默认都会填入UID并给到SerivceAP服务器进行鉴权，
         * 3）UDB这类服务无论何时都不需要在Service通道进行鉴权，因此需要调用此接口改变SDK对本次请求的默认行为
         */
        void setWithoutAuth();
        bool isWithoutAuth();
        
        /**
         * 是否单向上行的请求，部分协议可能会先回一个假的Response带上下文且sn/fn与上行请求一样，
         * 真正的Response后续单播下发返回
         * @param isOneWay
         */
        void setOneWay(bool isOneWay);
        bool isOneWay();
    
        CallOptions();
    private:
        bool mNeverAuth;
        bool mIsOneWay;
    };
    struct CallRetryOptions {
        /**
         * 设置该请求的超时时间，单位ms，最小值为1000ms，回调会在超时时间内返回
         * @param timespan
         */
        void setTimeoutMills(uint32_t timespan);
        
        uint32_t getTimeouMills();
        /**
         * 设置重试策略，单位ms，调用后依次间隔retrys[0]，reytrys[1]，... retrys[size-2]进行重试
         * 重试可能会让服务器收到多个相同的请求，sdk只会处理最先收到的Response并回调
         * 使用重试时，一些场景需要使用方做去重，通道重试出去的请求不会进行去重
         * @param retrys
         */
//        void setRetryStrategy(std::vector<uint32_t > retrys);
//        const std::vector<uint32_t>& getRetryStrategy();
        
        CallRetryOptions();
    private:
        uint32_t mTimeoutMills;
//        std::vector<uint32_t > mRetryIntervals;
    };
    
    struct RPCRequestParam
    {
        CString mBusinessContext; // [可选]
        CString mServiceName;// [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        CString mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        
        CString mProtoType; // [可选]协议类型
        CString mRequestData; // [必填]业务包
    
        // [可选]路由参数(相当于http请求'?'后面的参数)
        // key: 路由配置管理后台里用到的字段；(合法字符[_0-9a-zA-Z])
        // value: 字段值；(合法字符 URL安全字符集)
        // 例如业务希望能用频道id作为哈希路由的key，可以让客户端填 ”topsid”:”12345678”；
        // 管理后台相应配置”topsid”
//        std::map<std::string, std::string> mRouteArgs;
        CStringKeyValue* mRouteArgs;
        int mRouteSize;
        
        // [可选]客户端信息(相当于http请求的header)
        // key: (合法字符 URL安全字符集)
        // value: (合法字符 URL安全字符集)
        // 接入点会修改
        // 暂不支持相同key
        //sdk---udb   sdk---channel 2个key留作SDK内部用，业务请勿使用!!!!
//        std::map<std::string, std::string> mClientHeaders;
        CStringKeyValue* mClientHeaders;
        int mHeaderSize;
        
        CallRetryOptions mRetryOption;//超时或重试策略
        CallOptions mCallOption;//请看CallOption说明
		
		RPCRequestParam();
    };
    struct RPCResponseParam
    {
        CString mBusinessContext; // [可选]如无外层包，必需提供上下文字段
        uint32_t mResCode; // [必填]返回码
        CString  mResMsg; // [可选]返回码描述
        
        // 若超时无回复，以下字段填空返回
        CString mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        CString mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
    
        CString mProtoType; // [可选]协议类型
        CString mResponseData; // [必填]业务包
    
        // [可选]服务端信息(相当于http回复的header)
        // key: (合法字符 URL安全字符集)
        // value: (合法字符 URL安全字符集)
        // 暂不支持相同key
//        std::map<std::string, std::string> mServerHeaders;
        CStringKeyValue* mServerHeaders;
        int mServiceHeaderSize;
		
		RPCResponseParam();
    };
    
    struct IRPCCallback {
    public:
        IRPCCallback() {}
        
        virtual ~IRPCCallback() {}
        /**
         * 成功的回调（通道的成功，业务是否成功需要在mRequestData中定义）
         * @param reqParam 请求
         * @param traceId 监控TraceId
         * @param resParam 响应
         */
        virtual void OnRequestSuccess(RPCRequestParam &reqParam, CString traceId,
                                      RPCResponseParam &resParam)= 0;
        /**
         * 失败的回调（通道的失败）
         * @param reqParam 请求
         * @param traceId 监控TraceId
         * @param resCode 返回码，取值请看{CodeDef.h}中{CommonResCode}定义
         * @param errDesc 返回码描述
         */
        virtual void OnRequestFail(RPCRequestParam &reqParam, CString traceId,
                                   int resCode, CString errDesc) = 0;
    };
    struct LoginRequestParam {
        uint64_t mUid; // [必填] 匿名填0
        uint32_t mTokenType;// 0 - 默认，原来的otp；1 - 第三方token;2- 国内YY账号体系下的linkd的token
    
        CallRetryOptions mRetryOption;//超时或重试策略
    };
    struct LoginResponseParam {
        uint32_t mResCode; // 返回码
        CString mResMsg; // 返回码描述
    };
    
    struct IAuthTokenProvider
    {
        /**
         * 登录Service通道鉴权UID时的回调，通过此接口向SDK提供token
         * @param uid
         * @return 返回对应的token
         */
        virtual CString OnRequestToken(uint64_t& uid) = 0;
    };
    struct IAuthCallback {
        /**
         * 登录Service通道鉴权成功的回调
         * @param reqParam 请求
         * @param traceId 监控TraceId
         * @param resParam 响应
         */
        virtual void OnLoginSuccess(LoginRequestParam& reqParam, CString traceId,
                                    LoginResponseParam& resParam) = 0;
        /**
         * 登录Service通道鉴权失败的回调
         * @param reqParam 请求
         * @param traceId 监控TraceId
         * @param resCode 返回码，取值请看{CodeDef.h}中{BindResCode}定义
         * @param errDesc 返回码描述
         */
        virtual void OnLoginFail(LoginRequestParam& reqParam, CString traceId,
                                 int resCode, CString errDesc) = 0;
    };
    struct LoginForceOutNotify{
        uint64_t mUid;
        uint32_t mCode;  //踢下线的原因
        CString mDesc;//踢下线的描述，可直接提示UI
    };
    struct IAuthForceOutNotify {
        /**
         * 多端登录时被踢
         * @param forceOutNotify
         */
        virtual void OnForceOut(LoginForceOutNotify &forceOutNotify) = 0;
    };

    struct IAuthOutCallback {
        /**
         * 退出Service通道成功
         * @param traceId 监控TraceId
         */
        virtual void OnLogoutSuccess(CString traceId) = 0;
        /**
         * 退出Service通道成功
         * @param traceId 监控TraceId
         * @param resCode 返回码，取值请看{CodeDef.h}中{BindResCode}定义
         * @param errDesc 返回码描述
         */
        virtual void OnLogoutFail(CString traceId, int resCode,
                                  CString errDesc) = 0;
    };
    
    struct BroadcastGroup {
        uint64_t groupType;//广播组类型
        uint64_t groupId;//广播组ID
    
        BroadcastGroup();
    
        BroadcastGroup(uint64_t type, uint64_t id);
    
        bool operator<(const BroadcastGroup& right) const;
    
        bool operator==(const BroadcastGroup& right) const;
    
//        void dumpString(std::stringstream& strStream) const;
    
        CString getString() const;
        
    };
    
    struct ScribeRequest {
        bool mOpType;//true=订阅，false=取消订阅
//        std::set<BroadcastGroup> mGroups;//广播组
        BroadcastGroup* mGroups;
        int mGroupSize;
        
        CallRetryOptions mRetryOption;//超时或重试策略
		
		ScribeRequest();
    };
    struct ScribeResponse {
        uint32_t mResCode; // 返回码,取值请看{CodeDef.h}中{CommonResCode}服务端返回码部分
        CString mResMsg; // 返回码描述
    };
    
    struct IScribeBroadcastCallback {
        /**
         * 订阅/取消订阅 广播组成功
         * @param reqParam 请求
         * @param reqId 请求上下文标示ID
         * @param resParam 响应
         */
        virtual void OnSuccess(ScribeRequest &reqParam,
                               uint32_t reqId, ScribeResponse &resParam) = 0;
        /**
         * 订阅/取消订阅 广播组失败
         * @param reqParam 请求
         * @param reqId 请求上下文标示ID
         * @param resCode // 返回码,取值请看{CodeDef.h}中{CommonResCode}定义
         * @param errDesc // 返回码描述
         */
        virtual void OnFail(ScribeRequest &reqParam, uint32_t reqId, int resCode, CString errDesc) = 0;
    };
    struct UnicastMsg {
        CString mServiceName; // 业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        CString mFunctionName; // 业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        CString mProtoType; // 协议类型
        CString mData; // 业务包
    
        CString mTraceId; // 追踪监控用
    };
    struct IUnicastNotify {
        /**
         * 接受到单播消息
         * @param unicastMsg
         */
        virtual void OnUnicast(UnicastMsg &unicastMsg) = 0;
        /**
         * OneWay方式的上行RPC请求对应的真正回包
         * @param realRPCResponse
         */
        virtual void OnDLResponse(RPCResponseParam& realRPCResponse) = 0;
    };
    struct BroadcastMsg {
        BroadcastGroup mGroup; // 广播组
    
        CString mServiceName; // 业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
        CString mFunctionName; // 业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
        CString mProtoType; // 协议类型
        CString mData; // 业务包
        
        CString mTraceId; // 追踪监控用
    };
    struct IBroadcastNotify {
        /**
         * 接收到广播消息
         * @param broadNotify
         */
        virtual void OnBroadcast(BroadcastMsg &broadNotify) = 0;
    };
    
    class ICoreChannel {
    public:
        ICoreChannel() {};
        
        virtual ~ICoreChannel() {};
        /**
         * 开始建立该通道实例的链接，初始化init时候返回的实例不需要调用此接口（默认内部会open）
         * @param statusNotify
         * @param testaddr 测试用的Service的IP
         * @param testport 测试用的Service的端口
         */
        virtual int Open(IServiceStatusNotify *statusNotify, CString testaddr, int testport) = 0;
        /**
         * 关掉连接,如果没有调用Open，也不需要调用Close
         */
        virtual int Close() = 0;
        /**
         * 设置全局生效的默认Headers
         * @param globalHeaders 默认会携带的Headers
         */
        virtual void SetGlobalHeaders(CStringKeyValue* globalHeaders,int headerSize) = 0;
        /**
         * 设置全局生效的Routes，目前支持目标区域set集，key=setselector，value=2位CountryCode，如CN，US
         * @param globalRoutes 默认会携带的Routes
         */
        virtual void SetGlobalRoutes(CStringKeyValue* globalRoutes,int routeSize) = 0;
        /**
         * 上下行请求
         * @param request 请求参数
         * @param callback 回调
         */
        virtual int RpcCall(RPCRequestParam &request, IRPCCallback *callback) = 0;
        
        /**
         * 注册/注销广播接收器
         * @param regist 注册=true，注销=false
         */
        virtual void RegistBroadcastListener(bool regist, IBroadcastNotify *listener) = 0;
        /**
         * 开始订阅某个广播组的广播
         * @param requestParam 请求参数
         * @param callback 回调
         */
        virtual int ScribeBroadcast(ScribeRequest &requestParam,
                                    IScribeBroadcastCallback *callback) = 0;
    
        /**
         * 登录Service通道鉴权
         * @param request 请求参数
         * @param authTokenProvider 提供对应UID的Token
         * @param callback 回调
         */
        virtual int Bind(LoginRequestParam& request,
                         IAuthTokenProvider* authTokenProvider,IAuthCallback *callback) = 0;
        /**
         * 退出Service通道
         * @param callback
         */
        virtual int UnBind(IAuthOutCallback *callback) = 0;
        /**
         * 注册监听多端登录时的被踢通知
         * @param regist 注册=true，注销=false
         */
        virtual void RegistAuthForceoutListener(bool regist, IAuthForceOutNotify *listener) = 0;
        /**
         * 注册/注销单播接收器
         * @param regist 注册=true，注销=false
         */
        virtual void RegistUnicastListener(bool regist, IUnicastNotify *listener) = 0;
    };
    /**
     * 是否启用弱网SDK
     */
    void setUseTrans(bool useTrans);
    
    /**
     * 初始化SDK实例，并开始建立一条连接返回[目前只有一条连接通道，多个模块共享，与Java/OC接口初始化接口可重入调用，返回最先初始化出来的Channel]
     * @param appName app名称，主要用来统计
     * @param appVer app名称，主要用来统计及bug调查
     * @param logger 写SDK日志的实现
     * @param appid AppId
     * @param region 大多数情况填""空值，则默认就近接入AP；
     *              少数情况填值则指定连到对应区域的AP，并且后台可配置，取值于{https://zh.wikipedia.org/wiki/ISO_3166-1}中的二位代码
     * @param statusNotify
     *              通道的状态，取值请看{CodeDef.h}中{Status}定义
     */
    ICoreChannel* initSDK(CString appName,
                          CString appVer,
                          IServiceLog *logger,
                          uint32_t appid,
                          CString region,
                          IServiceStatusNotify *statusNotify);
    /**
     * 初始化SDK实例，并开始建立一条连接返回[目前只有一条连接通道，多个模块共享，与Java/OC接口初始化接口可重入调用，返回最先初始化出来的Channel]
     * @param appName app名称，主要用来统计
     * @param appVer app名称，主要用来统计及bug调查
     * @param logger 写SDK日志的实现
     * @param appid AppId
     * @param region 大多数情况填""空值，则默认就近接入AP；
     *              少数情况填值则指定连到对应区域的AP，并且后台可配置，取值于{https://zh.wikipedia.org/wiki/ISO_3166-1}中的二位代码
     * @param statusNotify
     *              通道的状态，取值请看{CodeDef.h}中{Status}定义
     * @param testIP 测试用的Service的IP
     * @param testPort 测试用的Service的端口
     */
    ICoreChannel* initSDKWithTest(CString appName,
                                  CString appVer,
                                  IServiceLog *logger,
                                  uint32_t appid, CString region,
                                  IServiceStatusNotify *statusNotify,
                                  CString testIP, int testPort);
    /**
     * 释放ServiceSDK实例
     */
    void deInitSDK();
}

#endif //YYSERVICESDK_PARENT_ICHANNEL_H
