/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.baseservice;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.yy.platform.baseservice.ConstCode;
import com.yy.platform.baseservice.IChannel;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.a.a;
import com.yy.platform.baseservice.a.b;
import com.yy.platform.baseservice.a.d;
import com.yy.platform.baseservice.a.e;
import com.yy.platform.baseservice.a.f;
import com.yy.platform.baseservice.a.g;
import com.yy.platform.baseservice.a.h;
import com.yy.platform.baseservice.a.i;
import com.yy.platform.baseservice.a.j;
import com.yy.platform.baseservice.marshal.c;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.statis.n;
import com.yy.platform.baseservice.task.AbstractTask;
import com.yy.platform.baseservice.task.BindTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTaskV2;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.task.RequestDefaultArgs;
import com.yy.platform.baseservice.task.UnBindTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.platform.baseservice.utils.UserGroupTypeString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Channel
implements IChannel {
    private IChannelListener.ITokenProvider mProvider = null;
    private IChannelListener.IChannelStatusNotify mListener = null;
    private IChannelListener.IForceUnBindNotify mAuthNotify = null;
    private List<IChannelListener.IServiceBroadcastNotify> mBroadcastListeners = new CopyOnWriteArrayList<IChannelListener.IServiceBroadcastNotify>();
    private List<IChannelListener.IServiceStrGroupBroadcastNotify> mStrGroupBroadcastListeners = new CopyOnWriteArrayList<IChannelListener.IServiceStrGroupBroadcastNotify>();
    private List<IChannelListener.IServiceUnicastNotify> mUnicastListeners = new CopyOnWriteArrayList<IChannelListener.IServiceUnicastNotify>();
    private Map<Integer, AbstractTask> mRequests = null;
    private Map<IChannelListener.IChannelStatusNotify, Handler> mOtherListener = null;
    private Map<IChannelListener.IServiceBroadcastNotify, Handler> mOtherBroadListener = null;
    private Map<IChannelListener.IServiceStrGroupBroadcastNotify, Handler> mOtherStrBroadListener = null;
    private Map<IChannelListener.IServiceUnicastNotify, Handler> mOtherUniListener = null;
    private int mId = -1;
    private LogProfile.ILog mLogger = null;
    private Handler mMainHandler = null;
    private Long mServerTimeDiff = 0L;
    private e mStatisInit = null;
    IChannelListener.IReportPktApi mReportPktApi;
    private boolean mInitSuccess = false;

    public Channel(Handler handler, LogProfile.ILog iLog, boolean bl) {
        this.mLogger = iLog;
        this.mInitSuccess = bl;
        this.mMainHandler = handler;
        this.mListener = null;
        this.mRequests = new ConcurrentHashMap<Integer, AbstractTask>();
        this.mOtherListener = new ConcurrentHashMap<IChannelListener.IChannelStatusNotify, Handler>();
        this.mOtherBroadListener = new ConcurrentHashMap<IChannelListener.IServiceBroadcastNotify, Handler>();
        this.mOtherStrBroadListener = new ConcurrentHashMap<IChannelListener.IServiceStrGroupBroadcastNotify, Handler>();
        this.mOtherUniListener = new ConcurrentHashMap<IChannelListener.IServiceUnicastNotify, Handler>();
    }

    private Channel() {
        this.mInitSuccess = false;
    }

    public Channel(Handler handler, LogProfile.ILog iLog) {
        this.mLogger = iLog;
        this.mInitSuccess = false;
        this.mMainHandler = handler;
        this.mListener = null;
        this.mRequests = new ConcurrentHashMap<Integer, AbstractTask>();
        this.mOtherListener = new ConcurrentHashMap<IChannelListener.IChannelStatusNotify, Handler>();
        this.mOtherBroadListener = new ConcurrentHashMap<IChannelListener.IServiceBroadcastNotify, Handler>();
        this.mOtherStrBroadListener = new ConcurrentHashMap<IChannelListener.IServiceStrGroupBroadcastNotify, Handler>();
        this.mOtherUniListener = new ConcurrentHashMap<IChannelListener.IServiceUnicastNotify, Handler>();
    }

    private boolean checkInit() {
        if (!this.mInitSuccess) {
            if (this.mLogger != null) {
                this.mLogger.outputLog("not inited");
                Log.i((String)YYServiceCore.TAG, (String)"not inited");
            }
            return false;
        }
        return true;
    }

    protected int startConnect(String string, int n2, IChannelListener.IChannelStatusNotify iChannelStatusNotify) {
        if (!this.checkInit()) {
            return -100;
        }
        this.mListener = iChannelStatusNotify;
        if (string == null) {
            string = "";
        }
        this.connect(string.getBytes(), n2);
        return 0;
    }

    protected int stopConnect() {
        if (!this.checkInit()) {
            return -100;
        }
        return this.close();
    }

    protected void release() {
        if (!this.mInitSuccess) {
            return;
        }
        this.mInitSuccess = false;
    }

    @Override
    public void setDefaultRouteArgs(Map<String, String> map) {
        if (!this.checkInit()) {
            return;
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.mLogger != null) {
            String string = "default route size:" + map.size();
            this.mLogger.outputLog(new String(string));
        }
        int n2 = (int)YYServiceCore.increaseId();
        RequestDefaultArgs requestDefaultArgs = new RequestDefaultArgs(n2, null, null, null, 1, map);
        this.setDefaultArgs(requestDefaultArgs.marshall());
    }

    @Override
    public void setDefaultHeaders(Map<String, String> map) {
        if (!this.checkInit()) {
            return;
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.mLogger != null) {
            String string = "default header size:" + map.size();
            this.mLogger.outputLog(new String(string));
        }
        int n2 = (int)YYServiceCore.increaseId();
        RequestDefaultArgs requestDefaultArgs = new RequestDefaultArgs(n2, null, null, null, 2, map);
        this.setDefaultArgs(requestDefaultArgs.marshall());
    }

    @Override
    public int rpcCall(RPCTask.RequestParam requestParam, Bundle bundle, IRPCChannel.RPCCallback<RPCTask.ResponseParam> rPCCallback) {
        return this.rpcCall(requestParam, bundle, this.mMainHandler, rPCCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rpcCall(RPCTask.RequestParam requestParam, Bundle bundle, Handler handler, IRPCChannel.RPCCallback<RPCTask.ResponseParam> rPCCallback) {
        if (!this.checkInit()) {
            return -100;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n2 = (int)YYServiceCore.increaseId();
            RPCTask rPCTask = new RPCTask(n2, requestParam, rPCCallback, bundle, handler == null ? this.mMainHandler : handler);
            this.mRequests.put(n2, rPCTask);
            int n3 = this.request(rPCTask.marshall());
            if (n3 == 0) {
                return n2;
            }
            this.mRequests.remove(n2);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rpcCall(RPCTask.RequestParam requestParam, Bundle bundle, Handler handler, IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam> rPCCallbackWithTrace) {
        if (!this.checkInit()) {
            return -100;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n2 = (int)YYServiceCore.increaseId();
            RPCTask rPCTask = new RPCTask(n2, requestParam, rPCCallbackWithTrace, bundle, handler == null ? this.mMainHandler : handler);
            this.mRequests.put(n2, rPCTask);
            int n3 = this.request(rPCTask.marshall());
            if (n3 == 0) {
                return n2;
            }
            this.mRequests.remove(n2);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bind(long l2, int n2, IChannelListener.ITokenProvider iTokenProvider, final IRPCChannel.RPCCallback<BindTask.ResponseParam> rPCCallback) {
        if (!this.checkInit()) {
            return -100;
        }
        n.a().a(l2);
        this.mProvider = iTokenProvider;
        int n3 = 0;
        if (0L == l2) {
            n3 = -5;
        }
        if (n3 < 0) {
            final int n4 = n3;
            final int n5 = (int)YYServiceCore.increaseId();
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    rPCCallback.onFail(n5, n4, -255, new Exception(ConstCode.SdkResCode.desc(n4)));
                }
            });
            return -1;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n6 = (int)YYServiceCore.increaseId();
            BindTask.RequestParam requestParam = new BindTask.RequestParam(l2, "".getBytes(), n2);
            requestParam.setSeqId(n6);
            BindTask bindTask = new BindTask(n6, requestParam, rPCCallback, null, this.mMainHandler);
            this.mRequests.put(n6, bindTask);
            int n7 = this.request(bindTask.marshall());
            if (n7 == 0) {
                return n6;
            }
            this.mRequests.remove(n6);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unBind(IRPCChannel.RPCCallback<UnBindTask.ResponseParam> rPCCallback) {
        if (!this.checkInit()) {
            return -100;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n2 = (int)YYServiceCore.increaseId();
            UnBindTask unBindTask = new UnBindTask(n2, new UnBindTask.RequestParam("", 0L), rPCCallback, null, this.mMainHandler);
            this.mRequests.put(n2, unBindTask);
            int n3 = this.request(unBindTask.marshall());
            if (n3 == 0) {
                return n2;
            }
            this.mRequests.remove(n2);
        }
        return -1;
    }

    @Override
    public int subscribeBroadcast(ArrayList<UserGroupType> arrayList, IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> rPCCallback) {
        return this.subOrUnSubBroadCast((byte)1, "", arrayList, rPCCallback);
    }

    @Override
    public int unSubscribeBroadcast(ArrayList<UserGroupType> arrayList, IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> rPCCallback) {
        return this.subOrUnSubBroadCast((byte)0, "", arrayList, rPCCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int subOrUnSubBroadCast(byte by, String string, ArrayList<UserGroupType> arrayList, IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> rPCCallback) {
        if (!this.checkInit()) {
            return -100;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n2 = (int)YYServiceCore.increaseId();
            BroadSubOrUnSubTask broadSubOrUnSubTask = new BroadSubOrUnSubTask(n2, new BroadSubOrUnSubTask.RequestParam(string, arrayList, by), rPCCallback, null, this.mMainHandler);
            this.mRequests.put(n2, broadSubOrUnSubTask);
            int n3 = this.request(broadSubOrUnSubTask.marshall());
            if (n3 == 0) {
                return n2;
            }
            this.mRequests.remove(n2);
        }
        return -1;
    }

    @Override
    public int subscribeStrBroadcast(Set<UserGroupTypeString> set, IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> rPCCallback) {
        return this.subOrUnSubStrBroadCast((byte)1, "", set, rPCCallback);
    }

    @Override
    public int unSubscribeStrBroadcast(Set<UserGroupTypeString> set, IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> rPCCallback) {
        return this.subOrUnSubStrBroadCast((byte)0, "", set, rPCCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int subOrUnSubStrBroadCast(byte by, String string, Set<UserGroupTypeString> set, IRPCChannel.RPCCallback<BroadSubOrUnSubTaskV2.ResponseParam> rPCCallback) {
        if (!this.checkInit()) {
            return -100;
        }
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            int n2 = (int)YYServiceCore.increaseId();
            BroadSubOrUnSubTaskV2 broadSubOrUnSubTaskV2 = new BroadSubOrUnSubTaskV2(n2, new BroadSubOrUnSubTaskV2.RequestParam(string, set, by), rPCCallback, null, this.mMainHandler);
            this.mRequests.put(n2, broadSubOrUnSubTaskV2);
            int n3 = this.request(broadSubOrUnSubTaskV2.marshall());
            if (n3 == 0) {
                return n2;
            }
            this.mRequests.remove(n2);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getServerTimeStampDiff() {
        Long l2 = this.mServerTimeDiff;
        synchronized (l2) {
            return this.mServerTimeDiff;
        }
    }

    @Override
    public void setForceUnBindListener(IChannelListener.IForceUnBindNotify iForceUnBindNotify) {
        this.mAuthNotify = iForceUnBindNotify;
    }

    @Override
    public void registUnicastListener(IChannelListener.IServiceUnicastNotify iServiceUnicastNotify) {
        this.mUnicastListeners.add(iServiceUnicastNotify);
        if (this.mLogger != null) {
            String string = "regist unicastlistener size:" + this.mUnicastListeners.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void unregistUnicastListener(IChannelListener.IServiceUnicastNotify iServiceUnicastNotify) {
        this.mUnicastListeners.remove(iServiceUnicastNotify);
        this.mOtherUniListener.remove(iServiceUnicastNotify);
        if (this.mLogger != null) {
            String string = "unregist unicastlistener size:" + this.mUnicastListeners.size() + ",other size:" + this.mOtherUniListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceBroadcastNotify iServiceBroadcastNotify) {
        this.mBroadcastListeners.add(iServiceBroadcastNotify);
        if (this.mLogger != null) {
            String string = "regist broadcastlistener size:" + this.mBroadcastListeners.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void unregistBroadcastListener(IChannelListener.IServiceBroadcastNotify iServiceBroadcastNotify) {
        this.mBroadcastListeners.remove(iServiceBroadcastNotify);
        this.mOtherBroadListener.remove(iServiceBroadcastNotify);
        if (this.mLogger != null) {
            String string = "unregist broadcastlistener size:" + this.mBroadcastListeners.size() + ",other size:" + this.mOtherBroadListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify iServiceStrGroupBroadcastNotify) {
        this.mStrGroupBroadcastListeners.add(iServiceStrGroupBroadcastNotify);
        if (this.mLogger != null) {
            String string = "regist str broadcastlistener size:" + this.mStrGroupBroadcastListeners.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void unregistBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify iServiceStrGroupBroadcastNotify) {
        this.mStrGroupBroadcastListeners.remove(iServiceStrGroupBroadcastNotify);
        this.mOtherStrBroadListener.remove(iServiceStrGroupBroadcastNotify);
        if (this.mLogger != null) {
            String string = "unregist str broadcastlistener size:" + this.mStrGroupBroadcastListeners.size() + ",other size:" + this.mOtherStrBroadListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registUnicastListener(IChannelListener.IServiceUnicastNotify iServiceUnicastNotify, Handler handler) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        this.mOtherUniListener.put(iServiceUnicastNotify, handler);
        if (this.mLogger != null) {
            String string = "regist other unicastlistener size:" + this.mOtherUniListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceBroadcastNotify iServiceBroadcastNotify, Handler handler) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        this.mOtherBroadListener.put(iServiceBroadcastNotify, handler);
        if (this.mLogger != null) {
            String string = "regist other broadcastlistener size:" + this.mOtherBroadListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registBroadcastListener(IChannelListener.IServiceStrGroupBroadcastNotify iServiceStrGroupBroadcastNotify, Handler handler) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        this.mOtherStrBroadListener.put(iServiceStrGroupBroadcastNotify, handler);
        if (this.mLogger != null) {
            String string = "regist other str broadcastlistener size:" + this.mOtherStrBroadListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void registChannelStatusListener(IChannelListener.IChannelStatusNotify iChannelStatusNotify, Handler handler) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        this.mOtherListener.put(iChannelStatusNotify, handler);
        if (this.mLogger != null) {
            String string = "regist more status listener size:" + this.mOtherListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public void unregistChannelStatusListener(IChannelListener.IChannelStatusNotify iChannelStatusNotify) {
        this.mOtherListener.remove(iChannelStatusNotify);
        if (this.mLogger != null) {
            String string = "unregist more status listener size:" + this.mOtherListener.size();
            this.mLogger.outputLog(new String(string));
        }
    }

    @Override
    public int getInstId() {
        if (!this.checkInit()) {
            return -100;
        }
        return this.instId();
    }

    protected void onNetworkChange(int n2) {
        if (!this.checkInit()) {
            return;
        }
        this.networkChange(n2);
    }

    private native int instId();

    private native int connect(byte[] var1, int var2);

    private native int connectNative(byte[] var1, int var2);

    private native int close();

    private native int setDefaultArgs(byte[] var1);

    private native int request(byte[] var1);

    private native int networkChange(int var1);

    private native int getNetOptimize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChannelStatus(final int n2) {
        this.mMainHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Channel.this.mListener == null) {
                    return;
                }
                IChannelListener.IChannelStatusNotify iChannelStatusNotify = Channel.this.mListener;
                synchronized (iChannelStatusNotify) {
                    Channel.this.mListener.onStatus(n2);
                }
            }
        });
        Map<IChannelListener.IChannelStatusNotify, Handler> map = this.mOtherListener;
        synchronized (map) {
            for (final Map.Entry<IChannelListener.IChannelStatusNotify, Handler> entry : this.mOtherListener.entrySet()) {
                entry.getValue().post(new Runnable(){

                    @Override
                    public void run() {
                        ((IChannelListener.IChannelStatusNotify)entry.getKey()).onStatus(n2);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSyncServerTime(long l2) {
        long l3 = l2 - System.currentTimeMillis();
        Long l4 = this.mServerTimeDiff;
        synchronized (l4) {
            this.mServerTimeDiff = l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] requestToken(long l2) {
        if (this.mProvider == null) {
            return "".getBytes();
        }
        IChannelListener.ITokenProvider iTokenProvider = this.mProvider;
        synchronized (iTokenProvider) {
            byte[] byArray = this.mProvider.getToken(l2);
            if (byArray == null) {
                return "".getBytes();
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponseSuccess(int n2, int n3, byte[] byArray) {
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            c c2 = this.mRequests.remove(n2);
            if (c2 != null) {
                AbstractTask abstractTask = (AbstractTask)c2;
                abstractTask.unmarshall(byArray);
                abstractTask.onResponseSuccess(n2, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponseFail(int n2, int n3, byte[] byArray) {
        Map<Integer, AbstractTask> map = this.mRequests;
        synchronized (map) {
            c c2 = this.mRequests.remove(n2);
            if (c2 != null) {
                AbstractTask abstractTask = (AbstractTask)c2;
                abstractTask.unmarshall(byArray);
                abstractTask.onResponseFail(n2, n3);
            }
        }
    }

    private void onForceOutNotify(long l2, byte[] byArray) {
        final com.yy.platform.baseservice.a.c c2 = new com.yy.platform.baseservice.a.c();
        c2.unmarshall(byArray);
        this.mMainHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Channel.this.mAuthNotify == null) {
                    return;
                }
                IChannelListener.IForceUnBindNotify iForceUnBindNotify = Channel.this.mAuthNotify;
                synchronized (iForceUnBindNotify) {
                    if (Channel.this.mAuthNotify != null) {
                        Channel.this.mAuthNotify.onForceOut(c2.b, c2.c, c2.d);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnicastNotify(long l2, byte[] byArray) {
        final j j2 = new j();
        j2.unmarshall(byArray);
        this.mMainHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Channel.this.mUnicastListeners;
                synchronized (list) {
                    for (IChannelListener.IServiceUnicastNotify iServiceUnicastNotify : Channel.this.mUnicastListeners) {
                        iServiceUnicastNotify.onUnicast(j2.b, j2.d, j2.e, j2.f, j2.g);
                    }
                }
            }
        });
        Map<IChannelListener.IServiceUnicastNotify, Handler> map = this.mOtherUniListener;
        synchronized (map) {
            for (final Map.Entry<IChannelListener.IServiceUnicastNotify, Handler> entry : this.mOtherUniListener.entrySet()) {
                entry.getValue().post(new Runnable(){

                    @Override
                    public void run() {
                        ((IChannelListener.IServiceUnicastNotify)entry.getKey()).onUnicast(j2.b, j2.d, j2.e, j2.f, j2.g);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBroadCastNotify(long l2, byte[] byArray) {
        final a a2 = new a();
        a2.unmarshall(byArray);
        this.mMainHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Channel.this.mBroadcastListeners;
                synchronized (list) {
                    for (IChannelListener.IServiceBroadcastNotify iServiceBroadcastNotify : Channel.this.mBroadcastListeners) {
                        iServiceBroadcastNotify.onBroadCast(a2.b, a2.d, a2.e, a2.f, a2.g, a2.h, a2.i);
                    }
                }
            }
        });
        Map<IChannelListener.IServiceBroadcastNotify, Handler> map = this.mOtherBroadListener;
        synchronized (map) {
            for (final Map.Entry<IChannelListener.IServiceBroadcastNotify, Handler> entry : this.mOtherBroadListener.entrySet()) {
                entry.getValue().post(new Runnable(){

                    @Override
                    public void run() {
                        ((IChannelListener.IServiceBroadcastNotify)entry.getKey()).onBroadCast(a2.b, a2.d, a2.e, a2.f, a2.g, a2.h, a2.i);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBroadCastV2Notify(long l2, byte[] byArray) {
        final b b2 = new b();
        b2.unmarshall(byArray);
        this.mMainHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Channel.this.mBroadcastListeners;
                synchronized (list) {
                    for (IChannelListener.IServiceStrGroupBroadcastNotify iServiceStrGroupBroadcastNotify : Channel.this.mStrGroupBroadcastListeners) {
                        iServiceStrGroupBroadcastNotify.onBroadCastFromStrGroup(b2.b, b2.d, b2.e, b2.f, b2.g, b2.h);
                    }
                }
            }
        });
        Map<IChannelListener.IServiceStrGroupBroadcastNotify, Handler> map = this.mOtherStrBroadListener;
        synchronized (map) {
            for (final Map.Entry<IChannelListener.IServiceStrGroupBroadcastNotify, Handler> entry : this.mOtherStrBroadListener.entrySet()) {
                entry.getValue().post(new Runnable(){

                    @Override
                    public void run() {
                        ((IChannelListener.IServiceStrGroupBroadcastNotify)entry.getKey()).onBroadCastFromStrGroup(b2.b, b2.d, b2.e, b2.f, b2.g, b2.h);
                    }
                });
            }
        }
    }

    @Override
    public void setHiidoMetricsApi(String string, IChannelListener.IServiceHiidoMetricsStatisApi iServiceHiidoMetricsStatisApi) {
        if (iServiceHiidoMetricsStatisApi != null) {
            n.a().a(iServiceHiidoMetricsStatisApi);
            com.yy.platform.baseservice.b.a.a.a(string);
        }
    }

    protected void initReport(long l2, String string, String string2, String string3) {
        this.mStatisInit = new e();
        this.mStatisInit.b = "ystinit";
        this.mStatisInit.c = new d.a[1];
        d.a a2 = new d.a();
        a2.b = new HashMap<String, Long>();
        a2.a = new HashMap<String, Integer>();
        a2.a.put("said", (int)l2);
        a2.c = new HashMap<String, String>();
        a2.c.put("appn", string);
        a2.c.put("appv", string2);
        a2.c.put("sdkv", string3);
        a2.c.put("osver", "And-" + Build.VERSION.RELEASE);
        a2.c.put("model", Build.MODEL);
        a2.c.put("lang", Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry());
        this.mStatisInit.c[0] = a2;
        this.mMainHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ((Channel)Channel.this).mStatisInit.c[0].b.put("uid", n.a().c());
                if (YYServiceCore.getInstance() != null) {
                    n.a().a(Channel.this.mStatisInit);
                }
            }
        }, 10000L);
    }

    private void onReport(long l2, byte[] byArray) {
        if (l2 == 55L) {
            e e2 = new e();
            e2.unmarshall(byArray);
            n.a().a(e2);
        } else if (l2 == 56L) {
            i i2 = new i();
            i2.unmarshall(byArray);
            n.a().a(i2);
        } else if (l2 == 57L) {
            h h2 = new h();
            h2.unmarshall(byArray);
            n.a().a(h2);
        } else if (l2 == 58L) {
            g g2 = new g();
            g2.unmarshall(byArray);
            n.a().a(g2);
        } else if (l2 == 59L) {
            f f2 = new f();
            f2.unmarshall(byArray);
            n.a().a(f2.b);
            n.a().a(f2.c);
        }
    }

    @Override
    public void setReportPktApi(IChannelListener.IReportPktApi iReportPktApi) {
        if (iReportPktApi != null) {
            this.mReportPktApi = iReportPktApi;
        }
    }

    private void onReportPktErr(final int n2, final byte[] byArray, final byte[] byArray2) {
        String string = "error pkt,code:" + n2 + ",pkt len:" + byArray.length;
        YYServiceCore.log(string);
        if (this.mReportPktApi == null) {
            return;
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                Channel.this.mReportPktApi.reportPktError(n2, new String(byArray), new String(byArray2));
            }
        });
    }

    @Override
    public int getNetOptimizeSwitch() {
        if (!this.checkInit()) {
            return -100;
        }
        return this.getNetOptimize();
    }
}

