//
// Created by HuTao on 2019/4/13.
//

#ifndef YYSERVICESDK_PARENT_REQUESTRESPONSE_H
#define YYSERVICESDK_PARENT_REQUESTRESPONSE_H

#include "commondefine.h"
#include "packet.h"
#include "LogFile.h"

#undef __CLASS__
#define __CLASS__ "ServiceChannel"

USING_NAMESPACE_BASEMOD

NAMESPACE_SERVICE_BEGIN

    class Context;
    class ServiceChannel;

    class AbstractTask : public Marshallable {
        friend class ServiceChannel;
    protected:
        ServiceChannel* mChannel;
    public:
//        typedef std::function<void(std::shared_ptr<AbstractTask>&)> HandleFunc;

        uint32_t mRef;

        int mSdkResCode;
        bool mIsFromUI;
        uint32_t mReqNum;

        uint32_t mRequestId;
        TaskOption mOptions;

        AbstractTask():mChannel(nullptr),mSdkResCode(-255),mRef(0)
                ,mIsFromUI(true),mReqNum(0),mRequestId(0){}
        virtual ~AbstractTask();

        virtual void marshal(Pack& pk) const;
        virtual void unmarshal(const Unpack& up);

        virtual bool isNeedBind() const;

        uint32_t getTimeoutTs();
        std::vector<uint32_t >& getRetryStrategy();

        virtual uint32_t uri() = 0;
        virtual std::string RequestData(const std::map<std::string, std::string>& routeArgs,
                                        const std::map<std::string, std::string>& clientHeaders,
                                        uint64_t uid,uint32_t retryNum,std::stringstream& trace) = 0;
        virtual uint32_t ResponseData(const Marshallable& msg,
                                      Context& ctx) = 0;

        virtual void HandleSuccess() = 0;
        virtual void HandleFail() = 0;
    };
    struct NotifyTask : public Marshallable
    {
        virtual ~NotifyTask(){}

        virtual uint32_t uri() = 0;
    };

    class RPCTask : public AbstractTask
    {
    public:
        enum URIType{URI = 10};
        struct RequestParam : public Marshallable
        {
            std::string mBusinessContext; // [可选]如无外层包，必需提供上下文字段
            std::string mServerName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
            std::string mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
            std::string mProtoType; // [可选]协议类型
            std::string mRequestData; // [必填]业务包
            uint32_t mDataCRC; // [必填]业务包32位CRC校验
            // [可选]路由参数(相当于http请求'?'后面的参数)
            // key: 路由配置管理后台里用到的字段；(合法字符[_0-9a-zA-Z])
            // value: 字段值；(合法字符 URL安全字符集)
            // 例如业务希望能用频道id作为哈希路由的key，可以让客户端填 ”topsid”:”12345678”；
            // 管理后台相应配置”topsid”
            std::map<std::string, std::string> mRouteArgs;

            // [可选]客户端信息(相当于http请求的header)
            // key: (合法字符 URL安全字符集)
            // value: (合法字符 URL安全字符集)
            // 接入点会修改
            // 暂不支持相同key
            //sdk---udb   sdk---channel 2个key留作SDK内部用，业务请勿使用!!!!
            std::map<std::string, std::string> mClientHeaders;

            std::string mTraceId;// [必填]追踪监控用

            virtual ~RequestParam() {}
            virtual void marshal(Pack& pk) const
            {}
            virtual void unmarshal(const Unpack& up)
            {
                up >> mBusinessContext >> mServerName >> mFunctionName;
                UNPACK_STR_L32(up,mRequestData);
                up >> mProtoType >> mRouteArgs >> mClientHeaders >> mTraceId;
            }
        };
        struct ResponseParam : public NotifyTask{
            enum URIType{URI = 23};
            std::string mBusinessContext; // [可选]如无外层包，必需提供上下文字段
            uint32_t mResCode; // [必填]返回码
            std::string mResMsg; // [可选]返回码描述
            // 若超时无回复，以下字段填空返回
            std::string mServiceName; // [必填]业务路由配置依据(大类)(合法字符[0-9a-zA-Z])
            std::string mFunctionName; // [可选]业务路由配置依据(小类)(合法字符[0-9a-zA-Z])
            std::string mProtoType; // [可选]协议类型
            std::string mResponseData; // [必填]业务包
            uint32_t mDataCRC; // [必填]业务包32位CRC校验
            // [可选]服务端信息(相当于http回复的header)
            // key: (合法字符 URL安全字符集)
            // value: (合法字符 URL安全字符集)
            // 暂不支持相同key
            std::map<std::string, std::string> mServerHeaders;

            std::string mTraceId; // [必填]追踪监控用

            virtual uint32_t uri(){return URI;}
            ResponseParam():mResCode(-1){}
            virtual ~ResponseParam() {}
            virtual void marshal(Pack &pk) const
            {
                pk << mBusinessContext;
                pk << mResCode;
                pk << mResMsg;
                pk << mServiceName;
                pk << mFunctionName;
                pk << mProtoType;
                PACK_STR_L32(pk,mResponseData);
                pk << mServerHeaders;
                pk << mTraceId;
            };
            virtual void unmarshal(const Unpack &up) {
            }
        };

        RequestParam mReqParam;
        ResponseParam mResParam;

        RPCTask(){}
        virtual ~RPCTask(){}
        virtual void marshal(Pack& pk) const;
        virtual void unmarshal(const Unpack& up);

        virtual uint32_t uri(){return URI;}
        virtual std::string RequestData(const std::map<std::string, std::string>& routeArgs,
                                        const std::map<std::string, std::string>& clientHeaders,
                                        uint64_t uid,uint32_t retryNum,std::stringstream& tracelog);
        virtual uint32_t ResponseData(const Marshallable& msg, Context& ctx);
        virtual void HandleSuccess();
        virtual void HandleFail();
    };

    class LoginTask : public AbstractTask
    {
    public:
        enum URIType{URI = 11};
        struct RequestParam : public Marshallable
        {
            std::string mBusinessContext;
            uint64_t mUid; // [必填] 匿名填0
            std::string mToken; // [必填] otp票据
            uint64_t mSeqId;
            std::map<std::string, std::string> mClientHeaders;  // [可选] 填imei/终端类型/sdk版本/应用版本...
            uint32_t  mTokenType;// 0 - 默认，原来的otp；1 - 第三方token

            virtual ~RequestParam() {}
            virtual void marshal(Pack& pk) const
            {}
            virtual void unmarshal(const Unpack& up)
            {
                up >> mBusinessContext >> mUid >> mToken >> mSeqId >> mClientHeaders >> mTokenType;
            }
        };
        struct ResponseParam : public Marshallable{
            std::string mBusinessContext; // [可选]如无外层包，必需提供上下文字段
            uint32_t mResCode; // [必填]返回码
            std::string mResMsg; // [可选]返回码描述

            std::map<std::string, std::string> mServerHeaders;

            std::string mTraceId;
            ResponseParam():mResCode(-1){}
            virtual ~ResponseParam() {}
            virtual void marshal(Pack &pk) const
            {
                pk << mBusinessContext;
                pk << mResCode;
                pk << mResMsg;
                pk << mServerHeaders;
                pk << mTraceId;
            };
            virtual void unmarshal(const Unpack &up) {
            }
        };

        RequestParam mReqParam;
        ResponseParam mResParam;

        LoginTask(){}
        virtual ~LoginTask(){};
        virtual void marshal(Pack& pk) const
        {
            pk << mResParam;
        }
        virtual void unmarshal(const Unpack& up);
        virtual bool isNeedBind() const;

        virtual uint32_t uri(){return URI;}
        virtual std::string RequestData(const std::map<std::string, std::string>& routeArgs,
                                        const std::map<std::string, std::string>& clientHeaders,
                                        uint64_t uid,uint32_t retryNum,std::stringstream& tracelog);
        virtual uint32_t ResponseData(const Marshallable& msg, Context& ctx);
        virtual void HandleSuccess();
        virtual void HandleFail();
    };
    class LogoutTask : public AbstractTask
    {
    public:
        enum URIType{URI = 12};
        struct RequestParam : public Marshallable
        {
            std::string mBusinessContext;
            uint64_t mUid;
            virtual ~RequestParam() {}
            virtual void marshal(Pack& pk) const {}
            virtual void unmarshal(const Unpack& up){
                up >> mBusinessContext >> mUid;
            }
        };
        struct ResponseParam : public Marshallable
        {
            std::string mBusinessContext;
            uint32_t mResCode;
            std::string mResMsg;

            std::string mTraceId;
            ResponseParam():mResCode(-1){}
            virtual ~ResponseParam() {}
            virtual void marshal(Pack& pk) const {
                pk << mBusinessContext << mResCode << mResMsg << mTraceId;
            }
            virtual void unmarshal(const Unpack& up){}
        };
        RequestParam mReqParam;
        ResponseParam mResParam;

        LogoutTask(){}
        virtual ~LogoutTask(){}
        virtual void marshal(Pack& pk) const
        {
            pk << mResParam;
        }
        virtual void unmarshal(const Unpack& up);
        virtual bool isNeedBind() const;
        virtual uint32_t uri(){return URI;}
        virtual std::string RequestData(const std::map<std::string, std::string>& routeArgs,
                                        const std::map<std::string, std::string>& clientHeaders,
                                        uint64_t uid,uint32_t retryNum,std::stringstream& tracelog);
        virtual uint32_t ResponseData(const Marshallable& msg, Context& ctx);
        virtual void HandleSuccess();
        virtual void HandleFail();
    };

    enum UserGroupType
    {
        GROUP_TYPE_SID = 1,
        GROUP_TYPE_SUBSID,
    };

    static uint64_t toSubUserGroupType(uint64_t oldGroupType,uint32_t oldSvcType)
    {
        return (oldGroupType << 32) + oldSvcType;
    }
    static uint32_t toOldUserGroupType(uint64_t subGroupType)
    {
        return (subGroupType & 0xFFFFFFFF00000000) >> 32;
    }
    static uint32_t toOldSvcType(uint64_t subGroupType)
    {
        return (subGroupType & 0x00000000FFFFFFFF);
    }
    struct UserGroupIdType: public Marshallable
    {
        uint64_t userGroupType;
        uint64_t userGroupId;

        UserGroupIdType()
                : userGroupType(0)
                , userGroupId(0)
        {
        }

        UserGroupIdType(uint64_t type, uint64_t id)
        {
            userGroupType = type;
            userGroupId = id;
        }

        virtual void marshal(Pack& pk) const
        {
            pk << userGroupType << userGroupId;
        }

        virtual void unmarshal(const Unpack& up)
        {
            up >> userGroupType >> userGroupId;
        }

        bool operator<(const UserGroupIdType& right) const
        {
            return (userGroupId < right.userGroupId) ||
                   ((userGroupId == right.userGroupId) && (userGroupType < right.userGroupType));
        }

        bool operator==(const UserGroupIdType& right) const
        {
            return ((userGroupType == right.userGroupType) && (userGroupId == right.userGroupId));
        }

        void dumpString(std::stringstream& strStream) const
        {
            strStream << "userGroupType=" << userGroupType << ", userGroupId=" << userGroupId;
        }

        std::string getString() const
        {
            std::stringstream strStream;
            strStream << "userGroupType=" << userGroupType << ", userGroupId=" << userGroupId;
            return strStream.str();
        }
    };

    class BroadSubOrUnSubTask : public AbstractTask
    {
    public:
        enum URIType{URI = 13};
        struct RequestParam : public Marshallable
        {
            std::string mBusinessContext;
            std::set<UserGroupIdType> mUserGrps;
            bool mOptype;
            virtual ~RequestParam() {}
            virtual void marshal(Pack& pk) const {}
            virtual void unmarshal(const Unpack& up){
                up >> mBusinessContext;
                up >> mUserGrps;
                up >> mOptype;
            }
        };

        struct ResponseParam : public Marshallable
        {
            std::string mBusinessContext;
            uint32_t mResCode;

            std::string mErrMsg;
            ResponseParam():mResCode(-1){}
            virtual ~ResponseParam() {}
            virtual void marshal(Pack& pk) const {
                pk << mBusinessContext << mResCode << mErrMsg;
            }
            virtual void unmarshal(const Unpack& up){}
        };
        RequestParam mReqParam;
        ResponseParam mResParam;

        BroadSubOrUnSubTask(){}
        virtual ~BroadSubOrUnSubTask(){}
        virtual void marshal(Pack& pk) const;
        virtual void unmarshal(const Unpack& up);
        virtual uint32_t uri(){return URI;}
        virtual std::string RequestData(const std::map<std::string, std::string>& routeArgs,
                                        const std::map<std::string, std::string>& clientHeaders,
                                        uint64_t uid,uint32_t retryNum,std::stringstream& tracelog);
        virtual uint32_t ResponseData(const Marshallable& msg, Context& ctx);
        virtual void HandleSuccess();
        virtual void HandleFail();
    };

    struct ServiceActKeyItem : public Marshallable
    {
        std::map<std::string,uint32_t > mIntFields;
        std::map<std::string,uint64_t > mLongFields;
        std::map<std::string,std::string > mStringFields;

        ServiceActKeyItem(std::map<std::string,uint32_t >& intFields,
                          std::map<std::string,uint64_t >& longFields,
                          std::map<std::string,std::string >& stringFields)
                :mIntFields(intFields),mLongFields(longFields),mStringFields(stringFields)
        {

        }
        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            marshal_container(pk,mIntFields);
            marshal_container(pk,mLongFields);
            marshal_container(pk,mStringFields);
        }

    };
    struct ReportServiceAct : public NotifyTask
    {
    public:
        enum {URI = 55};
        std::string mAct;

        std::vector<ServiceActKeyItem> mKeyFields;

        virtual uint32_t uri(){ return URI;}
        ReportServiceAct():mAct("")
        {
        }
//		ReportServiceAct(const ReportServiceAct&) = default;
        ReportServiceAct(std::string act,
                         std::vector<ServiceActKeyItem>& keyFields)
                :mAct(act)
                ,mKeyFields(keyFields)
        {
        }
//		ReportServiceAct(ReportServiceAct&& rAct)
//				:mAct(rAct.mAct)
//				,mKeyFields(rAct.mKeyFields)
//		{
//
//		}
//		ReportServiceAct& operator=(ReportServiceAct&& rAct)
//		{
//			if(this != &rAct) {
//				mAct  = rAct.mAct;
//				mKeyFields = rAct.mKeyFields;
//			}
//			return *this;
//		}
        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mAct;
//			marshal_container(pk,mIntFields);
//			marshal_container(pk,mLongFields);
//			marshal_container(pk,mStringFields);
            pk << mKeyFields;
        }
    };
    struct ReportServiceRtt : public NotifyTask
    {
    public:
        enum {URI = 56};
        uint32_t mScode;

        std::string mUri;
        std::string mRttCode;
        uint64_t mRtt;

        virtual uint32_t uri(){ return URI;}
        ReportServiceRtt():mScode(0),mUri(""),mRttCode(""),mRtt(0)
        {
        }
        ReportServiceRtt(uint32_t scode,std::string& uri,std::string rttCode,uint64_t rtt)
                :mScode(scode),mUri(uri),mRttCode(rttCode),mRtt(rtt)
        {
        }
//        ReportServiceRtt(ReportServiceRtt& rRtt)
//        :mScode(rRtt.mScode),mUri(rRtt.mUri),mRttCode(rRtt.mRttCode),mRtt(rRtt.mRtt)
//        {
//        }
//		ReportServiceRtt(const ReportServiceRtt&) = default;

//		ReportServiceRtt(ReportServiceRtt&& rRtt)
//				:mScode(rRtt.mScode),mUri(rRtt.mUri),mRttCode(rRtt.mRttCode),mRtt(rRtt.mRtt)
//		{
//
//		}
//		ReportServiceRtt& operator=(ReportServiceRtt&& rRtt)
//		{
//			if(this != &rRtt) {
//				mScode  = rRtt.mScode;
//				mUri = rRtt.mUri;
//				mRttCode = rRtt.mRttCode;
//				mRtt = rRtt.mRtt;
//			}
//			return *this;
//		}
        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mScode << mUri << mRttCode << mRtt;
        }
    };
    struct ServiceCountItem : public Marshallable
    {
        std::string mCountName;
        uint64_t mCount;

        ServiceCountItem(std::string countName,uint64_t count)
                :mCountName(countName),mCount(count)
        {
        }

        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mCountName << mCount;
        }

    };
    struct ReportServiceCount : public NotifyTask
    {
    public:
        enum {URI = 57};
        uint32_t mScode;
        std::string mUri;

        std::vector<ServiceCountItem> mCountItems;

        virtual uint32_t uri(){ return URI;}
        ReportServiceCount():mScode(0),mUri("")
        {
        }
        ReportServiceCount(uint32_t scode,std::string uri,std::vector<ServiceCountItem>& countItems)
                :mScode(scode),mUri(uri),mCountItems(countItems)
        {
        }
//		ReportServiceCount(const ReportServiceCount&) = default;
//		ReportServiceCount(ReportServiceCount&& rCount)
//		:mScode(rCount.mScode),mUri(rCount.mUri),mCountItems(rCount.mCountItems)
//		{
//		}
//		ReportServiceCount& operator=(ReportServiceCount&& rCount)
//		{
//			if(this != &rCount) {
//				mScode  = rCount.mScode;
//				mUri = rCount.mUri;
//				mCountItems = rCount.mCountItems;
//			}
//			return *this;
//		}
        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mScode << mUri << mCountItems;
        }
    };
    struct ReportServiceActRtt : public NotifyTask
    {
    public:
        enum {URI = 58};
        ReportServiceAct mAct;
        ReportServiceRtt mRtt;

        virtual uint32_t uri(){ return URI;}
        ReportServiceActRtt():mAct(),mRtt()
        {
        }
        ReportServiceActRtt(const ReportServiceActRtt& rActRtt)
                :mAct(rActRtt.mAct),mRtt(rActRtt.mRtt)
        {

        }
        ReportServiceActRtt(ReportServiceAct& act,ReportServiceRtt& rtt)
                :mAct(act),mRtt(rtt)
        {
        }
//		ReportServiceActRtt(ReportServiceAct&& act,ReportServiceRtt&& rtt)
//		:mAct(std::move(act)),mRtt(std::move(rtt))
//		{
//		}
        ReportServiceActRtt(std::string act,
                            std::vector<ServiceActKeyItem>& keyFields)
                :mAct(act,keyFields)
        {
        }
        ReportServiceActRtt(uint32_t scode,std::string& uri,std::string& rttCode,uint64_t rtt)
                :mRtt(scode,uri,rttCode,rtt)
        {
        }

        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mAct << mRtt;
        }
    };
    struct ReportServiceActCount : public NotifyTask
    {
    public:
        enum {URI = 59};
        ReportServiceAct mAct;
        ReportServiceCount mCount;

        virtual uint32_t uri(){ return URI;}
        ReportServiceActCount():mAct(),mCount()
        {
        }
        ReportServiceActCount(const ReportServiceActCount& rActCount)
                :mAct(rActCount.mAct),mCount(rActCount.mCount)
        {

        }
//		ReportServiceActCount(ReportServiceAct&& act,ReportServiceCount&& count)
//		:mAct(std::move(act)),mCount(std::move(count))
//		{
//		}
        ReportServiceActCount(std::string act,
                              std::vector<ServiceActKeyItem>& keyFields)
                :mAct(act,keyFields)
        {
        }
//		ReportServiceActCount(uint32_t scode,std::string& uri,std::vector<ServiceCountItem>&& countItems)
//		:mCount(scode,uri,countItems)
//		{
//		}
        virtual void marshal(NAMESPACE_BASEMOD::Pack &pk) const
        {
            pk << mAct << mCount;
        }
    };
NAMESPACE_SERVICE_END
#endif //YYSERVICESDK_PARENT_REQUESTRESPONSE_H
