﻿//
// Created by HUTAO on 2017/6/26.
//

#ifndef YYPROTO_MUTEX_H
#define YYPROTO_MUTEX_H

#include "commondefine.h"

NAMESPACE_BASEMOD_BEGIN
	//actually it's a wrapper for multi-platforms
	class MutexLock
	{
	public:
		MutexLock(const wchar_t* name);
		~MutexLock();
	
	public:
		void lock();
		void unlock();
	
	private:
#ifdef _WIN32
		HANDLE m_lk;
#else
		pthread_mutex_t m_lk;
#endif
	};
	
	class AdaptLock
	{
	public:
		AdaptLock();
		~AdaptLock();
	
	public:
		void lock();
		void unlock();
	
	private:
		MutexLock*  m_pLock;
	};
	
	class AutoLock
	{
	public:
		AutoLock(MutexLock* plock);
		~AutoLock();
	
	private:
		MutexLock*  m_lk;
	};

NAMESPACE_BASEMOD_END
#endif //YYPROTO_MUTEX_H
