package com.yy.platform.baseservice.statis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RsaCipher {

    private static final String RSA_PADDING = "RSA/ECB/PKCS1Padding";
//    private static final String RSA_PADDING = "RSA";

//    private PrivateKey privateKey;

    private PublicKey publicKey;
    //因是128位的key，故在这里写死
    private int publicMflen = 16;
    //分5位字节加密
    private int publicMtail = 5;

    /**
     * PEM 格式
     *
     * @param in
     * @throws IOException
     */
    public void loadPublicKey(InputStream in) throws Exception {
        byte[] keyBytes = readAllBytes(in);
        try {
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));

            this.publicKey = publicKey;
        } catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public String encryptTlogAesKey(byte[] keyContent) throws Exception {
        if (keyContent == null || keyContent.length == 0) {
            return null;
        }
        byte[] enBytes = this.encrypt(keyContent);
        StringBuilder builder = new StringBuilder(8 + enBytes.length * 2);
        builder.append(TextUtils.length2DecimalChar(keyContent.length));
        builder.append(TextUtils.bytes2hex(enBytes));
        return builder.toString();
    }

    public byte[] encrypt(byte[] content) throws Exception {
        int certifSize = content.length;
        int pad = certifSize % this.publicMtail;
        int total = pad != 0 ? certifSize + publicMtail - pad : certifSize;
        int bufferEnd = content.length;

        if (pad != 0) {
            byte[] newContent = new byte[total];
            System.arraycopy(content, 0, newContent, 0, content.length);
            content = newContent;
        }

        int outlen = total / publicMtail * this.publicMflen;
        byte[] outByte = new byte[outlen];

        int contentStep = 0;
        int outStep = 0;
        int icount = 0;

        try {
            while (contentStep < content.length) {
                icount = bufferEnd - contentStep;
                if (icount >= publicMtail) {
                    byte[] tempEncrypt = encrypt(content, contentStep, publicMtail, publicKey);
                    System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
                    contentStep += publicMtail;
                    outStep += publicMflen;
                } else {
                    break;
                }
            }
            if (icount > 0 && contentStep < content.length) {
                content[contentStep + publicMtail - 1] = (byte) (publicMtail - icount);
                byte[] tempEncrypt = encrypt(content, contentStep, publicMtail, publicKey);
                System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
            }

        } catch (Throwable e) {
            throw new Exception(e);
        }
        return outByte;
    }

    private final ThreadLocal<Cipher> rsaCipher = new ThreadLocal<Cipher>() {
        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RSA_PADDING);
            } catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            } catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private byte[] encrypt(byte[] input, int inputOffset, int inputLen, Key key)
            throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        Cipher cipher = rsaCipher.get();
        cipher.init(Cipher.ENCRYPT_MODE, key);
        byte[] en = cipher.doFinal(input, inputOffset, inputLen);
        return en;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        List<Byte> orig = new ArrayList<Byte>(512);
        DataInputStream dis = new DataInputStream(in);
        int b = -1;
        while ((b = dis.read()) != -1) {
            orig.add((byte) b);
        }
        byte[] keyBytes = new byte[orig.size()];
        for (int i = 0; i < keyBytes.length; i++) {
            keyBytes[i] = orig.get(i);
        }
        return keyBytes;
    }
}
