package com.yy.platform.loginlite.validation;

import java.util.HashMap;
import java.util.Map;

public class ValidationUtils {

    public static class ErrorCode {
        public static final int NORMAL = 1000;
        public static final int NULL = NORMAL + 1;
        public static final int EMPTY = NORMAL + 2;

        public static final int PHONE_STEP = 100;
        public static final int PHONE_NOT_NUMBER = NORMAL + PHONE_STEP;
        public static final int PHONE_START_WITHOUT_00 = NORMAL + PHONE_STEP + 1;
        public static final int PHONE_REGION_CODE_ERROR = NORMAL + PHONE_STEP + 2;
    }

    private static Map<ValidateType, IValidator> validators = new HashMap<>();
    private static Null nullCheck = new Null();

    static {
        register(new PhoneNumberValidator());
    }

    public static void register(IValidator iValidator) {
        if (iValidator == null) {
            return;
        }

        ValidateType type = iValidator.handleType();
        if (type == null) {
            return;
        }
        if (validators.containsKey(type)) {
            return;
        }
        validators.put(type, iValidator);
    }

    public static void unRegister(IValidator validator) {
        if (validator == null) {
            return;
        }

        ValidateType type = validator.handleType();
        if (type == null) {
            return;
        }
        if (!validators.containsKey(type)) {
            return;
        }
        validators.remove(validator);
    }

    public static ValidateResult validate(ValidateType type, String value) {
        ValidateResult result = nullCheck.validate(value);
        if (type == null) {
            return result;
        }
        if (result.success) {
            IValidator iValidator = validators.get(type);
            if (iValidator != null) {
                ValidateResult tmp = iValidator.validate(value);
                return tmp == null ? result : tmp;
            }
        }
        return result;
    }

}
