package com.yy.platform.loginlite.validation;

import com.yy.platform.loginlite.utils.CountryHelper;

class PhoneNumberValidator implements IValidator {

    private final static String regix = "^[0-9]+$";

    @Override
    public ValidateResult validate(String value) {
        ValidateResult result = new ValidateResult();
        result.success = true;
        if (!value.matches(regix)) {
            result.success = false;
            result.desc = "phone number must be all number";
            result.code = ValidationUtils.ErrorCode.PHONE_NOT_NUMBER;
            return result;
        }
        if (!value.startsWith("00")) {
            result.success = false;
            result.desc = "phone number must be start with 00";
            result.code = ValidationUtils.ErrorCode.PHONE_START_WITHOUT_00;
            return result;
        }
        checkRegionCode(result, value);
        return result;
    }

    @Override
    public ValidateType handleType() {
        return ValidateType.PHONENUMBER;
    }

    private void checkRegionCode(ValidateResult result, String value) {
        String regionCode = CountryHelper.getCurrentRegionCode();
        if (regionCode != null && regionCode.length() > 0) {
            int length = regionCode.length();
            int valueLength = value.length();
            if (length > valueLength - 2) {
                return;
            }
            String code = value.substring(2, 2 + length);
            if (!regionCode.equals(code)) {
                result.success = false;
                result.code = ValidationUtils.ErrorCode.PHONE_REGION_CODE_ERROR;
            }
        }
    }
}

