package com.yy.platform.loginlite.validation;

class Null implements IValidator {

    @Override
    public ValidateResult validate(String value) {
        ValidateResult result = new ValidateResult();
        if (value == null) {
            result.success = false;
            result.desc = "null";
            result.code = ValidationUtils.ErrorCode.NULL;
            return result;
        }

        if (value.length() == 0) {
            result.success = false;
            result.desc = "empty";
            result.code = ValidationUtils.ErrorCode.EMPTY;
            return result;
        }
        result.success = true;
        return result;
    }

    @Override
    public ValidateType handleType() {
        return null;
    }
}
