package com.yy.platform.loginlite.utils;

import android.content.Context;
import android.os.Build;
import java.util.Locale;

public class LocaleUtils {

    /**
     * 获取当前手机国家码。
     *
     * @return 返回当前系统国家码。
     */
    public static String getSystemCountry() {
        String country = Locale.getDefault().getCountry();
        return country == null ? "" : country;
    }

    /**
     * 获取当前手机系统语言。
     *
     * @return 返回当前系统语言。
     */
    public static String getSystemLanguage() {
        String lang = Locale.getDefault().getLanguage();
        return lang == null ? "" : lang;
    }

    public static String getSystemLanguage2(Context context) {
        return getLocale(context).getLanguage();
    }

    private static Locale getLocale(Context context) {
        Locale locale;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            locale = context.getResources().getConfiguration().getLocales().get(0);
        } else {
            locale = context.getResources().getConfiguration().locale;
        }
        return locale;
    }

    public static String getSystemCountry2(Context context) {
        return getLocale(context).getCountry();
    }
}
