package com.yy.platform.loginlite.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;

import com.yy.platform.loginlite.IP;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class IpUtils {
    public static IP getIPAddress(Context context) {
        IP ip = new IP();
        NetworkInfo info = ((ConnectivityManager) context
                .getSystemService(Context.CONNECTIVITY_SERVICE)).getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == ConnectivityManager.TYPE_MOBILE) {    // 当前使用2G/3G/4G网络
                try {
                    Enumeration<NetworkInterface> en;
                    for (en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                        NetworkInterface intf = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr;
                        for (enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (!inetAddress.isLoopbackAddress()) {
                                if (inetAddress instanceof Inet4Address) {
                                    ip.ip = inetAddress.getHostAddress();
                                    ip.type = IP.TYPE_MOBILE;
                                } else if (inetAddress instanceof Inet6Address) {
                                    ip.ip = inetAddress.getHostAddress();
                                    ip.type = IP.TYPE_MOBILE;
                                    ip.isIPv6 = true;
                                }
                            }
                        }
                    }
                } catch (SocketException e) {
                    e.printStackTrace();
                    ip.type = IP.ANDROIDSDKERROR;
                    ip.errorMsg = e.getMessage();
                }
            } else if (info.getType() == ConnectivityManager.TYPE_WIFI) {    // 当前使用无线网络
                WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                ip.type = IP.TYPE_WIFI;
                ip.originalIp = wifiInfo.getIpAddress();
                String ipAddress = intIP2StringIP(wifiInfo.getIpAddress());    // 得到IPV4地址
                ip.ip = ipAddress;
            }
        } else {
            ip.type = IP.DISCONNECTION;
        }
        return ip;
    }

    /**
     * 将得到的int类型的IP转换为String类型
     *
     * @param ip
     * @return
     */
    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." +
                ((ip >> 8) & 0xFF) + "." +
                ((ip >> 16) & 0xFF) + "." +
                (ip >> 24 & 0xFF);
    }
}