package com.yy.platform.loginlite.utils;

import android.text.TextUtils;

import com.yy.platform.loginlite.report.MetricsReport;
import com.yy.platform.loginlite.report.ReportData;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * 概述：国家得力助手
 *
 * @author weitianpeng@yy.com
 * @version 1.0
 * @time 2016年4月13日 下午7:36:25
 */
public class CountryHelper {
    /**
     * 分隔符
     */
    private static final String SEPERATE = "--";

    private static List<CountryInfo> mCountryList = new ArrayList<>();

    private static final String country = "Angola--AO--244\n" +
            "Afghanistan--AF--93\n" +
            "Albania--AL--355\n" +
            "Algeria--DZ--213\n" +
            "American Samoa--AS--684\n" +
            "Andorra--AD--376\n" +
            "Anguilla--AI--1264\n" +
            "Antigua and Barbuda--AG--1268\n" +
            "Argentina--AR--54\n" +
            "Armenia--AM--374\n" +
            "Ascension--SH--247\n" +
            "Australia--AU--61\n" +
            "Austria--AT--43\n" +
            "Azerbaijan--AZ--994\n" +
            "Bahamas--BS--1242\n" +
            "Bahrain--BH--973\n" +
            "Bangladesh--BD--880\n" +
            "Barbados--BB--1246\n" +
            "Belarus--BY--375\n" +
            "Belgium--BE--32\n" +
            "Belize--BZ--501\n" +
            "Benin--BJ--229\n" +
            "Bermuda--BM--1441\n" +
            "Bolivia--BO--591\n" +
            "Botswana--BW--267\n" +
            "Brazil--BR--55\n" +
            "Brunei--BN--673\n" +
            "Bulgaria--BG--359\n" +
            "Burkina-faso--BF--226\n" +
            "Burma--MM--95\n" +
            "Burundi--BI--257\n" +
            "Cameroon--CM--237\n" +
            "Canada--CA--1\n" +
            "Cayman Islands--KY--1345\n" +
            "Central African Republic--CF--236\n" +
            "Chad--TD--235\n" +
            "Chile--CL--56\n" +
            "China Mainland--CN--86\n" +
            "Colombia--CO--57\n" +
            "Congo--CG--242\n" +
            "Cook Islands--CK--682\n" +
            "Costa Rica--CR--506\n" +
            "Cuba--CU--53\n" +
            "Cyprus--CY--357\n" +
            "Czech Republic--CZ--420\n" +
            "Denmark--DK--45\n" +
            "Djibouti--DJ--253\n" +
            "Dominica Republic--DO--1890\n" +
            "Ecuador--EC--593\n" +
            "Egypt--EG--20\n" +
            "EI Salvador--SV--503\n" +
            "Estonia--EE--372\n" +
            "Ethiopia--ET--251\n" +
            "Fiji--FJ--679\n" +
            "Finland--FI--358\n" +
            "France--FR--33\n" +
            "French Guiana--GF--594\n" +
            "French Polynesia--PF--689\n" +
            "Gabon--GA--241\n" +
            "Gambia--GM--220\n" +
            "Georgia--GE--995\n" +
            "Germany--DE--49\n" +
            "Ghana--GH--233\n" +
            "Gibraltar--GI--350\n" +
            "Greece--GR--30\n" +
            "Grenada--GD--1809\n" +
            "Guam--GU--1671\n" +
            "Guatemala--GT--502\n" +
            "Guinea--GN--224\n" +
            "Guyana--GY--592\n" +
            "Haiti--HT--509\n" +
            "Honduras--HN--504\n" +
            "Hong Kong-China--HK--852\n" +
            "Hungary--HU--36\n" +
            "Iceland--IS--354\n" +
            "India--IN--91\n" +
            "Indonesia--ID--62\n" +
            "Iran--IR--98\n" +
            "Iraq--IQ--964\n" +
            "Ireland--IE--353\n" +
            "Israel--IL--972\n" +
            "Italy--IT--39\n" +
            "Ivory Coast--CI--225\n" +
            "Jamaica--JM--1876\n" +
            "Japan--JP--81\n" +
            "Jordan--JO--962\n" +
            "Kampuchea (Cambodia )--KH--855\n" +
            "Kazakstan--KZ--327\n" +
            "Kenya--KE--254\n" +
            "Korea--KR--82\n" +
            "Kuwait--KW--965\n" +
            "Kyrgyzstan--KG--331\n" +
            "Laos--LA--856\n" +
            "Latvia--LV--371\n" +
            "Lebanon--LB--961\n" +
            "Lesotho--LS--266\n" +
            "Liberia--LR--231\n" +
            "Libya--LY--218\n" +
            "Liechtenstein--LI--423\n" +
            "Lithuania--LT--370\n" +
            "Luxembourg--LU--352\n" +
            "Macao-China--MO--853\n" +
            "Madagascar--MG--261\n" +
            "Malawi--MW--265\n" +
            "Malaysia--MY--60\n" +
            "Maldives--MV--960\n" +
            "Mali--ML--223\n" +
            "Malta--MT--356\n" +
            "Martinique--MQ--596\n" +
            "Mauritius--MU--230\n" +
            "Mexico--MX--52\n" +
            "Moldova, Republic of--MD--373\n" +
            "Monaco--MC--377\n" +
            "Mongolia--MN--976\n" +
            "Montserrat Is--MS--1664\n" +
            "Morocco--MA--212\n" +
            "Mozambique--MZ--258\n" +
            "Namibia--NA--264\n" +
            "Nauru--NR--674\n" +
            "Nepal--NP--977\n" +
            "Netherlands Antilles--AN--599\n" +
            "Netherlands--NL--31\n" +
            "New Zealand--NZ--64\n" +
            "Nicaragua--NI--505\n" +
            "Niger--NE--227\n" +
            "Nigeria--NG--234\n" +
            "North Korea--KP--850\n" +
            "Northern Mariana Islands--MP--1670\n" +
            "Norway--NO--47\n" +
            "Oman--OM--968\n" +
            "Pakistan--PK--92\n" +
            "Panama--PA--507\n" +
            "Papua New Cuinea--PG--675\n" +
            "Paraguay--PY--595\n" +
            "Peru--PE--51\n" +
            "Philippines--PH--63\n" +
            "Poland--PL--48\n" +
            "Portugal--PT--351\n" +
            "Puerto Rico--PR--1787\n" +
            "Qatar--QA--974\n" +
            "Reunion Island--YT--262\n" +
            "Romania--RO--40\n" +
            "Russia--RU--7\n" +
            "Saint Lueia--LC--1758\n" +
            "Saint Vincent--VC--1784\n" +
            "Samoa Western--WS--685\n" +
            "San Marino--SM--378\n" +
            "Sao Tome and Principe--ST--239\n" +
            "Saudi Arabia--SA--966\n" +
            "Senegal--SN--221\n" +
            "Seychelles--SC--248\n" +
            "Sierra Leone--SL--232\n" +
            "Singapore--SG--65\n" +
            "Slovakia--SK--421\n" +
            "Slovenia--SI--386\n" +
            "Solomon Is--SB--677\n" +
            "Somali--SO--252\n" +
            "South Africa--ZA--27\n" +
            "Spain--ES--34\n" +
            "Sri Lanka--LK--94\n" +
            "St.Lucia--LC--1758\n" +
            "St.Vincent--VC--1784\n" +
            "Sudan--SD--249\n" +
            "Suriname--SR--597\n" +
            "Swaziland--SZ--268\n" +
            "Sweden--SE--46\n" +
            "Switzerland--CH--41\n" +
            "Syria--SY--963\n" +
            "Taiwan-China--TW--886\n" +
            "Tajikstan--TJ--992\n" +
            "Tanzania--TZ--255\n" +
            "Timor-Leste--TL--670\n" +
            "Thailand--TH--66\n" +
            "Togo--TG--228\n" +
            "Tonga--TO--676\n" +
            "Trinidad and Tobago--TT--1809\n" +
            "Tunisia--TN--216\n" +
            "Turkey--TR--90\n" +
            "Turkmenistan--TM--993\n" +
            "Uganda--UG--256\n" +
            "Ukraine--UA--380\n" +
            "United Arab Emirates--AE--971\n" +
            "United Kiongdom--GB--44\n" +
            "United States of America--US--1\n" +
            "Uruguay--UY--598\n" +
            "Uzbekistan--UZ--233\n" +
            "Venezuela--VE--58\n" +
            "Vietnam--VN--84\n" +
            "Yemen--YE--967\n" +
            "Yugoslavia--YU--381\n" +
            "Zimbabwe--ZW--263\n" +
            "Zaire--ZR--243\n" +
            "Zambia--ZM--260";

    static {
        load();
    }

    private static boolean load() {
        try {
            String[] values = country.split("\n");
            if (values.length > 0) {
                List<CountryInfo> results = new ArrayList<>();
                for (String value : values) {
                    CountryInfo info = CountryInfo.parseString(value);
                    if (info != null) {
                        results.add(info);
                    }
                }
                mCountryList = results;
            }
            return true;
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /**
     * 根据当前系统设置的区域，获取当前系统所在国家的名称
     *
     * @return
     */
    public static String getCurrentCountryName() {
        String countryCode = LocaleUtils.getSystemCountry();
        if (TextUtils.isEmpty(countryCode)) {
            return "";
        }
        if (mCountryList == null || mCountryList.size() == 0) {
            return "";
        }

        for (CountryInfo info : mCountryList) {
            if (info != null && info.code != null && info.code.equalsIgnoreCase(countryCode)) {
                return info.englishName == null ? "" : info.englishName;
            }
        }
        return "";
    }

    /**
     * 根据当前系统设置的区域，获取当地拨打电话的国际区号
     *
     * @return
     */
    public static String getCurrentRegionCode() {
        String countryCode = LocaleUtils.getSystemCountry();
        if (TextUtils.isEmpty(countryCode)) {
            return "";
        }
        if (mCountryList == null || mCountryList.size() == 0) {
            return "";
        }

        for (CountryInfo info : mCountryList) {
            if (info != null && info.code != null && info.code.equalsIgnoreCase(countryCode)) {
                String countName = "getCurrentRegionCode";
                String functionName = "getCurrentRegionCode";
                int code = ReportData.SUCCESS;
                MetricsReport.reportCount(countName, functionName, functionName, code);
                return info.numberCode;
            }
        }
        return "";
    }

    /**
     * 根据区域值获取当地拨打电话的国际区号
     *
     * @return
     */
    public static String getRegionCodeByCountryCode(String countryCode) {
        if (TextUtils.isEmpty(countryCode)) {
            return "";
        }
        if (mCountryList == null || mCountryList.size() == 0) {
            return "";
        }

        for (CountryInfo info : mCountryList) {
            if (info != null && info.code != null && info.code.equalsIgnoreCase(countryCode)) {
                return info.numberCode;
            }
        }
        return "";
    }

    /**
     * 概述：国家区号信息
     *
     * @author weitianpeng@yy.com
     * @version 1.0
     * @time 2016年4月7日 上午11:27:11
     */
    private static class CountryInfo implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 国家名称
         */
        public String englishName = ""; // CHINA
        /**
         * 国家Code
         */
        public String code = ""; // CN
        public String numberCode = ""; // +86

        /**
         * 按格式“名称\t英文名\t拼音\t拼音首字母\t区号” 构建一个对象
         *
         * @param content
         * @return 失败则返回空
         */
        public static CountryInfo parseString(String content) {
            if (content == null || content.length() <= 0) {
                return null;
            }
            String[] fileds = content.split(SEPERATE);
            if (fileds == null || fileds.length <= 2) {
                return null;
            }
            CountryInfo info = new CountryInfo();
            //这里是正常的国家信息
            info.englishName = fileds[0];
            info.code = fileds[1];
            info.numberCode = fileds[2];
            return info;
        }
    }
}
