package com.yy.platform.loginlite.report;

import com.yy.platform.loginlite.validation.ValidateResult;
import com.yy.platform.loginlite.validation.ValidateType;
import com.yy.platform.loginlite.validation.ValidationUtils;

public class PhoneReport {

    /**
     * @param interName 接口名称
     * @param phone     电话号码
     */
    public static void report(String interName, String phone) {
        ValidateResult result = ValidationUtils.validate(ValidateType.PHONENUMBER, phone);
        if (!result.success) {
            //未通过验证
            String countName = "check_phone_number";
            MetricsReport.reportCount(countName, interName, result.desc, result.code);
        }
    }
}
