package com.yy.platform.loginlite;

public enum ThirdLoginError {
    ParamMissing("-1", "缺少参数"),
    PermissionDenied("-2", "没有接入权限"),
    ThirdAuthFail("-3", "第三方认证失败"),
    ParamInvalid("-4", "参数非法"),
    UserBan("-14", "账号封禁"),
    VerifyMobile("-16", "需要绑定/验证手机"),
    NotAllowLogin("-17", "不允许登录"),
    SystemError("-999", "系统错误");

    private String code;
    private String message;

    ThirdLoginError(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
