package com.yy.platform.loginlite;

/**
 * Created by HUTAO on 2018/4/4.
 */

public class ResCodeDef {
    public final static class Type {
        /**
         * Service通道SDK定义的错误码
         */
        public static final int SERVICE_SDK_CODE = 0;

        /**
         * Service通道服务端定义的错误码
         */
        public static final int SERVICE_SRV_CODE = 1;
        /**
         * 账号SDK定义的错误码
         * 取值如下{@link AuthSdkErrorCode}
         */
        public static final int AUTH_SDK_CODE = 3;

        /**
         * 账号服务端定义的错误码
         * 取值如下{@link AuthErrorCode}
         */
        public static final int AUTH_SRV_CODE = 4;

        /**
         * 账号服务端定义的错误码
         * 取值如下{@link RegistrErrorCode}
         */
        public static final int AUTH_SRV_REGISTER_CODE = 5;

    }

    public final static class AuthSdkErrorCode {
        /**
         * 响应包无效，无法解析
         */
        public static final int InvalidProtocol = -10;

        /**
         * 无登录凭证
         */
        public static final int NoCredit = 1;

        /**
         * 网络连接不上
         */
        public static final int ConnectErr = 2;

        public final static String desc(int code) {
            if (code == InvalidProtocol) {
                return "无法解析响应包数据";
            } else if (code == NoCredit) {
                return "无登录凭证";
            } else if (code == ConnectErr) {
                return "网络连接不上";
            }
            return "UNKNOW-未知AuthLite错误(" + code + ")";
        }
    }

    public final static class AuthErrorCode {
        public final static int SUCCESS = 0;            //登录成功
        public final static int NEXT_VER = 1;            //二次验证
        public final static int PWD_ERR = 2;            //密码错误
        public final static int USER_NOT = 3;                //帐号不存在
        public final static int USER_LOCK = 4;                //帐号锁定（用户自己锁定）
        public final static int REJECT = 5;                //安全风险临时拒绝登录
        public final static int BAND = 6;                //封禁
        public final static int PARAM_ERR = 7;              //参数错误

        public final static int SMS_LIMIT = 10;            //下发短信验证码超过最大次数
        public final static int SMSCODE_ERR = 11;            //短信验证码错误
        public final static int SMSCODE_EXPIRE = 12;            //短信验证码过期
        public final static int VCODE_ERR = 13;            //二次验证码错误
        public final static int VCODE_EXPIRE = 14;            //二次验证码已过期

        public final static int CREDIT_ERR = 20;          //凭证错误或无效
        public final static int CREDIT_EXPIRE = 21;            //凭证过期
        public final static int DEVICE_ERR = 22;            //凭证设备不匹配
        public final static int APPID_ERR = 23;            //凭证appid不匹配
        public final static int GEN_CREDIT_ERR = 24;            //产凭证错误

        public final static int SESS_EXPIRE = 31;            //sessoindata已失效
        public final static int SESS_DECODE = 32;            //sessoindata解码失败
        public final static int SESS_VER_ERR = 33;            //sessoindata校验失败
        public final static int SESS_NULL = 34;            //sessoindata为空

        public final static int QRCODE_NO_CONFIRM = 60;   //QRCODE已扫描，未确认，客户端提示扫码端确认，稍后重试登录
        public final static int QRCODE_NO_SCAN = 61;   //QRCODE未扫描，客户端继续展示二维码，稍后重试登录
        public final static int QRCODE_EXPIRE = 62;         //QRCODE过期，客户端终止重试
        public final static int QRCODE_NOT_EXIST = 63;   //QRCODE不存在，客户端终止重试
        public final static int QRCODE_CANCLE = 64;   //QRCODE已被用户取消，客户端终止重试
        public final static int QRCODE_USER = 65;   //QRCODE用户取消，用户错误

        public final static int CLIENT_RETRY = 99;            //客户端重试，db或服务错误，需要客户端自动重试
        public final static int SYS_BUSY = 100;            //服务器限流，客户端不要重试，慎防雪崩

        public final static int ParamMissing = -1;        //缺少参数
        public final static int PermissionDenied = -2;    //没有接入权限
        public final static int ThirdAuthFail = -3;       //第三方认证失败
        public final static int ParamInvalid = -4;        //参数非法
        public final static int OperationIllegal = -5;    //非法操作
        public final static int AuthFail = -6;            //认证失败
        public final static int FreqLimit = -7;           //频率限制
        public final static int verifyFail = -8;          //验证失败
        public final static int userNotExist = -9;        //账号不存在
        public final static int RegFail = -10;            //注册失败
        public final static int RegWriteCookieFail = -11;  //注册写cookie失败
        public final static int IPLimit = -12;            //IP限制
        public final static int TimeExpire = -13;         //时间过期
        public final static int UserBan = -14;            //账号封禁
        public final static int BindExists = -15;         //帐号已经存在绑定信息
        public final static int VerifyMobile = -16;       //需要绑定/验证手机
        public final static int NotAllowLogin = -17;      //不允许登录

    }

    public final static class RegistrErrorCode {
        /**
         * <code>CSUCCESS = 0;</code>
         */
        public static final int CSUCCESS_VALUE = 0;
        /**
         * <code>CERR_PARAM = 1;</code>
         */
        public static final int CERR_PARAM_VALUE = 1;
        /**
         * <code>CERR_SYS = 2;</code>
         */
        public static final int CERR_SYS_VALUE = 2;
        /**
         * <pre>
         * 手机号已存在
         * </pre>
         * <p>
         * <code>CERR_MOB_EXITS = 3;</code>
         */
        public static final int CERR_MOB_EXITS_VALUE = 3;
        /**
         * <pre>
         * 用户不存在，例如改密操作
         * </pre>
         * <p>
         * <code>CERR_NO_USER = 4;</code>
         */
        public static final int CERR_NO_USER_VALUE = 4;
        /**
         * <pre>
         * 短信验证码错误
         * </pre>
         * <p>
         * <code>CERR_SMSCODE_WRONG = 51;</code>
         */
        public static final int CERR_SMSCODE_WRONG_VALUE = 51;
        /**
         * <pre>
         * 短信验证码过期
         * </pre>
         * <p>
         * <code>CERR_SMSCODE_EXPIRE = 52;</code>
         */
        public static final int CERR_SMSCODE_EXPIRE_VALUE = 52;
        /**
         * <pre>
         * 客户端重试，db或服务错误，需要客户端自动重试
         * </pre>
         * <p>
         * <code>CERR_CLIENT_RETRY = 99;</code>
         */
        public static final int CERR_CLIENT_RETRY_VALUE = 99;
        /**
         * <pre>
         * 服务器限流，客户端不要重试，慎防雪崩
         * </pre>
         * <p>
         * <code>CERR_SYS_BUSY = 100;</code>
         */
        public static final int CERR_SYS_BUSY_VALUE = 100;
    }
}
