package com.yy.platform.loginlite;

import com.yy.platform.base.ChannelType;
import com.yy.platform.base.IYYLoginLiteChannel;
import com.yy.platform.base.YYLoginLiteManager;
import com.yy.platform.base.error.HttpError;
import com.yy.platform.base.error.ServiceError;

public class ReportUtils {

    public static void fillData(
            HiidoReport.CReportResponse response,
            ChannelType type,
            ServiceError serviceError,
            HttpError httpError
    ) {
        if (type == ChannelType.SERVICE) {
            response.mErrCode = serviceError.mErrCode;
            response.mErrDesc = serviceError.mErrDesc;
            if (serviceError.mErrType == ServiceError.SDK_ERROR) {
                response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
            } else {
                response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
            }
            IYYLoginLiteChannel channel = YYLoginLiteManager.getInstance().
                    getYYLoginChannelByType(ChannelType.SERVICE);
            response.mNetOptimize = channel.getNetOptimizeSwitch();
            response.mTraceId = serviceError.traceId;
        } else {
            response.mErrCode = httpError.mErrCode;
            response.mErrDesc = httpError.mErrDesc;
            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
            response.mTraceId = httpError.traceId;
        }
    }
}
