package com.yy.platform.loginlite;

/**
 * Created by chenkaicai on 2019/11/28.
 */

import android.content.Context;
import android.text.TextUtils;

import com.yy.platform.base.Callback;
import com.yy.platform.base.ChannelType;
import com.yy.platform.base.IYYLoginLiteChannel;
import com.yy.platform.base.Response;
import com.yy.platform.base.YYLoginLiteManager;
import com.yy.platform.base.YYLoginStatus;
import com.yy.platform.base.error.HttpError;
import com.yy.platform.base.error.ServiceError;
import com.yy.platform.base.request.HttpRequest;
import com.yy.platform.base.request.Request;
import com.yy.platform.base.request.Retry;
import com.yy.platform.base.request.ServiceRequest;
import com.yy.platform.loginlite.proto.ClientRegisterErr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yy.platform.loginlite.proto.RegisterByCodeReq;
import com.yy.platform.loginlite.proto.RegisterByCodeRsp;
import com.yy.platform.loginlite.utils.UserInfoUtils;

public class RegisterByVerifyCodeRPC {
    public RegisterByVerifyCodeRPC(
            Context appContext,
            String account,
            String verifyCode,
            String password,
            String dynCode,
            IAuthInfoCallBack callback
    ) {
        this.account = account;
        this.verifyCode = verifyCode;
        this.password = password;
        this.dynCode = dynCode;
        this.callback = callback;
        this.appContext = appContext;
    }

    public int run() {
        if (TextUtils.isEmpty(account)) {
            LoginLog.i("RegisterByVerifyCodeRPC fail, email param null");
            return -1;
        }

        LoginLog.i("RegisterByVerifyCodeRPC run, account:" + account);

        RegisterByCodeReq registerReq = RegisterByCodeReq.newBuilder()
                .setContext("RegisterByVerifyCodeRPC")
                .setUser(account)
                .setPrheader(AuthInfo.getHeader())
                .setCode(verifyCode)
                .setSha1Pwd(password == null ? "" : YYLoginliteUtils.getPasswdSha1(password))
                .setDynCode(dynCode == null ? "" : dynCode)
                .build();


        Map<String, String> routes = new HashMap<>();
        String regionSet = AuthInfo.getRegionSet();
        if (regionSet != null) {
            routes.put(AuthInfo.getRegionSetKey(), regionSet);
        }

        Request request = new Request();

        Retry retry = new Retry();
        retry.setCount(5);
        retry.setTime(10 * 1000);
        request.setRetry(retry);

        ServiceRequest sr = new ServiceRequest();
        sr.setRouteArgs(routes);
        sr.setFuncName("RegisterByCode");
        sr.setServerName("UdbApp.RegisterServer.RegisterObj");
        request.setData(registerReq.toByteArray());
        request.setServiceRequest(sr);

        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setTimeout(10 * 1000);
        httpRequest.setMethod(HttpRequest.Method.POST);
        httpRequest.setQuery("UdbApp.RegisterServer.RegisterObj/RegisterByCode");
        Map<String, String> headers = new HashMap<>();
        headers.put("Context", "RegisterByCode");
        headers.put("AppId", AuthInfo.getAppId());
        headers.put("Uid", account);
        headers.put("ServiceName", "UdbApp.RegisterServer.RegisterObj");
        headers.put("FunctionName", "RegisterByCode");
        headers.put("InstId", "RegisterByCode");
        headers.put("ServerId", "RegisterByCode");
        httpRequest.setHeaders(headers);
        request.setHttpRequest(httpRequest);

        final long bTime = System.currentTimeMillis();

        int reqId = YYLoginLiteManager.getInstance().send(request, new Callback() {
            @Override
            public void onSuccess(Response resp, List<YYLoginStatus> list) {
                int reqId = resp.getRequestId();
                try {
                    long eTime = System.currentTimeMillis();
                    long rtt = eTime - bTime;

                    HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
                    response.mRtt = rtt;
                    response.mEventType = "RegisterByVerifyCodeRPC";
                    response.mUserInfo = account;

                    RegisterByCodeRsp res;
                    res = RegisterByCodeRsp.newBuilder().mergeFrom(resp.getResponseData()).build();

                    if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
                        LoginLog.i("RegisterByVerifyCodeRPC success, account:" + account);

                        response.mErrCode = 0;
                        response.mErrType = 0;
                        response.mSucceed = 0;

                        YYInfo info = new YYInfo();
                        UserInfoUtils.unPack(res.getUserData(), info);
                        //单位s
                        info.mTS = res.getServerTime();
                        info.mIsNewUser = false;
                        info.mUrl = res.getUrl();
                        info.extjsstr = res.getExt();

                        AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000);

                        callback.onSuccess(reqId, info);
                    } else {
                        response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
                        response.mErrCode = res.getErrcodeValue();
                        response.mSucceed = 2;
                        response.mErrDesc = res.getDescription();

                        LoginLog.i("RegisterByVerifyCodeRPC failed, account:" + account +
                                ", errType:" + response.mErrType + ", resCode:" + response.mErrCode);
                        callback.onFail(reqId, ResCodeDef.Type.AUTH_SRV_CODE, response.mErrCode,
                                res.getDescription());
                    }
                    if (resp.getChannelType() == ChannelType.SERVICE) {
                        IYYLoginLiteChannel channel = YYLoginLiteManager.getInstance().
                                getYYLoginChannelByType(ChannelType.SERVICE);
                        response.mNetOptimize = channel.getNetOptimizeSwitch();
                    }
                    response.mTraceId = resp.getTraceId();

                    HiidoReport.getInstance().report2Hido(response);
                    HiidoReport.getInstance().report2Metric(response);

                } catch (Exception e) {
                    LoginLog.i("RegisterByVerifyCodeRPC failed, account:" + account +
                            ", reqId=" + reqId + ",exceptionDesc:" + e.getMessage());
                    callback.onFail(reqId, ResCodeDef.Type.AUTH_SDK_CODE,
                            ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
                            e.getMessage());
                }
            }

            @Override
            public void onFail(ChannelType type, ServiceError sError, HttpError hError,
                               List<YYLoginStatus> list) {
                long eTime = System.currentTimeMillis();
                long rtt = eTime - bTime;

                HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
                response.mRtt = rtt;
                response.mEventType = "RegisterByVerifyCodeRPC";
                response.mSucceed = 2;
                response.mUserInfo = account;


                ReportUtils.fillData(response, type, sError, hError);
                CallbackUtils.fill(appContext, callback, type, sError, hError,
                        "RegisterByVerifyCodeRPC", "fail");
                HiidoReport.getInstance().report2Hido(response);
                HiidoReport.getInstance().report2Metric(response);
            }
        });
        return reqId;
    }

    private String account;
    private String verifyCode;
    private String password;
    private String dynCode;
    private IAuthInfoCallBack callback;
    private Context appContext;
}
