package com.yy.platform.loginlite;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.yy.platform.loginlite.proto.PwdLoginRsp;
import com.yy.platform.loginlite.proto.SendSmsRsp;
import com.yy.platform.loginlite.proto.SmsLoginRsp;

class NextVerifyUtils {

    public static final String NextVerify = "com.yy.platform.loginlite.NextVerify";

    public static void getSms(
            final AuthCore authCore, final Context context, final int requestId,
            final NextVerify nextVerify, final SendSmsRsp res, final String userPhoneNumber,
            final String smsType, final String smsLength, final IGetSmsCallback callback
    ) {
        if (nextVerify != null && !TextUtils.isEmpty(nextVerify.mDynVer)) {
            Event.getInstance().registerVerifyListener(new Event.IVerifyListener() {
                @Override
                public void onResponse(Event.Inform<Event.VerifyBean> bean) {
                    LoginLog.i("getSms resultCode: " + bean.code);
                    if (bean.isFail()) {
                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                res.getErrcodeValue(), res.getDescription());
                    } else {
                        String dynCode = bean.data.dynCode;
                        if (!TextUtils.isEmpty(dynCode)) {
                            authCore.getSms(userPhoneNumber, smsType, smsLength, dynCode, callback);
                        } else {
                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                    res.getErrcodeValue(), res.getDescription());
                        }
                    }
                    Event.getInstance().unRegisterVerifyListener(this);
                }
            });
//            BroadcastReceiver receiver = new BroadcastReceiver() {
//                @Override
//                public void onReceive(Context context, Intent intent) {
//                    if (!intent.getAction().equals(NextVerify)) {
//                        return;
//                    }
//                    int resultCode = intent.getIntExtra("result", -1);
//                    AuthCore.sLog.i(AuthCore.TAG, "getSms resultCode: " + resultCode);
//                    if (resultCode == 0) {
//                        String dynCode = intent.getStringExtra("dynCode");
//                        if (!TextUtils.isEmpty(dynCode)) {
//                            authCore.getSms(userPhoneNumber, smsType, smsLength, dynCode, callback);
//                        } else {
//                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                    res.getErrcodeValue(), res.getDescription());
//                        }
//                    } else {
//                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                res.getErrcodeValue(), res.getDescription());
//                    }
//                    context.unregisterReceiver(this);
//                }
//            };
//            context.registerReceiver(receiver, new IntentFilter(NextVerify));
            Intent intent = new Intent(context, DialogActivity.class);
            intent.putExtra("function", nextVerify.mDynVer);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } else {
            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    public static void smsLogin(
            final AuthCore authCore, final Context context, final int requestId,
            final SmsLoginRsp resp, final NextVerify verify, final String phone,
            final String smsCode, final ISmsLoginCallback callback
    ) {
        if (verify != null && !TextUtils.isEmpty(verify.mDynVer)) {
            Event.getInstance().registerVerifyListener(new Event.IVerifyListener() {
                @Override
                public void onResponse(Event.Inform<Event.VerifyBean> bean) {
                    LoginLog.i("smsLogin resultCode: " + bean.code);
                    if (bean.isFail()) {
                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                resp.getErrcodeValue(), resp.getDescription());
                    } else {
                        String dynCode = bean.data.dynCode;
                        if (!TextUtils.isEmpty(dynCode)) {
                            authCore.smsLogin(phone, smsCode, dynCode, callback);
                        } else {
                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                    resp.getErrcodeValue(), resp.getDescription());
                        }
                    }
                    Event.getInstance().unRegisterVerifyListener(this);
                }
            });
//            BroadcastReceiver receiver = new BroadcastReceiver() {
//                @Override
//                public void onReceive(Context context, Intent intent) {
//                    if (!intent.getAction().equals(NextVerify)) {
//                        return;
//                    }
//                    int resultCode = intent.getIntExtra("result", -1);
//                    AuthCore.sLog.i(AuthCore.TAG, "smsLogin resultCode: " + resultCode);
//                    if (resultCode == 0) {
//                        String dynCode = intent.getStringExtra("dynCode");
//                        if (!TextUtils.isEmpty(dynCode)) {
//                            authCore.smsLogin(phone, smsCode, dynCode, callback);
//                        } else {
//                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                    resp.getErrcodeValue(), resp.getDescription());
//                        }
//                    } else {
//                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                resp.getErrcodeValue(), resp.getDescription());
//                    }
//                    context.unregisterReceiver(this);
//                }
//            };
//            context.registerReceiver(receiver, new IntentFilter(NextVerify));
            Intent intent = new Intent(context, DialogActivity.class);
            intent.putExtra("function", verify.mDynVer);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } else {
            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                    resp.getErrcodeValue(), resp.getDescription());
        }
    }

    public static void passwordLogin(
            final AuthCore authCore, final Context context, final int requestId,
            final PwdLoginRsp resp, final NextVerify verify,
            final String account, final String password, final IPasswordLoginCallback callback
    ) {
        if (verify != null && !TextUtils.isEmpty(verify.mDynVer)) {
            Event.getInstance().registerVerifyListener(new Event.IVerifyListener() {
                @Override
                public void onResponse(Event.Inform<Event.VerifyBean> bean) {
                    LoginLog.i("passwordLogin resultCode: " + bean.code);
                    if (bean.isFail()) {
                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                resp.getErrcodeValue(), resp.getDescription());
                    } else {
                        String dynCode = bean.data.dynCode;
                        if (!TextUtils.isEmpty(dynCode)) {
                            authCore.passwordLogin(account, password, dynCode, callback);
                        } else {
                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                    resp.getErrcodeValue(), resp.getDescription());
                        }
                    }
                    Event.getInstance().unRegisterVerifyListener(this);
                }
            });
//            BroadcastReceiver receiver = new BroadcastReceiver() {
//                @Override
//                public void onReceive(Context context, Intent intent) {
//                    if (!intent.getAction().equals(NextVerify)) {
//                        return;
//                    }
//                    int resultCode = intent.getIntExtra("result", -1);
//                    AuthCore.sLog.i(AuthCore.TAG, "passwordLogin resultCode: " + resultCode);
//                    if (resultCode == 0) {
//                        String dynCode = intent.getStringExtra("dynCode");
//                        if (!TextUtils.isEmpty(dynCode)) {
//                            authCore.passwordLogin(account, password, dynCode, callback);
//                        } else {
//                            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                    resp.getErrcodeValue(), resp.getDescription());
//                        }
//                    } else {
//                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                resp.getErrcodeValue(), resp.getDescription());
//                    }
//                }
//            };
//            context.registerReceiver(receiver, new IntentFilter(NextVerify));
            Intent intent = new Intent(context, DialogActivity.class);
            intent.putExtra("function", verify.mDynVer);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } else {
            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                    resp.getErrcodeValue(), resp.getDescription());
        }
    }
}
