package com.yy.platform.loginlite;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkReceiver extends BroadcastReceiver {
    private int mLastNetworkStatus = -100;
    private long mLastNetworkChangedTs = 0;
    private int mNetworkChangedCount = 0;
    private int mNetworkState = -100;

    private Context mAppContext = null;

    public NetworkReceiver(Context appContext) {
        mAppContext = appContext;
    }

    public int getNetWorkType() {
        if (mLastNetworkStatus == -100) {
            checkNetwork(mAppContext);
        }
        return mLastNetworkStatus;
    }

    public int checkCurrentNetwork() {
        int currentNetworkStatus = mLastNetworkStatus;
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) mAppContext.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (connectivityManager != null) {
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetInfo != null && (activeNetInfo.getState() != null)) {
                    NetworkInfo.State state = activeNetInfo.getState();
                    mNetworkState = state.ordinal();
                    currentNetworkStatus = activeNetInfo.getType();
                    if (currentNetworkStatus != mLastNetworkStatus) {
                        AuthCore.LogWrapper
                                .i(AuthCore.TAG, "Network state type changed,previous status:" + mLastNetworkStatus
                                        + ",now status:" + currentNetworkStatus);
                    }
                    return currentNetworkStatus;
                }
            }
        } catch (Throwable ex) {
            AuthCore.LogWrapper.i(AuthCore.TAG, "Network state ex:" + ex.getMessage());
        }
        mNetworkState = -1;
        AuthCore.LogWrapper.i(AuthCore.TAG, "Network state is invalidate,last type:" + currentNetworkStatus);
        return currentNetworkStatus;
    }

    public int getNetWorkState() {
        return mNetworkState;
    }

    public int getNetworkChangedCount() {
        return mNetworkChangedCount;
    }

    public long getLastNetworkChangedTs() {
        return mLastNetworkChangedTs;
    }

    private void checkNetwork(Context context) {
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (connectivityManager != null) {
//NetworkInfo [] networkInfos = connectivityManager.getAllNetworkInfo();
//获取网络的连接情况，断网时会是一个null
                NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
                //以下是正确的判断有无网络数据链接的方法，isAvailable仅表示WIFI开关
                if (activeNetInfo != null && (activeNetInfo.getState() != null)) {
                    NetworkInfo.State state = activeNetInfo.getState();
                    mNetworkState = state.ordinal();
                    AuthCore.LogWrapper
                            .i(AuthCore.TAG, "Network value is " + activeNetInfo.getType() + ",state=" + state);
                    if (state == NetworkInfo.State.CONNECTED) {
                        if (mLastNetworkStatus == activeNetInfo.getType()) {
                            AuthCore.LogWrapper.i(AuthCore.TAG, "Network type not changed:" + mLastNetworkStatus);
                            return;
                        }
                        //判断WIFI网
                        if (activeNetInfo.getType() == ConnectivityManager.TYPE_WIFI) {
                            AuthCore.LogWrapper.i(AuthCore.TAG, "Network is TYPE_WIFI");
                            mLastNetworkStatus = ConnectivityManager.TYPE_WIFI;
                            return;
                        } else if (activeNetInfo.getType() == ConnectivityManager.TYPE_MOBILE) {
                            //判断3G网
                            AuthCore.LogWrapper.i(AuthCore.TAG, "Network is TYPE_MOBILE");
                            mLastNetworkStatus = ConnectivityManager.TYPE_MOBILE;
                            return;
                        } else {
                            AuthCore.LogWrapper.i(AuthCore.TAG, "Network is :" + activeNetInfo.getType());
                            mLastNetworkStatus = activeNetInfo.getType();
                            return;
                        }
                    }
                }
            }
        } catch (Throwable ex) {
            AuthCore.LogWrapper.i(AuthCore.TAG, "Network ex:" + ex.getMessage());
        }
        mNetworkState = -1;
        mLastNetworkStatus = -1;
        AuthCore.LogWrapper.i(AuthCore.TAG, "Network is invalidate");
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        int previousStatus = mLastNetworkStatus;
        checkNetwork(context);

        if (previousStatus != mLastNetworkStatus) {
            AuthCore.LogWrapper.i(AuthCore.TAG,
                    "Network type changed from:" + previousStatus + " to:" + mLastNetworkStatus);
            mNetworkChangedCount++;
            mLastNetworkChangedTs = System.currentTimeMillis() / 1000;
        }
    }

}
