package com.yy.platform.loginlite;

public class MonitorLoginProcess {

    private static volatile MonitorLoginProcess process;
    private ILoginProcessCallback callback;

    private MonitorLoginProcess() {

    }

    public static MonitorLoginProcess getInstance() {
        if (process == null) {
            synchronized (MonitorLoginProcess.class) {
                if (process == null) {
                    process = new MonitorLoginProcess();
                }
            }
        }
        return process;
    }

    public void registerLoginProcessCallback(ILoginProcessCallback callback) {
        if (callback == null) {
            return;
        }
        this.callback = callback;
    }

    public void unRegisterLoginProcessCallback() {
        this.callback = null;
    }

    public ILoginProcessCallback getLoginCallback() {
        return callback;
    }
}
