package com.yy.platform.loginlite;

import android.text.TextUtils;

import java.util.concurrent.ConcurrentHashMap;

public class LoginLog {

    private static ConcurrentHashMap<String, ServerLog> map = new ConcurrentHashMap<String, ServerLog>();
    private static String[] filter = {
            "smsLogin", "passwordLogin", "creditLogin", "thirdLogin"
    };

    private static String getSms = "getSms";

    private static final String sep = "==========";


    public static void printSep(String func) {
        if (TextUtils.isEmpty(func)) {
            return;
        }
        AuthCore.sLog.i(AuthCore.TAG, sep + func + sep);
    }

    public static void start(String func, String message) {
        start(AuthCore.TAG, func, message);
    }

    public static void start(String tag, String func, String message) {
        if (!canPrint(tag, func, message)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();

        String tn = Thread.currentThread().getName();
        long time = System.currentTimeMillis();

        //是否为登录事件
        boolean isLoginFunc = false;
        for (String str : filter) {
            if (func.equals(str)) {
                isLoginFunc = true;
                break;
            }
        }

        for (String key : map.keySet()) {
            if (buffer.length() > 0) {
                buffer.delete(0, buffer.length());
            }
            ServerLog log = map.get(key);
            if (log != null) {
                if (log.status == ServerLog.START) {
                    if (MonitorLoginProcess.getInstance().getLoginCallback() != null) {
                        MonitorLoginProcess.getInstance().getLoginCallback()
                                .onRepeatCall(log.func, log.startTime, log.threadName);
                    }
                    buffer.append("repeat: ").append(log.threadName).append(" ")
                            .append(log.startTime).append(" ").append(log.func);
                    AuthCore.sLog.i(tag, buffer.toString());
                } else if (log.status == ServerLog.SUCCESS) {
                    //是否是登录事件
                    boolean isPrint = false;
                    for (String str : filter) {
                        if (key.equals(str)) {
                            isPrint = true;
                            break;
                        }
                    }
                    if (isPrint && isLoginFunc) {
                        if (MonitorLoginProcess.getInstance().getLoginCallback() != null) {
                            MonitorLoginProcess.getInstance().getLoginCallback()
                                    .onLoginAgain(log.func, log.startTime, log.threadName,
                                            func, time, tn);
                        }
                        buffer.append("loginagain: last ").append(log.threadName).append(" ")
                                .append(log.startTime).append(" ").append(log.func).append(", now ")
                                .append(tn).append(" ").append(time).append(" ").append(func);
                        AuthCore.sLog.i(tag, buffer.toString());
                    }
                }
            }
        }

        // 是否重复获取了短信验证码
        if (func.equals(getSms)) {
            ServerLog log = map.get(getSms);
            if (log != null && log.status == ServerLog.SUCCESS) {
                if (MonitorLoginProcess.getInstance().getLoginCallback() != null) {
                    MonitorLoginProcess.getInstance().getLoginCallback()
                            .onGetSmsFrequent(log.finishTime, log.threadName, time, tn,
                                    time - log.finishTime);
                }
                if (buffer.length() > 0) {
                    buffer.delete(0, buffer.length());
                }
                buffer.append("getSmsFrequent:  ").append(log.threadName).append(" ")
                        .append(log.finishTime).append(" ").append(time).append(" ")
                        .append(tn).append(" ").append(time - log.finishTime);
                AuthCore.sLog.i(tag, buffer.toString());
            }
        }

        ServerLog log;
        boolean exit = map.containsKey(func);
        if (exit) {
            log = map.get(func);
        } else {
            log = new ServerLog();
            map.put(func, log);
        }
        log.threadName = tn;
        log.func = func;
        log.startTime = time;
        log.status = ServerLog.START;

        AuthCore.sLog.i(tag, log.threadName + ": " + message);
    }

    public static void success(String func, String message) {
        success(AuthCore.TAG, func, message);
    }

    public static void success(String tag, String func, String message) {
        if (!canPrint(tag, func, message)) {
            return;
        }
        boolean exit = map.containsKey(func);
        String threadName = Thread.currentThread().getName();
        if (exit) {
            ServerLog log = map.get(func);
            log.threadName = threadName;
            log.func = func;
            log.finishTime = System.currentTimeMillis();
            log.status = ServerLog.SUCCESS;
        }
        AuthCore.sLog.i(tag, threadName + ": " + func + " " + message);
    }

    public static void fail(String func, String message) {
        fail(AuthCore.TAG, func, message);
    }

    public static void fail(String tag, String func, String message) {
        if (!canPrint(tag, func, message)) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        if (map.containsKey(func)) {
            ServerLog log = map.get(func);
            log.threadName = threadName;
            log.func = func;
            log.finishTime = System.currentTimeMillis();
            log.status = ServerLog.FAIL;
        }
        AuthCore.sLog.i(tag, threadName + ": " + func + " " + message);
    }

    private static boolean canPrint(String tag, String func, String message) {
        return !TextUtils.isEmpty(tag) && !TextUtils.isEmpty(message) && !TextUtils.isEmpty(func);
    }

    public static void i(String message) {
        if (TextUtils.isEmpty(message)) {
            return;
        }
        String value = Thread.currentThread().getName() + ": " + message;
        AuthCore.sLog.i(AuthCore.TAG, value);
    }

    public static void clear() {
        map.clear();
        MonitorLoginProcess.getInstance().unRegisterLoginProcessCallback();
    }

    static class ServerLog {

        public static final int START = 1;
        public static final int SUCCESS = 2;
        public static final int FAIL = 3;

        public long startTime;
        public long finishTime;
        public String func;
        public String threadName;

        public int status = 0;
        public String message;

        @Override
        public String toString() {
            return "ServerLog{" +
                    "startTime=" + startTime +
                    ", finishTime=" + finishTime +
                    ", func='" + func + '\'' +
                    ", threadName='" + threadName + '\'' +
                    ", status=" + status +
                    ", message='" + message + '\'' +
                    '}';
        }
    }
}
