package com.yy.platform.loginlite;

public interface ILoginProcessCallback {

    /**
     * 本次接口请求未收到后台响应的情况下，再次调用该接口
     *
     * @param lastFuncName 上一次调用接口的名字
     * @param lastCallTime 上一次调用接口的时间戳
     * @param lastCallTN   上一次调用接口的线程名
     */
    void onRepeatCall(String lastFuncName, long lastCallTime, String lastCallTN);

    /**
     * 重复登录，即已经登录成功了，再次尝试登录，可以是同一种登录方式，或者不同登录方式
     *
     * @param lastLoginFunc 上一次登录方式，即接口名称
     * @param lastLoginTime 上一次登录的时间戳
     * @param lastLoginTN   上一次登录的线程名
     * @param thisLoginFunc 本次登录方式，即接口名称
     * @param lastLoginTime 本次登录的时间戳
     * @param thisLoginTN   本次登录的线程名
     */
    void onLoginAgain(String lastLoginFunc, long lastLoginTime, String lastLoginTN,
                      String thisLoginFunc, long thisLoginTime, String thisLoginTN);

    /**
     * 频繁获取短信验证码
     *
     * @param lastTime 上次获取短信验证码成功的时间戳
     * @param lastTN   上次获取短信验证码成功的线程名
     * @param thisTime 本次请求短信验证的时间戳
     * @param thisTN   本次请求短信验证码的线程名
     * @param duration 距离上次获取短信验证码成功的时间间隔(ms)
     */
    void onGetSmsFrequent(long lastTime, String lastTN, long thisTime, String thisTN, long duration);

    /**
     * 参数错误
     *
     * @param errorType    错误类型：null = 0，empty = 1
     * @param functionName 接口名称
     * @param paramsName   参数名称
     */
    void onParamsError(int errorType, String functionName, String paramsName);
}
