package com.yy.platform.loginlite;

/**
 * Created by HUTAO on 2018/4/4.
 */

public interface IGetSmsCallback extends BaseCallback {
    /**
     * 请求短信成功
     *
     * @param requestId 上下文ID，用于异步处理
     */
    void onSuccess(int requestId);

    /**
     * 需要二次验证
     *
     * @param requestId 上下文ID，用于异步处理
     * @param authCode  返回码，目前有2种code：
     *                  1）NEXT_VER = 1;需要二次验证
     *                  2）VCODE_ERR = 13;二次验证码错误，用新的url重新输验证码验证
     * @param dynVerify 动态验证的H5 url
     */
    void onNext(int requestId, int authCode, String authDesc, NextVerify dynVerify);

}
