package com.yy.platform.loginlite;

/**
 * Created by HUTAO on 2018/4/4.
 */

public interface ICreditLoginCallback extends BaseCallback {

    /**
     * 凭证登录成功
     * @param requestId
     *          上下文ID，用于异步处理
     * @param uinfo
     *          登录成功后的账号
     *
     */
    void onSuccess(int requestId, YYInfo uinfo);

    /**
     * 动态验证，需二次验证
     * @param requestId】
     *          上下文ID，用于异步处理
     * @param dynVerify
     *          动态验证的H5 url和SessionData
     */
    void onNext(int requestId, NextVerify dynVerify);

}
