package com.yy.platform.loginlite;

import android.net.NetworkInfo;
import com.yy.platform.loginlite.report.ReportData;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by chenkaicai on 2018/10/24.
 * 上报字段
 * <p>
 * 字段名        类型     描述
 * act           STRING   yyloginlite 必备字段
 * time         INT       客户端时间(Unix时间戳) 必备字段 秒
 * key	        STRING	  数据完整校验码 必备字段(算法见帮助信息)
 * event_type	STRING	  事件类型
 * sdkver	    STRING	  统计SDK版本号 移动统计SDK必备
 * sys	        INT       操作系统平台 移动端必备，0=IOS/1=WP/2=Android
 * app	        STRING	  应用ID 移动统计SDK必备
 * appkey	    STRING	  应用key 移动统计SDK必备，通过海度申请获得
 * bak1	        STRING	  备用字段1 备用字段
 * bak2	        STRING	  备用字段2 备用字段
 * expend_time	DOUBLE	  请求协议花费的时间
 * errcode_type	 INT	  错误码类型
 * errcode	I    NT	      错误码
 * errcode_desc	STRING	  错误描述
 * succeed	     INT	  是否成功
 * appId	    STRING	  appId
 * no	         INT	  弱网优化开关 是否使用弱网优化的连接，-1未取的AP IP，0 tcp连接，1弱网传输连接
 * tid	        STRING	  traceId 追踪监控ID
 * hdid	        STRING	  HDID HDID
 * ab	        INT	      ABTest开关 -1--未知，0--旧方案，1---新方案
 * nt	        INT	      网络类型 -1--NONE,0--MOBILE,1--WIFI,
 * ncn	        INT	      网络改变次数 阶段时间内网络变化次数网络改变次数
 * nct	       BIGINT	  网络改变时间戳 最后一次网络改变时间戳
 * appver	   STRING	  app版本号
 * channel	   STRING	  通道类型 quic 或service通道
 * model	   STRING	  手机型号 手机型号
 * os	       STRING	  操作系统类型
 * uinfo	   STRING	  用户信息
 * guid	       STRING	  guid去重
 * ns	        INT       网络状态 0-CONNECTING，1-CONNECTED，4-DISCONNECTED，5-UNKNown
 * rdt	       BIGINT	  数据时间戳 上报数据产生的时间
 * qr	        INT	      使用quic返回码 是否允许使用quic、使用quic的返回码
 * total_time  BIGINT	  总耗时 如有从quic切换到service则为本次请求的总共耗时
 */

public class HiidoReport {

    public final static class CReportResponse {
        public static String mAppId = "";
        public static String mAppKey = "";

        public static int mSys = 0;

        public static String mDevice = "";
        public static String mOS = "";

        public long mRtt = 0;
        public String mEventType = "";
        public int mErrCode = 0;
        public int mErrType = 0;
        public String mErrDesc = "";
        public int mSucceed = 0;
        public int mNetOptimize = -1; // no
        public String mTraceId = "";
        public String mChannel = "";
        public String mUserInfo = ""; //uinfo
    }

    private static volatile HiidoReport sInstance = null;
    private final static String TAG = "hiidoReport";
    private ILoginliteListener.ILoginliteHiidoMetricsStatisApi mMetricsReport = null;
    private final static int SCODE = 50190;

    public static synchronized HiidoReport getInstance() {
        if (sInstance == null) {
            sInstance = new HiidoReport();
        }

        return sInstance;
    }

    public void setHiidoMetricsStatisApi(ILoginliteListener.ILoginliteHiidoMetricsStatisApi metricsReport) {
        mMetricsReport = metricsReport;
    }

    public void report2Hido(CReportResponse response) {
        if (mMetricsReport == null) {
            AuthCore.sLog.i(TAG, "ILoginliteHiidoMetricsStatisApi null");
            return;
        }

        Map<String, Integer> intFields = new HashMap<>();
        intFields.put("errcode_type", response.mErrType);
        intFields.put("errcode", response.mErrCode);
        intFields.put("succeed", response.mSucceed);
        intFields.put("sys", CReportResponse.mSys);
        intFields.put("no", response.mNetOptimize);

        intFields.put("ab", AuthInfo.getABTest());
        int nt = AuthCore.sNetWorkReceiver.checkCurrentNetwork();
        int ns = AuthCore.sNetWorkReceiver.getNetWorkState();
        intFields.put("nt", nt);
        intFields.put("ns", ns);
        intFields.put("ncn", AuthCore.sNetWorkReceiver.getNetworkChangedCount());

        final long realt = System.currentTimeMillis() / 1000;
        Map<String, Long> longFields = new HashMap<>();
        longFields.put("expend_time", Long.valueOf(response.mRtt));
        longFields.put("nct", AuthCore.sNetWorkReceiver.getLastNetworkChangedTs());
        longFields.put("rdt", realt);

        Map<String, String> stringFields = new HashMap<>();
        stringFields.put("appkey", CReportResponse.mAppKey);
        stringFields.put("appId", CReportResponse.mAppId);
        stringFields.put("event_type", response.mEventType);
//        ErrorDesc上报了乱码，不上报了
//        stringFields.put("errcode_desc", response.mErrDesc);
        stringFields.put("sdkver", AuthInfo.getSdkVersion());
        stringFields.put("tid", response.mTraceId);
        stringFields.put("appver", AuthInfo.getAppVer());
        stringFields.put("channel", response.mChannel);
        stringFields.put("os", response.mOS);
        stringFields.put("model", response.mDevice);
        stringFields.put("uinfo", response.mUserInfo);

        AuthCore.sLog.i(TAG, "report hiido,errType=" + response.mErrType
                + ",errCode=" + response.mErrCode + ",abTest=" + AuthInfo.getABTest()
                + ",netType=" + nt + ",netState=" + ns
                + ",netChangedCount=" + AuthCore.sNetWorkReceiver.getNetworkChangedCount()
                + ",netChanngetLastTS=" + AuthCore.sNetWorkReceiver.getLastNetworkChangedTs());

        mMetricsReport.reportStatisticContentTemporary("yyloginlite", intFields, longFields, stringFields);
    }

    public void report2Metric(CReportResponse response) {
        if (mMetricsReport == null) {
            AuthCore.sLog.i(TAG, "ILoginliteHiidoMetricsStatisApi is null");
            return;
        }
        AuthCore.sNetWorkReceiver.checkCurrentNetwork();
        int ns = AuthCore.sNetWorkReceiver.getNetWorkState();
        if (ns != NetworkInfo.State.CONNECTED.ordinal()) {
            AuthCore.sLog.i(TAG, "not network connected:" + ns);
            return;
        }
        long rtt = response.mRtt;
        if (response.mSucceed != 0) {
            rtt = 0;
        }
        AuthCore.sLog.i(TAG, "report metrics,eventType=" + response.mEventType
                + ",errCode=" + response.mErrCode + ",rtt=" + rtt);
        mMetricsReport.reportReturnCode(SCODE, response.mAppId + "/" + response.mEventType, rtt,
                String.valueOf(response.mErrCode));
    }

    public void reportCount2Metric(ReportData response) {
        if (response == null) {
            AuthCore.sLog.i(TAG, "data is null");
            return;
        }
        String countName = response.getCountName();
        if (countName == null || countName.length() == 0) {
            AuthCore.sLog.i(TAG, "lack of count name");
            return;
        }
        String interName = response.getInterName();
        if (interName == null || interName.length() == 0) {
            AuthCore.sLog.i(TAG, "lack of interface name");
            return;
        }
        if (mMetricsReport == null) {
            AuthCore.sLog.i(TAG, "ILoginliteHiidoMetricsStatisApi is null");
            return;
        }
        AuthCore.sNetWorkReceiver.checkCurrentNetwork();
        int ns = AuthCore.sNetWorkReceiver.getNetWorkState();
        if (ns != NetworkInfo.State.CONNECTED.ordinal()) {
            AuthCore.sLog.i(TAG, "not network connected:" + ns);
            return;
        }

        String uri = CReportResponse.mAppId + "/" + interName + "/" + response.getCode();
        mMetricsReport.reportCount(SCODE, uri, countName, 1);
    }
}
