package com.yy.platform.loginlite;

import android.content.Context;
import android.text.TextUtils;

import com.yy.platform.base.Callback;
import com.yy.platform.base.ChannelType;
import com.yy.platform.base.IYYLoginLiteChannel;
import com.yy.platform.base.Response;
import com.yy.platform.base.YYLoginLiteManager;
import com.yy.platform.base.YYLoginStatus;
import com.yy.platform.base.error.HttpError;
import com.yy.platform.base.error.ServiceError;
import com.yy.platform.base.request.HttpRequest;
import com.yy.platform.base.request.Request;
import com.yy.platform.base.request.Retry;
import com.yy.platform.base.request.ServiceRequest;
import com.yy.platform.loginlite.proto.BusiType;
import com.yy.platform.loginlite.proto.ClientRegisterErr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yy.platform.loginlite.proto.SendSmsReq2;
import com.yy.platform.loginlite.proto.SendSmsRsp2;

/**
 * Created by chenkaicai on 2019/12/19.
 */


public class GetSmsWithBusiTypeRPC {
    public GetSmsWithBusiTypeRPC(
            Context appContext,
            String phoneNum,
            String smsType,
            String smsLength,
            int useType,
            String otp,
            String dynCode,
            IGetSmsCallback callback
    ) {
        this.appContext = appContext;
        this.phoneNum = phoneNum;
        this.smsType = smsType;
        this.smsLen = smsLength;
        this.useType = useType;
        this.otp = otp;
        this.dynCode = dynCode;
        this.callback = callback;
    }

    public int run() {
        if (TextUtils.isEmpty(phoneNum)) {
            LoginLog.i("GetSmsWithBusiTypeRPC fail, email param null");
            return -1;
        }

        LoginLog.i("GetSmsWithBusiTypeRPC run, phoneNum:" + phoneNum + ", smsType:"
                + smsType + ", smsLen:" + smsLen + ", useType:" + useType);

        SendSmsReq2 emailReq = SendSmsReq2.newBuilder()
                .setContext("GetSmsWithBusiTypeRPC")
                .setMobile(phoneNum)
                .setPrheader(AuthInfo.getHeader())
                .setSmstype((smsType == null || smsType.equals("")) ? 0 : Integer.parseInt(smsType))
                .setType(BusiType.forNumber(useType))
                .setOtp(otp == null ? "" : otp)
                .setDynCode(dynCode == null ? "" : dynCode)
                .setCodelen((smsLen == null || smsLen.equals("")) ? 6 : Integer.parseInt(smsLen))
                .build();


        Map<String, String> routes = new HashMap<>();
        String regionSet = AuthInfo.getRegionSet();
        if (regionSet != null) {
            routes.put(AuthInfo.getRegionSetKey(), regionSet);
        }

        Request request = new Request();

        Retry retry = new Retry();
        retry.setCount(5);
        retry.setTime(10 * 1000);
        request.setRetry(retry);

        ServiceRequest sr = new ServiceRequest();
        sr.setRouteArgs(routes);
        sr.setFuncName("SendSMS");
        sr.setServerName("UdbApp.RegisterServer.RegisterObj");
        request.setData(emailReq.toByteArray());
        request.setServiceRequest(sr);

        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setTimeout(10 * 1000);
        httpRequest.setMethod(HttpRequest.Method.POST);
        httpRequest.setQuery("UdbApp.RegisterServer.RegisterObj/SendSMS");
        Map<String, String> headers = new HashMap<>();
        headers.put("Context", "SendSMS");
        headers.put("AppId", AuthInfo.getAppId());
        headers.put("Uid", phoneNum);
        headers.put("ServiceName", "UdbApp.RegisterServer.RegisterObj");
        headers.put("FunctionName", "SendSMS");
        headers.put("InstId", "SendSMS");
        headers.put("ServerId", "SendSMS");
        httpRequest.setHeaders(headers);
        request.setHttpRequest(httpRequest);

        final long bTime = System.currentTimeMillis();

        int reqId = YYLoginLiteManager.getInstance().send(request, new Callback() {
            @Override
            public void onSuccess(Response resp, List<YYLoginStatus> list) {
                int reqId = resp.getRequestId();
                try {
                    long eTime = System.currentTimeMillis();
                    long rtt = eTime - bTime;

                    HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
                    response.mRtt = rtt;
                    response.mEventType = "GetSmsWithBusiTypeRPC";
                    response.mUserInfo = phoneNum;

                    SendSmsRsp2 res;
                    res = SendSmsRsp2.newBuilder().mergeFrom(resp.getResponseData()).build();

                    if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
                        response.mErrCode = 0;
                        response.mErrType = 0;
                        response.mSucceed = 0;

                        LoginLog.i("GetSmsWithBusiTypeRPC success, phoneNum:" + phoneNum);
                        callback.onSuccess(reqId);
                    } else {
                        response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
                        response.mErrCode = res.getErrcodeValue();
                        response.mSucceed = 2;
                        response.mErrDesc = res.getDescription();

                        LoginLog.i("GetSmsWithBusiTypeRPC failed, phoneNum:" + phoneNum +
                                ", errType:" + response.mErrType + ", resCode:" + response.mErrCode);
                        callback.onFail(reqId, ResCodeDef.Type.AUTH_SRV_CODE, response.mErrCode,
                                res.getDescription());
                    }
                    if (resp.getChannelType() == ChannelType.SERVICE) {
                        IYYLoginLiteChannel channel = YYLoginLiteManager.getInstance().
                                getYYLoginChannelByType(ChannelType.SERVICE);
                        response.mNetOptimize = channel.getNetOptimizeSwitch();
                    }
                    response.mTraceId = resp.getTraceId();

                    HiidoReport.getInstance().report2Hido(response);
                    HiidoReport.getInstance().report2Metric(response);

                } catch (Exception e) {
                    LoginLog.i("GetSmsWithBusiTypeRPC failed, phoneNum:" + phoneNum + ", reqId=" +
                            reqId + ",exceptionDesc:" + e.getMessage());
                    callback.onFail(reqId, ResCodeDef.Type.AUTH_SDK_CODE,
                            ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
                            e.getMessage());
                }
            }

            @Override
            public void onFail(ChannelType type, ServiceError sError, HttpError hError,
                               List<YYLoginStatus> list) {
                long eTime = System.currentTimeMillis();
                long rtt = eTime - bTime;

                HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
                response.mRtt = rtt;
                response.mEventType = "GetSmsWithBusiTypeRPC";
                response.mSucceed = 2;
                response.mUserInfo = phoneNum;

                ReportUtils.fillData(response, type, sError, hError);
                CallbackUtils.fill(appContext, callback, type, sError, hError,
                        "GetSmsWithBusiTypeRPC", "fail");
                HiidoReport.getInstance().report2Hido(response);
                HiidoReport.getInstance().report2Metric(response);
            }
        });
        return reqId;
    }

    private String phoneNum;
    private String smsType;
    private String smsLen;
    private int useType;
    private String otp;
    private String dynCode;
    private IGetSmsCallback callback;
    private Context appContext;
}
