package com.yy.platform.loginlite;

import java.util.ArrayList;
import java.util.List;

class Event {
    private volatile static Event instance;
    private List<IVerifyListener> verifyListenerList;
    private List<IBindPhoneListener> bindPhoneListenerList;

    private Event() {
        verifyListenerList = new ArrayList<>();
        bindPhoneListenerList = new ArrayList<>();
    }

    public static Event getInstance() {
        if (instance == null) {
            synchronized (Event.class) {
                if (instance == null) {
                    instance = new Event();
                }
            }
        }
        return instance;
    }

    public static class Inform<T> {
        public T data;
        public int code;

        public static int FAIL = -1;

        public static Inform failOf() {
            Inform res = new Inform();
            res.code = FAIL;
            return res;
        }

        public boolean isFail() {
            return code == FAIL;
        }
    }

    public static class VerifyBean {
        public String dynCode;
    }

    public static class BindPhoneBean {
        public String uid;
        public String credit;
        public String json;
    }

    public void registerVerifyListener(IVerifyListener listener) {
        if (listener == null) {
            LoginLog.i("Event registerVerifyListener null");
            return;
        }
        verifyListenerList.add(listener);
    }

    public void unRegisterVerifyListener(IVerifyListener listener) {
        if (listener == null) {
            LoginLog.i("Event unRegisterVerifyListener null");
            return;
        }
        verifyListenerList.remove(listener);
    }

    public void registerBindPhoneListener(IBindPhoneListener listener) {
        if (listener == null) {
            LoginLog.i("Event registerBindPhoneListener null");
            return;
        }
        bindPhoneListenerList.add(listener);
    }

    public void unRegisterBindPhoneListener(IBindPhoneListener listener) {
        if (listener == null) {
            LoginLog.i("Event unRegisterBindPhoneListener null");
            return;
        }
        bindPhoneListenerList.remove(listener);
    }

    public void sendAll(Inform bean) {
        if (bean == null) {
            LoginLog.i("Event sendAll null");
            return;
        }
        for (IVerifyListener listener : verifyListenerList) {
            listener.onResponse(bean);
        }
        for (IBindPhoneListener listener : bindPhoneListenerList) {
            listener.onResponse(bean);
        }
    }

    public void send(Inform bean) {
        if (bean == null) {
            LoginLog.i("Event send null");
            return;
        }

        if (bean.data instanceof VerifyBean) {
            LoginLog.i("Event send VerifyBean");
            for (IVerifyListener listener : verifyListenerList) {
                listener.onResponse(bean);
            }
        } else if (bean.data instanceof BindPhoneBean) {
            LoginLog.i("Event send BindPhoneBean");
            for (IBindPhoneListener listener : bindPhoneListenerList) {
                listener.onResponse(bean);
            }
        } else {
            LoginLog.i("Event send not support data");
        }
    }

    public interface IVerifyListener {
        void onResponse(Inform<VerifyBean> bean);
    }

    public interface IBindPhoneListener {
        void onResponse(Inform<BindPhoneBean> bean);
    }
}


