package com.yy.platform.loginlite;

import android.content.Context;
import com.yy.platform.base.ChannelType;
import com.yy.platform.base.error.HttpError;
import com.yy.platform.base.error.ServiceError;
import com.yy.platform.loginlite.utils.IpUtils;

public class CallbackUtils {

    public static void fill(
            Context context,
            BaseCallback callback,
            ChannelType type,
            ServiceError serviceError,
            HttpError httpError,
            String func,
            String msg
    ) {
        if (type == ChannelType.SERVICE) {
            LoginLog.fail(func, msg + ",reqId=" + serviceError.requestId +
                    ",servSdkCode:" + serviceError.srvResCode + ",sdkSrvCode: " +
                    serviceError.sdkResCode + ",svcEx:" +
                    serviceError.exception.getMessage());
            if (serviceError.mErrType == ServiceError.SDK_ERROR) {
                callback.onFail(serviceError.requestId, ResCodeDef.Type.SERVICE_SDK_CODE,
                        serviceError.mErrCode, serviceError.mErrDesc);
            } else {
                callback.onFail(serviceError.requestId, ResCodeDef.Type.SERVICE_SRV_CODE,
                        serviceError.mErrCode, serviceError.mErrDesc);
            }
        } else {
            LoginLog.fail(func, msg + ",reqId=" + httpError.requestId +
                    ",code=" + httpError.mErrCode + ",msg:" + httpError.mErrDesc);
            callback.onFail(httpError.requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                    httpError.mErrCode, httpError.mErrDesc);
        }
        IP ip = IpUtils.getIPAddress(context);
        if (ip.isIPv6) {
            LoginLog.i(func + " TYPE_MOBILE,ipv6");
        }
        LoginLog.printSep(func);
    }
}