package com.yy.platform.loginlite;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.yy.platform.loginlite.proto.ThirdloginRsp;

import org.json.JSONObject;

class BindPhoneUtils {

    private final static int ERROR_BIND_PHONE = -16;

    public static void toThirdLoginBindActivity(
            final AuthCore authCore, final Context context, final int requestId, final String lang,
            final String channel, final ThirdloginRsp res, final IThirdLoginCallback callback
    ) {
        String code = res.getRescode();
        if (!TextUtils.isEmpty(code) && Integer.parseInt(code) == ERROR_BIND_PHONE) {
            Event.getInstance().registerBindPhoneListener(new Event.IBindPhoneListener() {
                @Override
                public void onResponse(final Event.Inform<Event.BindPhoneBean> bean) {
                    LoginLog.i("thirdLogin bind phone Code: " + bean.code);
                    if (bean.code == 10) {
                        final String uid = bean.data.uid;
                        final String credit = bean.data.credit;
                        final long yyid = Long.parseLong(uid);
                        authCore.creditLogin(yyid, credit,
                                new ICreditLoginCallback() {
                                    @Override
                                    public void onSuccess(int r, YYInfo uinfo) {
                                        String json = bean.data.json;
                                        ThirdInfo info = new ThirdInfo();
                                        info.mChannel = channel;
                                        info.mCredit = credit;
                                        info.mUid = yyid;
                                        try {
                                            JSONObject jsonObject = new JSONObject(json);
                                            String userStatus =
                                                    jsonObject.getString("user_status");
                                            info.mIsNewUser = userStatus.equals("0");
                                            String thirdInfo =
                                                    jsonObject.getJSONObject("thirdData").toString();
                                            info.mThirdInfo = thirdInfo;
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            AuthCore.sLog.i(AuthCore.TAG, "exception: " +
                                                    e.getMessage());
                                        } finally {
                                            callback.onSuccess(requestId, info);
                                        }
                                    }

                                    @Override
                                    public void onNext(int requestId, NextVerify dynVerify) {
                                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                                ERROR_BIND_PHONE, res.getMessage());
                                    }

                                    @Override
                                    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
                                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                                ERROR_BIND_PHONE, res.getMessage());
                                    }
                                });
                    } else {
                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                                ERROR_BIND_PHONE, res.getMessage());
                    }
                    Event.getInstance().unRegisterBindPhoneListener(this);
                }
            });
//            BroadcastReceiver receiver = new BroadcastReceiver() {
//                @Override
//                public void onReceive(Context context, final Intent intent) {
//                    int code = intent.getIntExtra("result", -1);
//                    AuthCore.sLog.i(AuthCore.TAG, "thirdLogin bind phone resultCode: " + code);
//                    if (code == 10) {
//                        final String uid = intent.getStringExtra("uid");
//                        final String credit = intent.getStringExtra("credit");
//                        final long yyid = Long.parseLong(uid);
//                        authCore.creditLogin(yyid, credit,
//                                new ICreditLoginCallback() {
//                                    @Override
//                                    public void onSuccess(int r, YYInfo uinfo) {
//                                        String json = intent.getStringExtra("json");
//                                        ThirdInfo info = new ThirdInfo();
//                                        info.mChannel = channel;
//                                        info.mCredit = credit;
//                                        info.mUid = yyid;
//                                        try {
//                                            JSONObject jsonObject = new JSONObject(json);
//                                            String user_status =
//                                                    jsonObject.getString("user_status");
//                                            info.mIsNewUser = user_status.equals("0");
//                                            String thirdInfo =
//                                                    jsonObject.getJSONObject("thirdData").toString();
//                                            info.mThirdInfo = thirdInfo;
//                                        } catch (Exception e) {
//                                            e.printStackTrace();
//                                            AuthCore.sLog.i(AuthCore.TAG, "exception: " + e.getMessage());
//                                        } finally {
//                                            callback.onSuccess(requestId, info);
//                                        }
//                                    }
//
//                                    @Override
//                                    public void onNext(int requestId, NextVerify dynVerify) {
//                                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                                ERROR_BIND_PHONE, res.getMessage());
//                                    }
//
//                                    @Override
//                                    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//                                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                                ERROR_BIND_PHONE, res.getMessage());
//                                    }
//                                });
//                    } else {
//                        callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
//                                ERROR_BIND_PHONE, res.getMessage());
//                    }
//
//                    context.unregisterReceiver(this);
//                }
//            };
//            context.registerReceiver(receiver, new IntentFilter(BindPhone));
            String url = res.getMessage() + "&lang=" + lang;
            LoginLog.i("url:" + url);
            Intent intent = new Intent(context, DialogActivity.class);
            intent.putExtra("url", url);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } else {
            callback.onFail(requestId, ResCodeDef.Type.AUTH_SRV_CODE,
                    Integer.parseInt(code), res.getMessage());
        }
    }
}
