package com.yy.platform.loginlite;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.yy.platform.base.ChannelType;
import com.yy.platform.base.IYYLoginLiteChannel;
import com.yy.platform.base.YYLoginLiteManager;
import com.yy.platform.loginlite.proto.ProtoHeader;

import com.yy.platform.outudb.BuildConfig;
import com.yy.secure.deviceidentifiertest.VirtualDevice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/**
 * Created by HUTAO on 2018/4/3.
 */

public class AuthInfo {

    private static AuthInfo sInstance = null;
    private static ProtoHeader sHeader = null;
    protected static Context sContext = null;

    private static String sAntiBizName = "";
    private static String sAppId = null;
    private static SharedPreferences sAuthPref = null;
    private static boolean sIsOverseas = true; // 是否使用国外版风控

    //当前登录的UID、Credit,未登录则为null
    private static LoginAuth sAuthed = null;
    private static Map<Long, LoginAuth> sAuthInfo = null;

    private static String UIDS_KEY = "UIDS";
    private static String CREDIT_KEY_SUFFIX = "_CREDIT";
    private static String TS_KEY_SUFFIX = "_TS";

    private static String LOCAL_PREFIX = "_local";
    private static String PRE_LOCAL_PREFIX = "_prev_local";
    private static String DIFF_PREFIX = "_diff";

    private static final long DAY = 24 * 3600 * 1000;

    private static String sRegionSet = null;

    private AuthInfo() {

    }

    public synchronized static void setRegionSet(String region) {
        if (region == null) {
            sRegionSet = null;
        }
        sRegionSet = region;
    }

    public synchronized static String getRegionSet() {
        return sRegionSet;
    }

    public synchronized static String getRegionSetKey() {
        return "setselector";
    }

    private static int sABTest = -1;

    public synchronized static void setABTest(int abTest) {
        if (sABTest == -1) {
            sABTest = abTest;
        }
    }

    public synchronized static int getABTest() {
        return sABTest;
    }

    public synchronized static AuthInfo init(
            final Context appContext, String appId,
            String region, String antiBizName,
            boolean isOverseas, boolean isEnableRisk
    ) {
        if (sInstance == null) {
            sInstance = new AuthInfo();
            sContext = appContext;
            sAuthPref = sContext.getSharedPreferences(appId + "loginlite", Context.MODE_PRIVATE);
            sAppId = appId;
            sAntiBizName = (antiBizName == null ? "" : antiBizName);
            sIsOverseas = isOverseas;
            loadAuth();
            String deviceId = getDeviceId();
            String appVer = getAppVer();
            sHeader = ProtoHeader.newBuilder()
                    .setInfVer("1")
                    .setAppId(appId)
                    .setAppVer(appVer)
                    .setSys("android")
                    .setSysVer("android" + android.os.Build.VERSION.RELEASE)
                    .setDeviceId(deviceId)
                    .setRegion(region)
                    .setImei(deviceId)
                    .setCapsupport(String.valueOf(isEnableRisk))
                    .setMac("")
                    .setSimNum("")
                    .build();

            AuthCore.sLog.i(AuthCore.TAG, "preHeader,appId:" + sHeader.getAppId() +
                    ",isOverseas: " + isOverseas + ",deviceId:" + sHeader.getDeviceId() +
                    ",region:" + sHeader.getRegion());
        }
        return sInstance;
    }

    public static String getAppId() {
        return sAppId;
    }

    public static String getAntiBizName() {
        return sAntiBizName;
    }

    public static void setAntiBizName(String bizName) {
        sAntiBizName = bizName;
    }

    public static boolean isOverseas() {
        return sIsOverseas;
    }

    public static ProtoHeader getHeader() {
        return sHeader;
    }

    public static Context getAppContext() {
        return sContext;
    }

    /**
     * 获取设备唯一标识码
     *
     * @return 出错时返回null
     */
    protected static String getDeviceId() {
        try {
            String deviceId = new VirtualDevice(sContext).getDeviceID(sContext);
            AuthCore.sLog.i(AuthCore.TAG, "---DeviceId: " + deviceId);
            return deviceId;
        } catch (Exception ex) {
            AuthCore.sLog.i(AuthCore.TAG, ex.getMessage());
            return "";
        } catch (UnsatisfiedLinkError e) {
            AuthCore.sLog.i(AuthCore.TAG, e.getMessage());
            return "";
        } catch (Error e) {
            AuthCore.sLog.i(AuthCore.TAG, e.getMessage());
            return "";
        }
    }

    protected static String getAppVer() {
        try {
            PackageManager packageManager = sContext.getPackageManager();
            PackageInfo packInfo = packageManager.getPackageInfo(sContext.getPackageName(), 0);
            return packInfo.versionName == null ? "" : packInfo.versionName;
//            String appVersion = packInfo.packageName + "(" + packInfo.versionName + ")";
//            return appVersion;
        } catch (Throwable ex) {
            AuthCore.sLog.i(AuthCore.TAG, ex.getMessage());
            return "";
        }
    }

    protected static String getSdkVersion() {
        return BuildConfig.BUILD_VERSION;
    }

    protected static class LoginAuth {
        protected long mUid = 0L;
        protected String mCredit = "";
        protected long mTS = 0L;

        //        登录成功后手机时间戳
        protected long mLocal = 0L;
        //        上次登录成功后的手机时间戳
        protected long mPrevLocal = 0L;
        //        登录成功后服务器的时间和手机时间的差值
        protected long mDiff = 0L;
    }

    private static synchronized void loadAuth() {
        sAuthInfo = new HashMap<>();
        Set<String> uidstr = sAuthPref.getStringSet(UIDS_KEY, null);
        if (uidstr != null) {
            for (String uid : uidstr) {
                AuthCore.sLog.i(AuthCore.TAG, "one user:" + uid);
                sAuthed = new LoginAuth();
                sAuthed.mUid = Long.parseLong(uid);
                sAuthed.mTS = sAuthPref.getLong(String.valueOf(uid) + TS_KEY_SUFFIX, 0);
                sAuthed.mCredit = sAuthPref.getString(String.valueOf(uid) + CREDIT_KEY_SUFFIX, "");

                sAuthed.mLocal = sAuthPref.getLong(uid + LOCAL_PREFIX, 0);
                sAuthed.mPrevLocal = sAuthPref.getLong(uid + PRE_LOCAL_PREFIX, 0);
                long diff = sAuthed.mTS - sAuthed.mLocal;
                sAuthed.mDiff = sAuthPref.getLong(uid + DIFF_PREFIX, diff);

                sAuthInfo.put(sAuthed.mUid, sAuthed);
            }
        } else {
            AuthCore.sLog.i(AuthCore.TAG, "no any user");
        }
    }

    protected static synchronized String getCredit(long uid) {
        //如果uid不同，则清除当前鉴权的信息sAuthed,避免creditLogin失败后用错otp
        if (sAuthed != null && (sAuthed.mUid != uid)) {
            sAuthed = null;
        }
        LoginAuth auth = sAuthInfo.get(uid);
        if (auth == null) {
            //以下代码是为了兼容旧版Mars版本登录的实现
            long lastUid = 0L;
            SharedPreferences oldAuthInfo = sContext.getSharedPreferences(sAppId + "pbmars", Context.MODE_PRIVATE);
            try {
                String lastUidStr = oldAuthInfo.getString("LAST_YYUID", "");
                lastUid = Long.parseLong(lastUidStr);
                if (uid == lastUid) {
                    String lastCredit = oldAuthInfo.getString("LAST_CREDIT", "");
                    String lastCreditTs = oldAuthInfo.getString("LAST_CREATETS", "");
                    long lastts = 0L;
                    if ("".equals(lastCreditTs)) {
                        lastts = 0L;
                    }
                    lastts = Long.parseLong(lastCreditTs);
                    sAuthed = new LoginAuth();
                    sAuthed.mUid = uid;
                    sAuthed.mTS = lastts;
                    sAuthed.mCredit = lastCredit;
                    sAuthInfo.put(sAuthed.mUid, sAuthed);
                    AuthCore.sLog.i(AuthCore.TAG,
                            "last auth info for uid/credit len/ts" + uid + "," + lastCredit.length() + "," +
                                    lastCreditTs);
                    return lastCredit;
                }
            } catch (NumberFormatException var4) {
                lastUid = 0L;
            }
            AuthCore.sLog.i(AuthCore.TAG, "no auth info for get uid/last uid:" + uid + "," + lastUid);
            return "";
        }
        return auth.mCredit;
    }

    protected static synchronized void saveAuth(long uid, String credit, long ts) {
        long current = System.currentTimeMillis();
        long prev = 0L;
        if (sAuthInfo.containsKey(uid)) {
            prev = sAuthInfo.get(uid).mLocal;
        }
        sAuthed = new LoginAuth();
        sAuthed.mUid = uid;
        sAuthed.mCredit = credit;
        sAuthed.mTS = ts; // 1582709047000,1582709097000
        sAuthed.mPrevLocal = prev;
        sAuthed.mLocal = current;
        sAuthed.mDiff = ts - current;
        LoginLog.i("login success ts:" + ts + ",prev:" + prev + ",current: " + current +
                ",diff: " + sAuthed.mDiff);
        sAuthInfo.put(uid, sAuthed);

        if (credit == null || credit.isEmpty()) {
            AuthCore.sLog.i(AuthCore.TAG, "warning for uid:" + uid + ",credit is empty");
            credit = "";
        }

        SharedPreferences.Editor editor = sAuthPref.edit();
        Set<String> uids = sAuthPref.getStringSet(UIDS_KEY, null);
        if (uids == null) {
            uids = new HashSet<>();
        }

        uids.add(String.valueOf(uid));
        editor.putStringSet(UIDS_KEY, uids);
        editor.putString(uid + CREDIT_KEY_SUFFIX, credit);
        editor.putLong(uid + TS_KEY_SUFFIX, ts);
        editor.putLong(uid + LOCAL_PREFIX, current);
        editor.putLong(uid + PRE_LOCAL_PREFIX, sAuthed.mPrevLocal);
        editor.putLong(uid + DIFF_PREFIX, sAuthed.mDiff);

        boolean ret = editor.commit();
        if (!ret) {
            AuthCore.sLog.i(AuthCore.TAG, "fail to save for uid:" + uid + ",credit:" + credit);
        } else {
            AuthCore.sLog.i(AuthCore.TAG, "success to save for uid:" + uid + ",credit:" + credit);
        }
    }

    protected static synchronized byte[] getOtp(String destAppId, long uid) {
        if (sAuthed != null) {
            if (sAuthed.mUid != uid) {
                LoginLog.i("current uid: " + sAuthed.mUid + ",uid:" + uid);
                LoginAuth tmp = sAuthInfo.get(uid);
                if (tmp == null) {
                    LoginLog.i("no authed info for dest app:" + destAppId + ", uid: " + uid);
                    return "".getBytes();
                }
                sAuthed = tmp;
            }
            if (sAuthed.mCredit == null || sAuthed.mCredit.isEmpty()) {
                LoginLog.i("no credit for dest app:" + destAppId + ",uid:" + sAuthed.mUid);
                return "".getBytes();
            }
            if (destAppId == null || destAppId.isEmpty()) {
                destAppId = sAppId;
            }
            long ts = System.currentTimeMillis();
            IYYLoginLiteChannel channel = YYLoginLiteManager.getInstance().
                    getYYLoginChannelByType(ChannelType.SERVICE);
            if (channel != null) {
                long diff = channel.getServerTimeStampDiff();
                long syn = (ts + diff) / 1000;
                String nonce = getRandomString(sAuthed.mCredit.length() / 20);
                byte[] otp = AuthCore.getOtp(sAuthed.mUid, syn, sAuthed.mCredit.getBytes(),
                        sAppId.getBytes(), destAppId.getBytes(),
                        AuthInfo.getDeviceId().getBytes(), nonce.getBytes());
                LoginLog.i("for dest app:" + destAppId + " otp size:" +
                        (otp == null ? 0 : otp.length));
                return otp;
            }

            long refresh = sAuthed.mLocal - ts;
            LoginLog.i("上次登录本地时间：" + sAuthed.mPrevLocal +
                    ",当前登录本地时间: " + sAuthed.mLocal + ",diff: " + refresh);
            sAuthed.mLocal = ts;
//            如果不是第一次登录，且上一次登录成功
//             时的手机时间戳超过或少于当前手机时间24小时，触发刷新凭据
            if (sAuthed.mPrevLocal > 0 && Math.abs(refresh) >= DAY) {
                LoginLog.i("刷新凭据");
                // 凭证登录
                AuthCore.getInstance().creditLogin(sAuthed.mUid, new ICreditLoginCallback() {
                    @Override
                    public void onSuccess(int requestId, YYInfo uinfo) {

                    }

                    @Override
                    public void onNext(int requestId, NextVerify dynVerify) {

                    }

                    @Override
                    public void onFail(int requestId, int codeType, int resCode, String resDesc) {

                    }
                });
            }
            //取单位s
            long syncts = (ts + sAuthed.mDiff) / 1000;
            String nonce = getRandomString(sAuthed.mCredit.length() / 20);
            byte[] otp = AuthCore.getOtp(sAuthed.mUid, syncts, sAuthed.mCredit.getBytes(),
                    sAppId.getBytes(), destAppId.getBytes(),
                    AuthInfo.getDeviceId().getBytes(), nonce.getBytes());
            LoginLog.i("for dest app:" + destAppId + " otp size:" +
                    (otp == null ? 0 : otp.length));
            return otp;
        }
        LoginLog.i("no authed info for dest app:" + destAppId + ", uid: " + uid);
        return "".getBytes();
    }

    protected static synchronized byte[] getServiceOtp(long uid) {
        return getOtp("signap", uid);
    }

    protected static synchronized void logout(boolean enableAutoLoginNext) {
        if (sAuthed == null) {
            AuthCore.sLog.i(AuthCore.TAG, "no authed info");
            return;
        }
        if (!enableAutoLoginNext) {
            AuthCore.sLog.i(AuthCore.TAG, "disable auto login next time for uid:" + sAuthed.mUid);
            SharedPreferences.Editor editor = sAuthPref.edit();
            Set<String> uids = sAuthPref.getStringSet(UIDS_KEY, null);
            if (uids == null) {
                uids = new HashSet<>();
            }
            uids.remove(String.valueOf(sAuthed.mUid));
            editor.putStringSet(UIDS_KEY, uids);
            editor.remove(sAuthed.mUid + CREDIT_KEY_SUFFIX);
            editor.remove(sAuthed.mUid + TS_KEY_SUFFIX);
            boolean ret = editor.commit();
            if (!ret) {
                AuthCore.sLog.i(AuthCore.TAG, "fail to clear for uid:" + sAuthed.mUid);
            } else {
                AuthCore.sLog.i(AuthCore.TAG, "success to clear for uid:" + sAuthed.mUid);
            }
            sAuthInfo.remove(sAuthed.mUid);
        }
        sAuthed = null;
    }

    /**
     * 产生一个随机的字符串
     */
    protected static String getRandomString(int len) {
        String returnStr = "";
        char[] ch = new char[len];
        Random rd = new Random();
        for (int i = 0; i < len; i++) {
            ch[i] = (char) (rd.nextInt(9) + 97);
        }
        returnStr = new String(ch);
        return returnStr;
    }
    //涉及google play 限制的隐私，不采用
//    private static String getSimNumber(){
//        try{
//            String simnumber = "";
//
//            TelephonyManager tm = (TelephonyManager) sContext.getSystemService(TELEPHONY_SERVICE);
//            simnumber = tm.getSimSerialNumber();
//
//            Log.i(OutAuth.TAG, "---SIM : " + simnumber);
//            return simnumber == null?"":simnumber;
//        }catch (Exception ex){
//            Log.i(OutAuth.TAG,"%s",ex);
//        }
//        return "";
//    }
//    private static String getIMEI(){
//        try{
//            String imei = "";
//
//            TelephonyManager tm = (TelephonyManager) sContext.getSystemService(TELEPHONY_SERVICE);
//            imei = tm.getDeviceId();
//
//            Log.i(OutAuth.TAG, "---IMEI : " + imei);
//            return imei == null ? "" : imei;
//        }catch (Exception ex){
//            Log.i(OutAuth.TAG,"%s",ex);
//        }
//        return "";
//    }

//    private static String getMacAddress(){
//        try{
//            String mac = "";
//            // 获取wifi管理器
//            WifiManager wifiMng = (WifiManager) sContext.getSystemService(Context.WIFI_SERVICE);
//            WifiInfo wifiInfor = wifiMng.getConnectionInfo();
//            mac = wifiInfor.getMacAddress();
//            Log.i(OutAuth.TAG, "---Mac Address : " + mac);
//            return mac == null ? "" : mac;
//        }catch (Exception ex){
//            Log.i(OutAuth.TAG,"%s",ex);
//        }
//        return "";
//    }


//    private static Map<Long,String> sUidsCredit = null;
//    private static String UIDS_KEY = "UIDS";
//    private static String CREDIT_KEY_SUFFIX = "_CREDIT";
//    private static String TS_KEY_SUFFIX = "_TS";
//
//    protected synchronized static void saveCredit(long uid, String credit,long ts) {
//        if(credit == null || credit.isEmpty()){
//            AuthCore.sLog.i(AuthCore.TAG, "warning for uid:" + uid +",credit is empty");
//            return;
//        }
//
//        SharedPreferences.Editor editor = sAuthInfo.edit();
//        Set<String> uids = sAuthInfo.getStringSet(UIDS_KEY,null);
//        if(uids == null){
//            uids = new HashSet<>();
//        }
//        sUidsCredit.put(uid,credit);
//        uids.add(String.valueOf(uid));
//        editor.putStringSet(UIDS_KEY,uids);
//        editor.putString(String.valueOf(uid) + CREDIT_KEY_SUFFIX,credit);
//        editor.putLong(String.valueOf(uid) + TS_KEY_SUFFIX,ts);
//        boolean ret = editor.commit();
//        if (!ret) {
//            AuthCore.sLog.i(AuthCore.TAG, "fail to commit for uid:" + uid +",credit:" + credit);
//        }else {
//            AuthCore.sLog.i(AuthCore.TAG, "success to commit for uid:" + uid +",credit:" + credit);
//        }
//    }
//    protected synchronized static String getCredit(long uid){
//        String credit = sUidsCredit.get(uid);
//        if(credit == null || credit.isEmpty()){
//            credit = sAuthInfo.getString(String.valueOf(uid) + CREDIT_KEY_SUFFIX,"");
//        }
//        AuthCore.sLog.i(AuthCore.TAG, "get credit for uid:" + uid +",credit:" + credit);
//        return credit;
//    }
//
//    protected synchronized static TreeMap<Long,Long> getUsers(){
//        TreeMap<Long,Long> users = new TreeMap<Long,Long>(new Comparator<Long>() {
//            @Override
//            public int compare(Long aLong, Long t1) {
//                return t1.compareTo(aLong);
//            }
//        });
//        Set<String> uidstr = sAuthInfo.getStringSet(UIDS_KEY,null);
//        if(uidstr!=null){
//            for(String uid : uidstr){
//                long uidl = Long.parseLong(uid);
//                long ts = sAuthInfo.getLong(String.valueOf(uid) + TS_KEY_SUFFIX,0);
//                if(ts > 0){
//                    users.put(uidl,ts);
//                }
//            }
//        }
//
//        return users;
//    }
}
