//package com.yy.platform.loginlite;
//
//import android.app.Activity;
//import android.app.Service;
//import android.content.ClipData;
//import android.content.ClipboardManager;
//import android.content.Context;
//import android.content.IntentFilter;
//import android.net.ConnectivityManager;
//import android.os.Build;
//import android.os.Bundle;
//import android.os.Handler;
//import android.text.TextUtils;
//import android.util.Log;
//
//import com.dw.android.itna.DwItna;
//import com.google.protobuf.ByteString;
//import com.google.protobuf.InvalidProtocolBufferException;
//import com.yy.platform.baseservice.ConstCode;
//import com.yy.platform.baseservice.IRPCChannel;
//import com.yy.platform.baseservice.YYServiceCore;
//import com.yy.platform.baseservice.task.RPCTask;
//import com.yy.platform.baseservice.task.TaskOptions;
//import com.yy.platform.loginlite.proto.AntiGetSdkCodeReq;
//import com.yy.platform.loginlite.proto.AntiGetSdkCodeReqHw;
//import com.yy.platform.loginlite.proto.AntiGetSdkCodeRsp;
//import com.yy.platform.loginlite.proto.AntiGetSdkCodeRspHw;
//import com.yy.platform.loginlite.proto.AntiVerifySdkResultReq;
//import com.yy.platform.loginlite.proto.AntiVerifySdkResultReqHw;
//import com.yy.platform.loginlite.proto.AntiVerifySdkResultRsp;
//import com.yy.platform.loginlite.proto.AntiVerifySdkResultRspHw;
//import com.yy.platform.loginlite.proto.BindMobileReq;
//import com.yy.platform.loginlite.proto.BindMobileRsp;
//import com.yy.platform.loginlite.proto.ClientRegisterErr;
//import com.yy.platform.loginlite.proto.CreditLoginReq;
//import com.yy.platform.loginlite.proto.CreditLoginRsp;
//import com.yy.platform.loginlite.proto.Errcode;
//import com.yy.platform.loginlite.proto.PwdLoginReq;
//import com.yy.platform.loginlite.proto.PwdLoginRsp;
//import com.yy.platform.loginlite.proto.QrCancelReq;
//import com.yy.platform.loginlite.proto.QrCancelRsp;
//import com.yy.platform.loginlite.proto.QrConfirmReq;
//import com.yy.platform.loginlite.proto.QrConfirmRsp;
//import com.yy.platform.loginlite.proto.QrScanReq;
//import com.yy.platform.loginlite.proto.QrScanRsp;
//import com.yy.platform.loginlite.proto.SendSmsReq;
//import com.yy.platform.loginlite.proto.SendSmsRsp;
//import com.yy.platform.loginlite.proto.SmsLoginReq;
//import com.yy.platform.loginlite.proto.SmsLoginRsp;
//import com.yy.platform.loginlite.proto.SmsModifyPwdReq;
//import com.yy.platform.loginlite.proto.SmsModifyPwdRsp;
//import com.yy.platform.loginlite.proto.SmsRegisterReq;
//import com.yy.platform.loginlite.proto.SmsRegisterRsp;
//import com.yy.platform.loginlite.proto.ThirdloginReq;
//import com.yy.platform.loginlite.proto.ThirdloginRsp;
//import com.yy.platform.loginlite.report.PhoneReport;
//import com.yy.platform.loginlite.utils.IpUtils;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.UserInfoUtils;
//
//import org.json.JSONException;
//import org.json.JSONObject;
//
//import java.util.ArrayList;
//import java.util.Collections;
//import java.util.HashMap;
//import java.util.Map;
//
//public class AuthCoreServer implements IAuthCore {
//
//    public static String TAG = "authsdk";
//
//    private static volatile AuthCoreServer sInstance = null;
//    private static Handler sMainHandler = null;
//
//    public static LogWrapper sLog = null;
//
//    private static String sSessionData = "";
//
//    private static ArrayList<Integer> sBRetryStrategy5s =
//            new ArrayList<Integer>(Collections.nCopies(12, new Integer(5000)));
//
//    private static ArrayList<Integer> sBRetryStrategy10s =
//            new ArrayList<Integer>(Collections.nCopies(5, new Integer(10000)));
//
//    private Context appContext;
//    private static boolean isSdkAccomplish = true;
//
//    private AuthCoreServer() {
//
//    }
//
//    /**
//     * 设置ABTest开关，2.2.11-snapshot版本开始
//     * 0--- 保持旧版策略A         1---将重试策略从25s改为60s，策略B
//     *
//     * @param abTestSwitch
//     */
//    public static synchronized void setABTest(int abTestSwitch) {
//        //固化为B策略
//        AuthInfo.setABTest(1);
//    }
//
//    /**
//     * 设置UDB 服务使用Service路由的set功能，填国家码，如CN，US，BR
//     *
//     * @param regionSet
//     */
//    public static synchronized void setRegionSet(String regionSet) {
//        AuthInfo.setRegionSet(regionSet);
//    }
//
//    public void isSdkAccomplish(boolean flag) {
//        isSdkAccomplish = flag;
//    }
//
//    protected static NetworkReceiver sNetWorkReceiver = null;
//
//    /**
//     * 初始化海外登录 UDB SDK
//     *
//     * @param appContext App Context
//     * @param appId      申请的服务AppId
//     * @param langCode   语言代码，参考{https://blog.csdn.net/xiaozhu54321/article/details/48196301}
//     * @param logger     写日志
//     * @return
//     */
////    public static IAuthCore init(Context appContext,
////                                 String appId,
////                                 String langCode,
////                                 ILog logger) {
////        return init(appContext, appId, langCode, "", logger);
////    }
//
//    /**
//     * 初始化海外登录 UDB SDK
//     *
//     * @param appContext  App Context
//     * @param appId       申请的服务AppId
//     * @param langCode    语言代码，参考{https://blog.csdn.net/xiaozhu54321/article/details/48196301}
//     * @param antiBizName 使用反外挂的业务app名
//     * @param logger      写日志
//     * @return
//     */
//    public static IAuthCore init(
//            Context appContext,
//            String appId,
//            String langCode,
//            String antiBizName,
//            AuthConfig config,
//            ILog logger
//    ) {
//        if (sInstance == null) {
//            synchronized (AuthCoreServer.class) {
//                if (sInstance == null) {
//                    HiidoReport.CReportResponse.mAppId = appId;
//                    HiidoReport.CReportResponse.mSys = 2;
//                    HiidoReport.CReportResponse.mDevice = Build.MANUFACTURER + "_" + Build.MODEL;
//                    HiidoReport.CReportResponse.mOS = "Android" + Build.VERSION.RELEASE;
//
//                    LocalLoadLibraryUtils.loadLibrary(appContext, "yyauthlite");
//                    LocalLoadLibraryUtils.loadLibrary(appContext, "DeviceIdentifier");
//
//                    sLog = new LogWrapper(logger);
//                    isSdkAccomplish = config.isSdkAccomplish();
//                    AuthInfo.init(appContext, appId, langCode, antiBizName,
//                            config.isOverseas(), config.isEnableRisk());
//                    sMainHandler = new Handler(appContext.getMainLooper());
//
//                    sInstance = new AuthCoreServer();
//                    if (appContext instanceof Activity) {
//                        sInstance.appContext = ((Activity) appContext).getApplication();
//                    } else if (appContext instanceof Service) {
//                        sInstance.appContext = ((Service) appContext).getApplication();
//                    } else {
//                        sInstance.appContext = appContext;
//                    }
//                    sNetWorkReceiver = new NetworkReceiver(appContext);
//                    sNetWorkReceiver.getNetWorkType();
//
//                    IntentFilter mFilter = new IntentFilter();
//                    mFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
//                    appContext.registerReceiver(sInstance.sNetWorkReceiver, mFilter);
//                }
//            }
//        }
//        return sInstance;
//    }
//
//    public static synchronized IAuthCore getInstance() {
//        return sInstance;
//    }
//
//    public static String getSessionData() {
//        return sSessionData;
//    }
//
//    public static void setSessionData(String sessionData) {
//        sSessionData = sessionData;
//    }
//
//    public static class LogWrapper {
//        private static ILog sLog = null;
//
//        LogWrapper(ILog logger) {
//            sLog = logger;
//        }
//
//        public static synchronized void i(String tag, String msg) {
//            if (sLog != null) {
//                sLog.i(tag, msg);
//            } else {
//                Log.i(tag, msg);
//            }
//        }
//    }
//
//    @Override
//    public void setHiidoMetricsApi(ILoginliteListener.ILoginliteHiidoMetricsStatisApi listener) {
//        HiidoReport.getInstance().setHiidoMetricsStatisApi(listener);
//    }
//
//    @Override
//    public int getSms(final String phone, final String smsType, final String smsLength,
//                      final String dynCode, final IGetSmsCallback callback) {
//        if (TextUtils.isEmpty(phone)) {
//            LoginLog.i("getSms phone is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("getSms IGetSmsCallback is null");
//            return -1;
//        }
//        PhoneReport.report("getSms", phone);
//
//        SendSmsReq smsReq = SendSmsReq.newBuilder()
//                .setUser(phone)
//                .setSmsType((smsType == null || smsType.isEmpty()) ? "0" : smsType)
//                .setPrheader(AuthInfo.getHeader())
//                .setCodelength((smsLength == null || smsLength.length() == 0) ? "6" : smsLength)
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .setSessiondata(sSessionData == null ? "" : sSessionData)
//                .build();
//
//        final String func = "getSms";
//        final String tag = AuthCoreServer.TAG;
//
//        LoginLog.printSep(tag, func);
//        LoginLog.start(tag, func, "getSms: " + smsReq.toString());
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.LoginServer.LoginObj", "LoginSendSms",
//                        smsReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy10s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "SendSmsReq";
//                            response.mUserInfo = phone;
//
//                            SendSmsRsp res =
//                                    SendSmsRsp.newBuilder().mergeFrom(responseParam.mResponseData)
//                                            .build();
//
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                sSessionData = res.getSessiondata();
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//                                LoginLog.success(tag, func, "getSms success,phoNo=" +
//                                        phone + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onSuccess(i);
//
//                            } else if (res.getErrcode() == Errcode.NEXT_VER) {
//                                // 需要二次验证
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//                                LoginLog.fail(tag, func, "getSms fail,phoNo=" +
//                                        phone + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//                            } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//                                //二次验证码失败
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mSucceed = 2;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//
//                                LoginLog.fail(tag, func, "getSms fail,phoNo=" +
//                                        phone + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//                            } else {
//                                sSessionData = res.getSessiondata();
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//
//                                LoginLog.fail(tag, func, "getSms fail,phoNo=" +
//                                        phone + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(), res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.fail(tag, func, "getSms fail,phoNo=" + phone +
//                                    ",reqId=" + i + ",exceptionDesc:" + e.getMessage());
//                            LoginLog.printSep(tag, func);
//
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "SendSmsReq";
//                        response.mSucceed = 2;
//                        response.mUserInfo = phone;
//
//                        LoginLog.fail(tag, func, "getSms fail,phoNo=" +
//                                phone + ",reqId=" + i + ",svcSdkCode:" + i1 +
//                                ",svcSrvCode: " + i2 + ",svcEx:" + e.getMessage());
//                        IP ip = IpUtils.getIPAddress(appContext);
//                        if (ip.isIPv6) {
//                            LoginLog.fail(tag, func, "TYPE_MOBILE,ipv6");
//                        }
//                        LoginLog.printSep(tag, func);
//
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//
//                    }
//                });
//
//        return reqId;
//    }
//
//
//    @Override
//    public int smsRegister(final String account, final String smsCode, final String password,
//                           final ISmsRegisterCallback callback) {
//        if (TextUtils.isEmpty(account)) {
//            LoginLog.i("smsRegister account is null or empty");
//            return -1;
//        }
//        if (TextUtils.isEmpty(smsCode)) {
//            LoginLog.i("smsRegister smsCode is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("smsRegister ISmsRegisterCallback is null");
//            return -1;
//        }
//        PhoneReport.report("smsRegister", account);
//        SmsRegisterReq req = SmsRegisterReq.newBuilder()
//                .setUser(account)
//                .setSmscode(smsCode)
//                .setSha1Pwd(YYLoginliteUtils.getPasswdSha1(password))
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.RegisterServer.RegisterObj", "RegisterBySms",
//                        req.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy10s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "smsRegister";
//                            response.mUserInfo = account;
//
//                            SmsRegisterRsp res =
//                                    SmsRegisterRsp.newBuilder()
//                                            .mergeFrom(responseParam.mResponseData).build();
//                            LoginLog.i(AuthCoreServer.TAG, "register by sms call success,acc=" +
//                                    account + ",reqId=" + i +
//                                    ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" +
//                                    res.getDescription());
//
//                            if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                YYInfo info = new YYInfo();
//                                UserInfoUtils.unPack(res.getUserData(), info);
//
//                                info.mTS = res.getServerTime();
//                                info.mUrl = res.getUrl();
//                                info.extjsstr = res.getExt();
//
//                                callback.onSuccess(i, info);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_REGISTER_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_REGISTER_CODE,
//                                        res.getErrcodeValue(),
//                                        res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i(AuthCoreServer.TAG,
//                                    "login by sms call fail,acc=" + account + ",reqId=" + i +
//                                            ",exceptionDesc:" +
//                                            e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "smsRegister";
//                        response.mSucceed = 2;
//                        response.mUserInfo = account;
//
//                        LoginLog.i("register by sms for service fail,acc=" + account +
//                                ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int smsLogin(final String userPhoneNumber, final String smsCode,
//                        final String dynCode, final ISmsLoginCallback callback) {
//        if (TextUtils.isEmpty(userPhoneNumber)) {
//            LoginLog.i("smsLogin phone is null or empty");
//            return -1;
//        }
//        if (TextUtils.isEmpty(smsCode)) {
//            LoginLog.i("smsLogin smsCode is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("smsLogin ISmsLoginCallback is null");
//            return -1;
//        }
//        PhoneReport.report("smsLogin", userPhoneNumber);
//
//        SmsLoginReq smsLoginReq = SmsLoginReq.newBuilder()
//                .setUser(userPhoneNumber)
//                .setSmscode(smsCode)
//                .setPrheader(AuthInfo.getHeader())
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .setSessiondata(sSessionData == null ? "" : sSessionData)
//                .build();
//
//        final String func = "smsLogin";
//        final String tag = AuthCoreServer.TAG;
//
//        LoginLog.printSep(tag, func);
//        LoginLog.start(tag, func, func + " phone: " + userPhoneNumber);
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.LoginServer.LoginObj", "LoginBySms",
//                        smsLoginReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy10s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "smsLogin";
//                            response.mUserInfo = userPhoneNumber;
//                            SmsLoginRsp res =
//                                    SmsLoginRsp.newBuilder().mergeFrom(responseParam.mResponseData)
//                                            .build();
//
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                YYInfo info = new YYInfo();
//                                UserInfoUtils.unPack(res.getUserData(), info);
//                                //单位s
//                                info.mTS = res.getServerTime();
//                                info.mIsNewUser = res.getIsnewuser() == 1 ? true : false;
//                                info.mUrl = res.getUrl();
//                                info.extjsstr = res.getExtjsstr();
//
//                                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000);
//
//                                LoginLog.success(tag, func, func + " success,phoNo=" +
//                                        userPhoneNumber + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onSuccess(i, info);
//                                //反外挂检测
//                                checkAntiCode(info.mUid);
//                            } else if (res.getErrcode() == Errcode.NEXT_VER) {
//                                //需要二次验证
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//
//                                LoginLog.fail(tag, func, func + " need NextVerify,phoNo="
//                                        + userPhoneNumber + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//
//                            } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//                                //二次验证码失败
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mSucceed = 2;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//
//                                LoginLog.fail(tag, func, func + " NextVerify fail,phoNo="
//                                        + userPhoneNumber + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//                                sSessionData = res.getSessiondata();
//                                LoginLog.fail(tag, func, func + " fail,phoNo="
//                                        + userPhoneNumber + ",reqId=" + i + ",authSrvCode:" +
//                                        res.getErrcode() + ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(), res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.fail(tag, func, func + " fail,phoNo=" +
//                                    userPhoneNumber + "," + "reqId" + "=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            LoginLog.printSep(tag, func);
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "smsLogin";
//                        response.mSucceed = 2;
//                        response.mUserInfo = userPhoneNumber;
//
//                        LoginLog.fail(tag, func, func + " fail,phoNo=" + userPhoneNumber +
//                                ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 +
//                                ",svcEx:" + e.getMessage());
//                        IP ip = IpUtils.getIPAddress(appContext);
//                        if (ip.isIPv6) {
//                            LoginLog.fail(tag, func, "TYPE_MOBILE,ipv6");
//                        }
//                        LoginLog.printSep(tag, func);
//
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int smsModifyPwd(final String phone, String smsCode, String password,
//                            final ISmsModifyPwdCallback callback) {
//        if (TextUtils.isEmpty(phone)) {
//            LoginLog.i("smsModifyPwd phone is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("smsModifyPwd ISmsModifyPwdCallback is null");
//            return -1;
//        }
//        PhoneReport.report("smsModifyPwd", phone);
//
//        SmsModifyPwdReq req = SmsModifyPwdReq.newBuilder()
//                .setUser(phone)
//                .setSmscode(smsCode)
//                .setSha1Pwd(YYLoginliteUtils.getPasswdSha1(password))
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.RegisterServer.RegisterObj", "ModifyPwdBySms",
//                        req.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy10s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "smsModifyPwd";
//                            response.mErrType = 0;
//                            response.mSucceed = 0;
//                            response.mUserInfo = phone;
//
//                            SmsModifyPwdRsp res =
//                                    SmsModifyPwdRsp.newBuilder()
//                                            .mergeFrom(responseParam.mResponseData).build();
//                            response.mErrCode = res.getErrcodeValue();
//                            response.mErrDesc = res.getDescription();
//                            LoginLog.i("sms modify password call success,phoNo=" + phone +
//                                    ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                    ", authSrvDesc:" + res.getDescription());
//                            callback.onSuccess(i, res.getErrcodeValue(), res.getDescription());
//
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("sms modify password call fail,phoNo=" + phone +
//                                    ",reqId=" + i + ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "smsModifyPwd";
//                        response.mSucceed = 2;
//                        response.mUserInfo = phone;
//
//                        LoginLog.i("sms modify password for service fail,phoNo=" + phone +
//                                ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2
//                                + ",svcEx:" + e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int passwordLogin(final String account, final String password, String dynCode,
//                             final IPasswordLoginCallback callback) {
//        if (TextUtils.isEmpty(account)) {
//            LoginLog.i("passwordLogin account is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("passwordLogin IPasswordLoginCallback is null");
//            return -1;
//        }
//        PwdLoginReq pwdLoginReq = PwdLoginReq.newBuilder()
//                .setUser(account)
//                .setPassword(YYLoginliteUtils.getPasswdSha1(password))
//                .setPrheader(AuthInfo.getHeader())
//                .setDynCode(dynCode == null ? "" : dynCode)
//                .setSessiondata(sSessionData == null ? "" : sSessionData)
//                .build();
//
//        final String func = "passwordLogin";
//        final String tag = AuthCoreServer.TAG;
//
//        LoginLog.printSep(tag, func);
//        LoginLog.start(tag, func, func + " account: " + account);
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.LoginServer.LoginObj", "LoginByPwd",
//                        pwdLoginReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy5s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "passwordLogin";
//                            response.mUserInfo = account;
//
//                            PwdLoginRsp res = PwdLoginRsp.newBuilder().mergeFrom(
//                                    responseParam.mResponseData).build();
//
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                YYInfo info = new YYInfo();
//                                UserInfoUtils.unPack(res.getUserData(), info);
//                                //单位s
//                                info.mTS = res.getServerTime();
//                                info.mUrl = res.getUrl();
//                                info.extjsstr = res.getExtjsstr();
//
//                                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000);
//
//                                LoginLog.success(tag, func, func + " success,acc=" + account +
//                                        ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onSuccess(i, info);
//
//                                //反外挂检测
//                                checkAntiCode(info.mUid);
//                            } else if (res.getErrcode() == Errcode.NEXT_VER) {
//                                //需要二次验证
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//
//                                LoginLog.fail(tag, func, func +
//                                        " need NextVerify,acc=" + account +
//                                        ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//                            } else if (res.getErrcode() == Errcode.VCODE_ERR) {
//                                //二次验证码失败
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mSucceed = 2;
//                                NextVerify nextVerify = new NextVerify();
//                                nextVerify.mDynVer = res.getDynVer();
//                                sSessionData = res.getSessiondata();
//                                LoginLog.fail(tag, func, func +
//                                        " NextVerify fail,acc=" + account +
//                                        ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onNext(i, res.getErrcodeValue(), res.getDescription(),
//                                        nextVerify);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//                                sSessionData = res.getSessiondata();
//                                LoginLog.fail(tag, func, func + " fail,acc=" + account +
//                                        ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(), res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.fail(tag, func, func + " fail,acc=" +
//                                    account + ",reqId=" + i + ",exceptionDesc:" +
//                                    e.getMessage());
//                            LoginLog.printSep(tag, func);
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "passwordLogin";
//                        response.mSucceed = 2;
//                        response.mUserInfo = account;
//
//                        LoginLog.fail(tag, func, func + " fail,acc=" + account +
//                                ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 +
//                                ",svcEx:" + e.getMessage());
//                        IP ip = IpUtils.getIPAddress(appContext);
//                        if (ip.isIPv6) {
//                            LoginLog.fail(tag, func, "TYPE_MOBILE,ipv6");
//                        }
//                        LoginLog.printSep(tag, func);
//
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int creditLogin(final long yyuid, final ICreditLoginCallback callback) {
//        if (callback == null) {
//            LoginLog.i("creditLogin ICreditLoginCallback is null");
//            return -1;
//        }
//        String credit = AuthInfo.getCredit(yyuid);
//        if (credit.isEmpty()) {
//            LoginLog.i("creditLogin credit is empty");
//            final int reqId = (int) (System.currentTimeMillis());
//            sMainHandler.post(new Runnable() {
//                @Override
//                public void run() {
//                    HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                    response.mRtt = 0;
//                    response.mEventType = "creditLogin";
//                    response.mUserInfo = String.valueOf(yyuid);
//
//                    response.mErrType = ResCodeDef.Type.AUTH_SDK_CODE + 1;
//                    response.mErrCode = ResCodeDef.AuthSdkErrorCode.NoCredit;
//                    response.mSucceed = 1;
//                    response.mErrDesc =
//                            ResCodeDef.AuthSdkErrorCode.desc(ResCodeDef.AuthSdkErrorCode.NoCredit);
//
//                    response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                    response.mTraceId = String.valueOf(System.currentTimeMillis());
//                    HiidoReport.getInstance().report2Hido(response);
//                    HiidoReport.getInstance().report2Metric(response);
//
//                    callback.onFail(reqId, ResCodeDef.Type.AUTH_SDK_CODE,
//                            ResCodeDef.AuthSdkErrorCode.NoCredit,
//                            ResCodeDef.AuthSdkErrorCode.desc(ResCodeDef.AuthSdkErrorCode.NoCredit));
//                }
//            });
//            return -1;
//        }
//
//        return creditLogin(yyuid, credit, callback);
//    }
//
//    @Override
//    public int creditLogin(final long yyuid, final String credit,
//                           final ICreditLoginCallback callback) {
//        if (yyuid == 0 || credit.isEmpty()) {
//            LoginLog.i("creditLogin uid is 0, or credit is empty");
//            return -1;
//        }
//
//        CreditLoginReq creditLoginReq = CreditLoginReq.newBuilder()
//                .setUser(String.valueOf(yyuid))
//                .setCredit(credit)
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        final String func = "creditLogin";
//        final String tag = AuthCoreServer.TAG;
//        LoginLog.printSep(tag, func);
//        LoginLog.start(tag, func, func + " yyuid: " + yyuid);
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.LoginServer.LoginObj", "LoginByCredit",
//                        creditLoginReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy5s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "creditLogin";
//                            response.mUserInfo = String.valueOf(yyuid);
//
//                            CreditLoginRsp res = CreditLoginRsp.newBuilder().mergeFrom(
//                                    responseParam.mResponseData).build();
//
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                YYInfo info = new YYInfo();
//                                UserInfoUtils.unPack(res.getUserData(), info);
//                                //单位s
//                                info.mTS = res.getServerTime();
//                                info.mIsNewUser = false;
//                                info.mUrl = res.getUrl();
//                                info.extjsstr = res.getExtjsstr();
//
//                                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000);
//
//                                LoginLog.success(tag, func, func + " success,uid=" +
//                                        yyuid + ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onSuccess(i, info);
//
//                                //反外挂检测
//                                checkAntiCode(info.mUid);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//
//                                LoginLog.fail(tag, func, func + " fail,uid=" +
//                                        yyuid + ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                        ", authSrvDesc:" + res.getDescription());
//                                LoginLog.printSep(tag, func);
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(),
//                                        res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            if (NetworkUtil.isNetworkConnected()) {
//                                HiidoReport.getInstance().report2Hido(response);
//                                HiidoReport.getInstance().report2Metric(response);
//                            }
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.fail(tag, func, func + " fail,uid=" + yyuid + "," +
//                                    "reqId" + "=" + i + "," + "exceptionDesc:" + e.getMessage());
//                            LoginLog.printSep(tag, func);
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "creditLogin";
//                        response.mSucceed = 2;
//                        response.mUserInfo = String.valueOf(yyuid);
//
//                        LoginLog.fail(tag, func, func + " fail,uid=" + yyuid +
//                                ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 +
//                                ",svcEx:" + e.getMessage());
//                        IP ip = IpUtils.getIPAddress(appContext);
//                        if (ip.isIPv6) {
//                            LoginLog.fail(tag, func, "TYPE_MOBILE,ipv6");
//                        }
//                        LoginLog.printSep(tag, func);
//
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//
//                        if (NetworkUtil.isNetworkConnected()) {
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//                        }
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int thirdLoginWithBindPhone(
//            String channel, String token, int tokenType,
//            String openid, String authUrl, String lang, IThirdLoginCallback callback
//    ) {
//        if (TextUtils.isEmpty(channel)) {
//            LoginLog.i("thirdLoginWithBindPhone channel is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("thirdLoginWithBindPhone IThirdLoginCallback is null");
//            return -1;
//        }
//
//        String bindPhone = "{\"bind_mobile\":\"true\"}";
//        return innerThirdLogin(channel, token, tokenType, openid, authUrl, bindPhone,
//                true, lang, callback);
//    }
//
//    @Override
//    public int thirdLogin(
//            String channel, String token, int tokenType,
//            String openid, String authUrl, String extInfo, IThirdLoginCallback callback
//    ) {
//        if (TextUtils.isEmpty(channel)) {
//            LoginLog.i("thirdLogin channel is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("thirdLogin IThirdLoginCallback is null");
//            return -1;
//        }
//        return innerThirdLogin(channel, token, tokenType, openid, authUrl, extInfo,
//                false, "", callback);
//    }
//
//    private int innerThirdLogin(
//            final String channel, final String token, final int tokenType,
//            final String openid, final String authUrl, final String extInfo,
//            final boolean isBindPhone, final String lang,
//            final IThirdLoginCallback callback
//    ) {
//        ThirdloginReq thirdLoginReq = ThirdloginReq.newBuilder()
//                .setVersion(1)
//                .setAppid(AuthInfo.getHeader().getAppId())
//                .setChannel(channel)
//                .setToken(token)
//                .setTokenType(tokenType)
//                .setOpenid(openid)
//                .setAuthUrl(authUrl)
//                .setDeviceid(AuthInfo.getHeader().getDeviceId())
//                .setClientSys(AuthInfo.getHeader().getSys())
//                .setExtInfo(extInfo)
//                .setRegion(AuthInfo.getHeader().getRegion())
//                .build();
//
//        final String func = "thirdLogin";
//        final String tag = AuthCoreServer.TAG;
//        LoginLog.printSep(tag, func);
//        LoginLog.start(tag, func, func + ": " + thirdLoginReq.toString());
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.ThirdloginServer.ThirdloginObj", "Thirdlogin",
//                        thirdLoginReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy5s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "thirdLogin";
//                            response.mUserInfo = token;
//
//                            ThirdloginRsp res = ThirdloginRsp.newBuilder().mergeFrom(
//                                    responseParam.mResponseData).build();
//
//                            if (res.getRescode().equals("0")) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                JSONObject jsonData = new JSONObject(res.getData());
//                                ThirdInfo info = new ThirdInfo();
//                                info.mUid = Long.parseLong(jsonData.getString("uid"));
//                                info.mIsNewUser = jsonData.getBoolean("newUser");
//                                info.mCredit = jsonData.getString("loginToken");
//                                info.mChannel = jsonData.getString("channel");
//                                //单位s
//                                info.mTS = jsonData.getInt("serverTime");
//                                info.mThirdInfo = jsonData.getString("thirdUser");
//
//                                info.mBizParam = jsonData.optString("busiParam");
//                                info.mExt = jsonData.optString("ext");
//
//                                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000);
//
//                                LoginLog.success(tag, func, func + " success,chanel=" +
//                                        channel + ",oid=" + openid + "," + "reqId=" + i +
//                                        ",thirdAuthSrvCode:" + res.getRescode() +
//                                        ",thirdAuthSrvDesc:" + res.getMessage());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onSuccess(i, info);
//
//                                //反外挂检测
//                                checkAntiCode(info.mUid);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = Integer.parseInt(res.getRescode());
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getMessage();
//
//                                LoginLog.fail(tag, func, func + " fail,chanel=" +
//                                        channel + ",openid=" + openid + "," + "reqId=" + i +
//                                        ",thirdAuthSrvCode:" + res.getRescode() +
//                                        ",thirdAuthSrvDesc:" + res.getMessage());
//                                LoginLog.printSep(tag, func);
//
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        Integer.parseInt(res.getRescode()), res.getMessage());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (Exception e) {
//                            LoginLog.fail(tag, func, func + " fail,chanel=" + channel +
//                                    ",oid=" + openid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            LoginLog.printSep(tag, func);
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "thirdLogin";
//                        response.mSucceed = 2;
//                        response.mUserInfo = token;
//
//                        LoginLog.fail(tag, func, func + " fail,reqId= " + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        IP ip = IpUtils.getIPAddress(appContext);
//                        if (ip.isIPv6) {
//                            LoginLog.fail(tag, func, "TYPE_MOBILE,ipv6");
//                        }
//                        LoginLog.printSep(tag, func);
//
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public byte[] getOtp(String destAppId, long uid) {
//        return AuthInfo.getOtp(destAppId, uid);
//    }
//
//    @Override
//    public byte[] getServiceToken(long uid) {
//        return AuthInfo.getServiceOtp(uid);
//    }
//
//    @Override
//    public void logout(boolean enableAutoLoginNext) {
//        LoginLog.clear();
//        AuthInfo.logout(enableAutoLoginNext);
//    }
//
//    @Override
//    public int qrScan(final long yyuid, String qrId, final IQrScanCallback callback) {
//        QrScanReq qrScanReq = QrScanReq.newBuilder()
//                .setUser(String.valueOf(yyuid))
//                .setQrcodeId(qrId)
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.QrServer.QrObj", "QrScan",
//                        qrScanReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option,
//                new IRPCChannel.RPCCallback<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, RPCTask.ResponseParam responseParam) {
//                        try {
//                            QrScanRsp res =
//                                    QrScanRsp.newBuilder().mergeFrom(responseParam.mResponseData)
//                                            .build();
//                            LoginLog.i("qr scan success,uid=" + yyuid + ",reqId=" + i +
//                                    ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" +
//                                    res.getDescription());
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                callback.onSuccess(i, res.getAppinfo());
//                            } else {
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(),
//                                        res.getDescription());
//                            }
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("qr scan fail,uid=" + yyuid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, int i1, int i2, Exception e) {
//                        LoginLog.i("qr scan for service fail,uid=" + yyuid + ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int qrAuthConfirm(final long yyuid, String qrId, final IQrConfirmCallback callback) {
//        String otp = new String(AuthInfo.getOtp("", yyuid));
//        QrConfirmReq qrConfirmReq = QrConfirmReq.newBuilder()
//                .setUser(String.valueOf(yyuid))
//                .setQrcodeId(qrId)
//                .setOtp(otp)
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.QrServer.QrObj", "QrConfirm",
//                        qrConfirmReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option,
//                new IRPCChannel.RPCCallback<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, RPCTask.ResponseParam responseParam) {
//                        try {
//                            QrConfirmRsp res =
//                                    QrConfirmRsp.newBuilder().mergeFrom(responseParam.mResponseData)
//                                            .build();
//                            LoginLog.i("qr auth confirm success,uid=" + yyuid + ",reqId=" + i +
//                                    ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" +
//                                    res.getDescription());
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                callback.onSuccess(i);
//                            } else {
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(),
//                                        res.getDescription());
//                            }
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("qr auth confirm fail,uid=" + yyuid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, int i1, int i2, Exception e) {
//                        LoginLog.i("qr auth confirm for service fail,uid=" + yyuid + ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int qrAuthCancel(final long yyuid, String qrId, final IQrCancelCallback callback) {
//        QrCancelReq qrCancelReq = QrCancelReq.newBuilder()
//                .setUser(String.valueOf(yyuid))
//                .setQrcodeId(qrId)
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.QrServer.QrObj", "QrCancel",
//                        qrCancelReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            QrCancelRsp res =
//                                    QrCancelRsp.newBuilder().mergeFrom(responseParam.mResponseData)
//                                            .build();
//                            LoginLog.i("qr auth cancel success,uid=" + yyuid + ",reqId=" + i +
//                                    ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" +
//                                    res.getDescription());
//                            if (res.getErrcode() == Errcode.SUCCESS) {
//                                callback.onSuccess(i);
//                            } else {
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        res.getErrcodeValue(), res.getDescription());
//                            }
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("qr auth cancel fail,uid=" + yyuid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        LoginLog.i("qr auth cancel for service fail,uid=" + yyuid + ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int bindMobilePhone(final String phoNum, final long uid, String smsCode,
//                               final IBindMobilePhoneCallback callback) {
//        if (TextUtils.isEmpty(phoNum)) {
//            LoginLog.i("bindMobilePhone phone is null or empty");
//            return -1;
//        }
//        if (TextUtils.isEmpty(smsCode)) {
//            LoginLog.i("bindMobilePhone smsCode is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("bindMobilePhone IBindMobilePhoneCallback is null");
//            return -1;
//        }
//        PhoneReport.report("bindMobilePhone", phoNum);
//
//        BindMobileReq req = BindMobileReq.newBuilder().build().newBuilder()
//                .setUser(String.valueOf(uid))
//                .setMobile(phoNum)
//                .setSmscode(smsCode)
//                .setOtp(new String(getOtp("", uid)))
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.RegisterServer.RegisterObj", "BindMobile",
//                        req.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "BindMobile";
//
//                            BindMobileRsp res =
//                                    BindMobileRsp.newBuilder()
//                                            .mergeFrom(responseParam.mResponseData).build();
//                            LoginLog.i("bind by sms call success,phoNum=" + phoNum + ",uid=" + uid +
//                                    ",reqId=" + i + ",authSrvCode:" + res.getErrcode() +
//                                    ", authSrvDesc:" + res.getDescription());
//
//                            if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//                                callback.onSuccess(i);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_REGISTER_CODE + 1;
//                                response.mErrCode = res.getErrcodeValue();
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getDescription();
//
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_REGISTER_CODE,
//                                        res.getErrcodeValue(),
//                                        res.getDescription());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("bind by sms call fail,phoNum=" + phoNum + ",uid=" + uid +
//                                    ",reqId=" + i + ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "smsRegister";
//                        response.mSucceed = 2;
//
//                        LoginLog.i("bind by sms for service fail,phoNum=" + phoNum + ",uid=" + uid +
//                                ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 +
//                                ",svcEx:" + e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int bindThirdToken(String channel, String token, int tokenType, String openid,
//                              String uid, String optToken,
//                              String authUrl, String extInfo, IThirdLoginCallback callback) {
//        if (TextUtils.isEmpty(channel)) {
//            LoginLog.i("bindThirdToken channel is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("bindThirdToken IThirdLoginCallback is null");
//            return -1;
//        }
//        int ret = bindThirdTokenFromService(channel, token, tokenType, openid, uid, optToken, authUrl,
//                extInfo, callback);
//        return ret;
//    }
//
//    public int bindThirdTokenFromService(
//            final String channel,
//            final String token,
//            int tokenType,
//            final String openid,
//            String uid,
//            String optToken,
//            String authUrl,
//            String extInfo,
//            final IThirdLoginCallback callback
//    ) {
//        LoginLog.i("bind third token from service,uid=" + uid + ", optToken=" + optToken);
//        ThirdloginReq thirdLoginReq = ThirdloginReq.newBuilder()
//                .setVersion(1)
//                .setAppid(AuthInfo.getHeader().getAppId())
//                .setChannel(channel)
//                .setToken(token)
//                .setTokenType(tokenType)
//                .setOpenid(openid)
//                .setUid(uid)
//                .setOptToken(optToken)
//                .setAuthUrl(authUrl)
//                .setDeviceid(AuthInfo.getHeader().getDeviceId())
//                .setClientSys(AuthInfo.getHeader().getSys())
//                .setExtInfo(extInfo)
//                .setRegion(AuthInfo.getHeader().getRegion())
//                .build();
//
//        Map<String, String> routes = new HashMap<>();
//        String regionSet = AuthInfo.getRegionSet();
//        if (regionSet != null) {
//            routes.put(AuthInfo.getRegionSetKey(), regionSet);
//        }
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("", "UdbApp.ThirdloginServer.ThirdloginObj",
//                        "BindThirdUserByUid",
//                        thirdLoginReq.toByteArray(), "", routes, null, null);
//
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, sBRetryStrategy5s);
//
//        final long bTime = System.currentTimeMillis();
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            long eTime = System.currentTimeMillis();
//                            long rtt = eTime - bTime;
//
//                            HiidoReport.CReportResponse response =
//                                    new HiidoReport.CReportResponse();
//                            response.mRtt = rtt;
//                            response.mEventType = "bindThirdUserByUid";
//                            response.mUserInfo = token;
//
//                            ThirdloginRsp res = ThirdloginRsp.newBuilder()
//                                    .mergeFrom(responseParam.mResponseData).build();
//                            if (res.getRescode().equals("0")) {
//                                response.mErrCode = 0;
//                                response.mErrType = 0;
//                                response.mSucceed = 0;
//
//                                JSONObject jsonData = new JSONObject(res.getData());
//                                ThirdInfo info = new ThirdInfo();
//                                info.mUid = Long.parseLong(jsonData.getString("uid"));
//                                info.mIsNewUser = jsonData.getBoolean("newUser");
//                                info.mChannel = jsonData.getString("channel");
//                                //单位s
//                                info.mTS = jsonData.getInt("serverTime");
//                                info.mThirdInfo = jsonData.getString("thirdUser");
//                                info.mBizParam = jsonData.optString("busiParam");
//                                info.mExt = jsonData.optString("ext");
//
//                                LoginLog.i("bind third token success" +
//                                        ",chanel=" + channel + ",oid=" + openid + ",reqId=" + i +
//                                        ",thirdAuthSrvCode:" + res.getRescode() +
//                                        ",thirdAuthSrvDesc:" + res.getMessage() +
//                                        ",data:" + res.getData() + ",ts=" + info.mTS);
//                                callback.onSuccess(i, info);
//                            } else {
//                                response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
//                                response.mErrCode = Integer.parseInt(res.getRescode());
//                                response.mSucceed = 2;
//                                response.mErrDesc = res.getMessage();
//
//                                LoginLog.i("bind third token fail" +
//                                        ",chanel=" + channel + ",oid=" + openid + ",reqId=" + i +
//                                        ",thidAuthSrvCode:" + res.getRescode() +
//                                        ", thirdAuthSrvDesc:" + res.getMessage());
//                                callback.onFail(i, ResCodeDef.Type.AUTH_SRV_CODE,
//                                        Integer.parseInt(res.getRescode()),
//                                        res.getMessage());
//                            }
//                            response.mNetOptimize =
//                                    YYServiceCore.getInstance().getNetOptimizeSwitch();
//                            response.mTraceId = traceId;
//
//                            HiidoReport.getInstance().report2Hido(response);
//                            HiidoReport.getInstance().report2Metric(response);
//
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("bind third token call fail" +
//                                    ",chanel=" + channel + ",oid=" + openid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        } catch (JSONException e) {
//                            LoginLog.i("bind third token call fail" +
//                                    ",chanel=" + channel + ",oid=" + openid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        } catch (NumberFormatException e) {
//                            LoginLog.i("bind third token call fail" +
//                                    ",chanel=" + channel + ",oid=" + openid + ",reqId=" + i +
//                                    ",exceptionDesc:" + e.getMessage());
//                            callback.onFail(i, ResCodeDef.Type.AUTH_SDK_CODE,
//                                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol,
//                                    e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        long eTime = System.currentTimeMillis();
//                        long rtt = eTime - bTime;
//
//                        HiidoReport.CReportResponse response = new HiidoReport.CReportResponse();
//                        response.mRtt = rtt;
//                        response.mEventType = "bindThirdUserByUid";
//                        response.mSucceed = 2;
//                        response.mUserInfo = token;
//
//                        LoginLog.i("bind third token for service fail,reqId= " + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        if (i1 != ConstCode.SdkResCode.RECV_RESPONSE) {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SDK_CODE + 1;
//                            response.mErrCode = i1;
//                            response.mErrDesc = ConstCode.SdkResCode.desc(i1);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SDK_CODE, i1,
//                                    ConstCode.SdkResCode.desc(i1));
//                        } else {
//                            response.mErrType = ResCodeDef.Type.SERVICE_SRV_CODE + 1;
//                            response.mErrCode = i2;
//                            response.mErrDesc = ConstCode.SrvResCode.desc(i2);
//
//                            callback.onFail(i, ResCodeDef.Type.SERVICE_SRV_CODE, i2,
//                                    ConstCode.SrvResCode.desc(i2));
//                        }
//                        response.mNetOptimize = YYServiceCore.getInstance().getNetOptimizeSwitch();
//                        response.mTraceId = traceId;
//
//                        HiidoReport.getInstance().report2Hido(response);
//                        HiidoReport.getInstance().report2Metric(response);
//                    }
//                });
//        return reqId;
//    }
//
//    @Override
//    public int getSmsWithBusiType(
//            String phoneNum,
//            String smsType,
//            String smsLength,
//            int useType,
//            String otp,
//            String dynCode,
//            IGetSmsCallback callback
//    ) {
//        if (TextUtils.isEmpty(phoneNum)) {
//            LoginLog.i("getSmsWithBusiType phone is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("getSmsWithBusiType IGetSmsCallback is null");
//            return -1;
//        }
//        PhoneReport.report("getSmsWithBusiType", phoneNum);
//        GetSmsWithBusiTypeRPC rpc;
//        rpc = new GetSmsWithBusiTypeRPC(phoneNum, smsType, smsLength, useType, otp, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    @Override
//    public int verifySmsCode(String phoneNum, String verifyCode, int useType,
//                             String otp, String dynCode, IBaseCallBack callback) {
//        if (TextUtils.isEmpty(phoneNum)) {
//            LoginLog.i("verifySmsCode phone is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("verifySmsCode IBaseCallBack is null");
//            return -1;
//        }
//        PhoneReport.report("verifySmsCode", phoneNum);
//        VerifySmsCodeRPC rpc;
//        rpc = new VerifySmsCodeRPC(phoneNum, verifyCode, useType, otp, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    @Override
//    public int getEmailVerifyCode(String email, String codeLen, int useType, String otp,
//                                  String dynCode, IBaseCallBack callback) {
//        if (TextUtils.isEmpty(email)) {
//            LoginLog.i("getEmailVerifyCode email is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("getEmailVerifyCode IBaseCallBack is null");
//            return -1;
//        }
//        GetEmailVerifyCodeRPC rpc;
//        rpc = new GetEmailVerifyCodeRPC(email, codeLen, useType, otp, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    @Override
//    public int verifyEmailCode(String email, String verifyCode, int useType, String otp,
//                               String dynCode, IBaseCallBack callback) {
//        if (TextUtils.isEmpty(email)) {
//            LoginLog.i("verifyEmailCode email is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("verifyEmailCode IBaseCallBack is null");
//            return -1;
//        }
//        VerifyEmailCodeRPC rpc;
//        rpc = new VerifyEmailCodeRPC(email, verifyCode, useType, otp, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    @Override
//    public int registerByVerifyCode(String account, String verifyCode, String password,
//                                    String dynCode, IAuthInfoCallBack callback) {
//        if (TextUtils.isEmpty(account)) {
//            LoginLog.i("registerByVerifyCode account is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("registerByVerifyCode IAuthInfoCallBack is null");
//            return -1;
//        }
//        RegisterByVerifyCodeRPC rpc;
//        rpc = new RegisterByVerifyCodeRPC(account, verifyCode, password, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    @Override
//    public int modifyPwdByVerifyCode(String account, String verifyCode, String password, String otp,
//                                     String dynCode, IBaseCallBack callback) {
//        if (TextUtils.isEmpty(account)) {
//            LoginLog.i("modifyPwdByVerifyCode account is null or empty");
//            return -1;
//        }
//        if (callback == null) {
//            LoginLog.i("modifyPwdByVerifyCode IBaseCallBack is null");
//            return -1;
//        }
//        ModifyPwdByVerifyCodeRPC rpc;
//        rpc = new ModifyPwdByVerifyCodeRPC(account, verifyCode, password, otp, dynCode, callback);
//        int ret = rpc.run();
//        return ret;
//    }
//
//    private int checkAntiCode(final long yyuid) {
//        if (AuthInfo.isOverseas()) {
//            return checkAntiCodeHw(yyuid);
//        } else {
//            return checkAntiCodeCn(yyuid);
//        }
//    }
//
//    private int checkAntiCodeHw(final long yyuid) {
//        String bizName = AuthInfo.getAntiBizName();
//        if (bizName == null || bizName.isEmpty()) {
//            LoginLog.i("no anti_hw bizName for check anticode");
//            return -1;
//        }
//        AntiGetSdkCodeReqHw req = AntiGetSdkCodeReqHw.newBuilder()
//                .setBizName(bizName)
//                .setUid(yyuid)
//                .setIp(0)
//                .build();
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("svc_anti_codegetverify_service_hw", "AntiGetSdkCodeReqHw",
//                        req.toByteArray());
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        ArrayList<Integer> strategy = new ArrayList<Integer>();
//        strategy.add(new Integer(5000));
//        strategy.add(new Integer(5000));
//        strategy.add(new Integer(5000));
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, strategy);
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            AntiGetSdkCodeRspHw res = AntiGetSdkCodeRspHw.newBuilder().mergeFrom(
//                                    responseParam.mResponseData).build();
//                            LoginLog.i("check anticodehw success");
//
//                            //执行反外挂码
//                            ByteString codeByte = res.getCode();
//                            runAntiCodeHw(res.getUid(),
//                                    codeByte == null ? "".getBytes() : codeByte.toByteArray());
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("check anticodehw fail,exceptionDesc:" + e.getMessage());
//                        } catch (Throwable e) {
//                            LoginLog.i("check anticodehw fail,exceptionDesc:" + e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        LoginLog.i("check anticode for service fail, " +
//                                "traceId=" + traceId + ",uid=" + yyuid + ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                        copyLog("AntiGetSdkCodeReqHw: " + traceId + " " + e.getMessage());
//                    }
//                });
//        return reqId;
//    }
//
//    private void runAntiCodeHw(final long yyuid, final byte[] code) {
//        new Thread(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    String bizName = AuthInfo.getAntiBizName();
//                    if (bizName == null || bizName.isEmpty()) {
//                        LoginLog.i("no anti bizName for run anticodeHw");
//                        return;
//                    }
//                    DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());
//                    byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
//                            code == null ? "".getBytes() : code,
//                            AuthInfo.getAppId(), 0);
//                    byte[] token = getServiceToken(yyuid);
//                    AntiVerifySdkResultReqHw req = AntiVerifySdkResultReqHw.newBuilder()
//                            .setBizName(bizName)
//                            .setUid(yyuid)
//                            .setResult(ByteString
//                                    .copyFrom(execCode == null ? "".getBytes() : execCode))
//                            .setIp(0)
//                            .setTokenType(0)
//                            .setToken(ByteString.copyFrom(token == null ? "".getBytes() : token))
//                            .build();
//
//                    RPCTask.RequestParam requestParam =
//                            new RPCTask.RequestParam("svc_anti_codegetverify_service_hw",
//                                    "AntiVerifySdkResultReqHw",
//                                    req.toByteArray());
//                    Bundle option = new Bundle();
//                    option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//                    ArrayList<Integer> strategy = new ArrayList<Integer>();
//                    strategy.add(new Integer(5000));
//                    strategy.add(new Integer(5000));
//                    strategy.add(new Integer(5000));
//                    option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, strategy);
//
//                    int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                            new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                                @Override
//                                public void onSuccess(int i, String traceId,
//                                                      RPCTask.ResponseParam responseParam) {
//                                    try {
//                                        AntiVerifySdkResultRspHw res =
//                                                AntiVerifySdkResultRspHw.newBuilder()
//                                                        .mergeFrom(responseParam.mResponseData)
//                                                        .build();
//                                        LoginLog.i("verify result success,antiVerifyResCodeHw=" +
//                                                res.getRes());
//                                    } catch (InvalidProtocolBufferException e) {
//                                        LoginLog.i("verify result fail,exceptionDesc:" +
//                                                e.getMessage());
//                                    }
//                                }
//
//                                @Override
//                                public void onFail(int i, String traceId, int i1, int i2,
//                                                   Exception e) {
//                                    LoginLog.i("check anticodeHw for service fail,uid=" + yyuid +
//                                            ",reqId=" + i + ",svcSdkCode:" + i1 + ",svcSrvCode: " +
//                                            i2 + ",svcEx:" + e.getMessage());
//                                    copyLog("AntiVerifySdkResultReqHw: " + traceId + " " +
//                                            e.getMessage());
//                                }
//                            });
//                } catch (Throwable e) {
//                    LoginLog.i("antiCodeHw run,exceptionDesc:" + e.getMessage());
//                }
//            }
//        }).start();
//    }
//
//    private void copyLog(String text) {
//        //获取剪贴板管理器：
//        ClipboardManager cm = (ClipboardManager) AuthInfo.getAppContext()
//                .getSystemService(Context.CLIPBOARD_SERVICE);
//        // 创建普通字符型ClipData
//        ClipData mClipData = ClipData.newPlainText("Label", text);
//        // 将ClipData内容放到系统剪贴板里。
//        cm.setPrimaryClip(mClipData);
//    }
//
//    private int checkAntiCodeCn(final long yyuid) {
//        String bizName = AuthInfo.getAntiBizName();
//        if (bizName == null || bizName.isEmpty()) {
//            LoginLog.i(AuthCoreServer.TAG, "no anti bizName for check anticode");
//            return -1;
//        }
//        AntiGetSdkCodeReq req = AntiGetSdkCodeReq.newBuilder()
//                .setBizName(bizName)
//                .setUid(yyuid)
//                .setIp(0)
//                .build();
//        RPCTask.RequestParam requestParam =
//                new RPCTask.RequestParam("svc_anti_codegetverify", "AntiGetSdkCodeReq",
//                        req.toByteArray());
//        Bundle option = new Bundle();
//        option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//        ArrayList<Integer> strategy = new ArrayList<Integer>();
//        strategy.add(new Integer(5000));
//        strategy.add(new Integer(5000));
//        strategy.add(new Integer(5000));
//        option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, strategy);
//
//        int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                    @Override
//                    public void onSuccess(int i, String traceId,
//                                          RPCTask.ResponseParam responseParam) {
//                        try {
//                            AntiGetSdkCodeRsp res = AntiGetSdkCodeRsp.newBuilder()
//                                    .mergeFrom(responseParam.mResponseData).build();
//                            LoginLog.i("check anticode success");
//                            //执行反外挂码
//                            ByteString codeByte = res.getCode();
//                            runAntiCodeCn(res.getUid(),
//                                    codeByte == null ? "".getBytes() : codeByte.toByteArray());
//                        } catch (InvalidProtocolBufferException e) {
//                            LoginLog.i("check anticode fail,exceptionDesc:" + e.getMessage());
//                        } catch (Throwable e) {
//                            LoginLog.i("check anticode fail,exceptionDesc:" + e.getMessage());
//                        }
//                    }
//
//                    @Override
//                    public void onFail(int i, String traceId, int i1, int i2, Exception e) {
//                        LoginLog.i("check anticode for service fail,uid=" + yyuid + ",reqId=" + i +
//                                ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 + ",svcEx:" +
//                                e.getMessage());
//                    }
//                });
//        return reqId;
//    }
//
//    private void runAntiCodeCn(final long yyuid, final byte[] code) {
//        new Thread(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    String bizName = AuthInfo.getAntiBizName();
//                    if (bizName == null || bizName.isEmpty()) {
//                        LoginLog.i(AuthCoreServer.TAG, "no anti bizName for run anticode");
//                        return;
//                    }
//                    DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());
//                    byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
//                            code == null ? "".getBytes() : code,
//                            AuthInfo.getAppId(), 0);
//                    byte[] token = getServiceToken(yyuid);
//                    AntiVerifySdkResultReq req = AntiVerifySdkResultReq.newBuilder()
//                            .setBizName(bizName)
//                            .setUid(yyuid)
//                            .setResult(ByteString
//                                    .copyFrom(execCode == null ? "".getBytes() : execCode))
//                            .setIp(0)
//                            .setTokenType(0)
//                            .setToken(ByteString.copyFrom(token == null ? "".getBytes() : token))
//                            .build();
//
//                    RPCTask.RequestParam requestParam =
//                            new RPCTask.RequestParam("svc_anti_codegetverify",
//                                    "AntiVerifySdkResultReq",
//                                    req.toByteArray());
//                    Bundle option = new Bundle();
//                    option.putBoolean(TaskOptions.OPT_NEVERBIND, true);
//                    ArrayList<Integer> strategy = new ArrayList<Integer>();
//                    strategy.add(new Integer(5000));
//                    strategy.add(new Integer(5000));
//                    strategy.add(new Integer(5000));
//                    option.putIntegerArrayList(TaskOptions.OPT_RETRYSTRATEGY, strategy);
//
//                    int reqId = YYServiceCore.getInstance().rpcCall(requestParam, option, null,
//                            new IRPCChannel.RPCCallbackWithTrace<RPCTask.ResponseParam>() {
//                                @Override
//                                public void onSuccess(int i, String traceId,
//                                                      RPCTask.ResponseParam responseParam) {
//                                    try {
//                                        AntiVerifySdkResultRsp res;
//                                        res = AntiVerifySdkResultRsp.newBuilder()
//                                                .mergeFrom(responseParam.mResponseData)
//                                                .build();
//                                        LoginLog.i("verify result success,antiVerifyResCode=" +
//                                                res.getRes());
//                                    } catch (InvalidProtocolBufferException e) {
//                                        LoginLog.i("verify result fail,exceptionDesc:" +
//                                                e.getMessage());
//                                    }
//                                }
//
//                                @Override
//                                public void onFail(int i, String traceId, int i1, int i2,
//                                                   Exception e) {
//                                    LoginLog.i("check anticode for service fail,uid=" + yyuid +
//                                            ",reqId=" + i +
//                                            ",svcSdkCode:" + i1 + ",svcSrvCode: " + i2 +
//                                            ",svcEx:" + e.getMessage());
//                                }
//                            });
//                } catch (Throwable e) {
//                    LoginLog.i("anti code run,exceptionDesc:" + e.getMessage());
//                }
//            }
//        }).start();
//    }
//
//    protected static native byte[] getOtp(long yyuid,
//                                          //单位是s
//                                          long createtime,
//                                          byte[] credit,
//                                          byte[] appid,
//                                          byte[] descAppid,
//                                          byte[] deviceId,
//                                          byte[] nonce);
//
//}