package com.yy.platform.loginlite;

public class AuthConfig {
    // 是否启动风控策略
    private boolean isEnableRisk = true;
    // 是否由sdk实现二次认证
    private boolean isSdkAccomplish = true;
    // 是否使用海外版风控sdk
    private boolean isOverseas = false;

    public AuthConfig(AuthConfigBuilder builder) {
        if (builder != null) {
            isEnableRisk = builder.isEnableRisk;
            isSdkAccomplish = builder.isSdkAccomplish;
            isOverseas = builder.isOverseas;
        }
    }

    public boolean isEnableRisk() {
        return isEnableRisk;
    }

    public void setEnableRisk(boolean enableRisk) {
        isEnableRisk = enableRisk;
    }

    public boolean isSdkAccomplish() {
        return isSdkAccomplish;
    }

    public void setSdkAccomplish(boolean sdkAccomplish) {
        isSdkAccomplish = sdkAccomplish;
    }

    public boolean isOverseas() {
        return isOverseas;
    }

    public void setOverseas(boolean overseas) {
        isOverseas = overseas;
    }

    public static class AuthConfigBuilder {
        // 是否启动风控策略
        private boolean isEnableRisk = true;
        // 是否由sdk实现二次认证和第三方登录绑定手机号
        private boolean isSdkAccomplish = true;
        // 是否使用风控海外
        private boolean isOverseas = false;

        public AuthConfigBuilder() {

        }

        public AuthConfigBuilder setEnableRisk(boolean enableRisk) {
            this.isEnableRisk = enableRisk;
            return this;
        }

        public AuthConfigBuilder setSdkAccomplish(boolean sdkAccomplish) {
            this.isSdkAccomplish = sdkAccomplish;
            return this;
        }

        public AuthConfigBuilder setOverseas(boolean isOverseas) {
            this.isOverseas = isOverseas;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this);
        }
    }
}
